/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.batch.SimulateBatch;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.builtin.SimulateSpell;
import com.elmakers.mine.bukkit.utilities.TextUtils;
import com.elmakers.mine.bukkit.utility.AscendingPair;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.configuration.ConfigurationSection;

public class AnimateSpell
extends SimulateSpell {
    private static Random random = new Random();
    private LinkedList<WeightedPair<Integer>> levelWeights = null;
    public static final String[] ANIMATE_PARAMETERS = new String[]{"animate", "sim_check_destructible", "seed_radius", "restricted", "obworld", "btarget"};

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        BlockFace powerFace;
        if (parameters.getBoolean("animate", false)) {
            return super.onCast(parameters);
        }
        final Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialAndData targetMaterial = new MaterialAndData(targetBlock);
        if (parameters.contains("material")) {
            targetMaterial = ConfigurationUtils.getMaterialAndData(parameters, "material", targetMaterial);
            this.addDestructible(targetMaterial.getMaterial());
        }
        if (!this.mage.isSuperPowered()) {
            String customRestricted;
            Set<Material> restricted = this.controller.getMaterialSet("restricted");
            if (restricted.contains(targetMaterial.getMaterial())) {
                return SpellResult.FAIL;
            }
            if (parameters.contains("restricted") && (customRestricted = parameters.getString("restricted")) != null && customRestricted.length() > 0 && !customRestricted.equals("restricted") && (restricted = this.controller.getMaterialSet(customRestricted)).contains(targetMaterial.getMaterial())) {
                return SpellResult.FAIL;
            }
        }
        if (!this.isDestructible(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int seedRadius = parameters.getInt("seed_radius", 0);
        if (seedRadius > 0) {
            for (int dx = -seedRadius; dx < seedRadius; ++dx) {
                for (int dz = -seedRadius; dz < seedRadius; ++dz) {
                    for (int dy = -seedRadius; dy < seedRadius; ++dy) {
                        Block seedBlock = targetBlock.getRelative(dx, dy, dz);
                        if (!this.isDestructible(seedBlock)) continue;
                        targetMaterial.modify(seedBlock);
                    }
                }
            }
        }
        if ((powerFace = SimulateBatch.findPowerLocation(targetBlock, targetMaterial)) == null) {
            return SpellResult.NO_TARGET;
        }
        final Block powerBlock = targetBlock.getRelative(powerFace);
        this.registerForUndo(targetBlock);
        this.registerForUndo(powerBlock);
        if (!this.isDestructible(powerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int level = 0;
        if (parameters.contains("level")) {
            level = parameters.getInt("level", level);
        } else if (this.levelWeights != null) {
            level = (Integer)RandomUtils.weightedRandom(this.levelWeights);
        }
        boolean simCheckDestructible = parameters.getBoolean("sim_check_destructible", true);
        simCheckDestructible = parameters.getBoolean("scd", simCheckDestructible);
        final String commandLine = "cast " + this.getKey() + " animate true target self cooldown 0 m " + targetMaterial.getKey() + " cd " + (simCheckDestructible ? "true" : "false") + " level " + level;
        String commandName = parameters.getString("name", "Automata");
        Messages messages = this.controller.getMessages();
        String automataType = parameters.getString("message_type", "evil");
        List<String> prefixes = messages.getAll("automata." + automataType + ".prefixes");
        List<String> suffixes = messages.getAll("automata." + automataType + ".suffixes");
        commandName = prefixes.get(random.nextInt(prefixes.size())) + " " + commandName + " " + suffixes.get(random.nextInt(suffixes.size()));
        if (level > 1) {
            commandName = commandName + " " + AnimateSpell.escapeLevel(messages, "automata.level", level);
        }
        targetBlock.setData((byte)0);
        powerBlock.setData((byte)0);
        String message = this.getMessage("cast_broadcast").replace("$name", commandName);
        if (message.length() > 0) {
            this.controller.sendToMages(message, targetBlock.getLocation());
        }
        final String commandBlockName = commandName;
        Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                targetBlock.setType(Material.COMMAND);
                BlockState commandData = targetBlock.getState();
                if (commandData != null && commandData instanceof CommandBlock) {
                    CommandBlock copyCommand = (CommandBlock)commandData;
                    copyCommand.setCommand(commandLine);
                    copyCommand.setName(commandBlockName);
                    copyCommand.update();
                }
            }
        }, (long)(SimulateBatch.POWER_DELAY_TICKS + 1));
        Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                powerBlock.setType(Material.REDSTONE_BLOCK);
            }
        }, (long)(SimulateBatch.POWER_DELAY_TICKS + 2));
        this.registerForUndo();
        return SpellResult.CAST;
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("animate") || parameterKey.equals("sim_check_destructible")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(ANIMATE_PARAMETERS));
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        super.loadTemplate(template);
        if (template.contains("levels")) {
            ConfigurationSection levelTemplate = template.getConfigurationSection("levels");
            Set levelKeys = levelTemplate.getKeys(false);
            ArrayList<AscendingPair<Float>> levels = new ArrayList<AscendingPair<Float>>();
            for (String levelString : levelKeys) {
                int n = Integer.parseInt(levelString);
                double weight = levelTemplate.getDouble(levelString);
                levels.add(new AscendingPair<Float>(n, Float.valueOf((float)weight)));
            }
            RandomUtils.extrapolateFloatList(levels);
            this.levelWeights = new LinkedList();
            float threshold = 0.0f;
            for (AscendingPair ascendingPair : levels) {
                float weight = ((Float)ascendingPair.getValue()).floatValue();
                int levelIndex = (int)ascendingPair.getIndex();
                this.levelWeights.add(new WeightedPair<Integer>(Float.valueOf(threshold += weight), Float.valueOf(weight), levelIndex));
            }
        } else {
            this.levelWeights = null;
        }
    }

    protected static String escapeLevel(Messages messages, String templateName, int level) {
        String templateString = messages.get(templateName);
        if (templateString.contains("$roman")) {
            return templateString.replace("$roman", TextUtils.roman(level));
        }
        return templateString.replace("$amount", Integer.toString(level));
    }
}

