/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.batch.UndoBatch;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    public static Set<Material> attachables;
    public static Set<Material> attachablesWall;
    protected static Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> modified;
    protected HashSet<Long> attached;
    protected List<WeakReference<Entity>> entities;
    protected List<Runnable> runnables;
    protected HashMap<UUID, EntityData> modifiedEntities;
    protected final Mage owner;
    protected final Plugin plugin;
    protected boolean undone = false;
    protected int timeToLive = 0;
    protected boolean applyPhysics = false;
    protected boolean bypass = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected long scheduledTime;
    protected UndoableSpell spell;
    protected CastContext context;
    protected UndoQueue undoQueue;
    protected UndoList next;
    protected UndoList previous;
    protected String name;
    private boolean undoEntityEffects = true;
    private Set<EntityType> undoEntityTypes = null;
    protected boolean undoBreakable = false;
    protected boolean undoReflective = false;

    public UndoList(Mage mage, String name) {
        this(mage);
        this.name = name;
    }

    public UndoList(Mage mage) {
        this.owner = mage;
        this.plugin = this.owner.getController().getPlugin();
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public void setSpell(UndoableSpell spell) {
        this.spell = spell;
        this.context = spell == null ? null : spell.getCurrentCast();
    }

    @Override
    public int size() {
        return (this.blockList == null ? 0 : this.blockList.size()) + (this.entities == null ? 0 : this.entities.size()) + (this.runnables == null ? 0 : this.runnables.size());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockList != null && !this.blockList.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    public boolean isComplete() {
        return this.undone;
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
        this.updateScheduledUndo();
    }

    @Override
    public void updateScheduledUndo() {
        if (this.timeToLive > 0) {
            this.scheduledTime = System.currentTimeMillis() + (long)this.timeToLive;
        }
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean contains(Block block) {
        if (this.blockIdMap == null) {
            return false;
        }
        Long blockId = BlockData.getBlockId(block);
        if (this.attached != null && this.attached.contains(blockId)) {
            return false;
        }
        return this.blockIdMap.contains(blockId);
    }

    @Override
    public boolean contains(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (this.blockIdMap == null || blockData == null) {
            return false;
        }
        Long blockId = blockData.getId();
        if (this.attached != null && this.attached.contains(blockId)) {
            return false;
        }
        return this.blockIdMap.contains(blockData.getId());
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (!super.add(blockData)) {
            return false;
        }
        if (this.attached != null) {
            this.attached.remove(blockData.getId());
        }
        this.modifiedTime = System.currentTimeMillis();
        if (this.bypass) {
            return true;
        }
        UndoList.register(blockData);
        blockData.setUndoList(this);
        this.addAttachable(blockData, BlockFace.NORTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.SOUTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.EAST, attachablesWall);
        this.addAttachable(blockData, BlockFace.WEST, attachablesWall);
        this.addAttachable(blockData, BlockFace.UP, attachables);
        this.addAttachable(blockData, BlockFace.DOWN, attachables);
        return true;
    }

    protected boolean addAttachable(com.elmakers.mine.bukkit.api.block.BlockData block, BlockFace direction, Set<Material> materials) {
        BlockData newBlock;
        Block testBlock = block.getBlock().getRelative(direction);
        Long blockId = BlockData.getBlockId(testBlock);
        if (this.blockIdMap != null && this.blockIdMap.contains(blockId)) {
            return false;
        }
        if (this.attached != null && this.attached.contains(blockId)) {
            return false;
        }
        Material material = testBlock.getType();
        if ((material.isBurnable() || materials != null && materials.contains(material)) && super.add(newBlock = new BlockData(testBlock))) {
            UndoList.register(newBlock);
            newBlock.setUndoList(this);
            if (this.attached == null) {
                this.attached = new HashSet();
            }
            this.attached.add(blockId);
            return true;
        }
        return false;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData register(Block block) {
        BlockData blockData = new BlockData(block);
        UndoList.register(blockData);
        return blockData;
    }

    public static void register(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = modified.get(blockData.getId());
        if (priorState != null) {
            priorState.setNextState(blockData);
            blockData.setPriorState(priorState);
        }
        modified.put(blockData.getId(), blockData);
    }

    @Override
    public void commit() {
        this.unlink();
        if (this.blockList == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockList) {
            this.commit(block);
        }
    }

    public void commit(com.elmakers.mine.bukkit.api.block.BlockData block) {
        modified.remove(block.getId());
        com.elmakers.mine.bukkit.api.block.BlockData currentState = modified.get(block.getId());
        if (currentState == block) {
            modified.remove(block.getId());
        }
        block.commit();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)o;
            UndoList.removeFromModified(block, block.getPriorState());
        }
        return super.remove(o);
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        com.elmakers.mine.bukkit.api.block.BlockData currentState = modified.get(block.getId());
        if (currentState == block) {
            if (priorState == null) {
                modified.remove(block.getId());
            } else {
                modified.put(block.getId(), priorState);
            }
        }
    }

    public boolean undo(com.elmakers.mine.bukkit.api.block.BlockData undoBlock, boolean applyPhysics) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = undoBlock.getPriorState();
        if (this.undoBreakable) {
            undoBlock.getBlock().removeMetadata("breakable", this.plugin);
        }
        if (this.undoReflective) {
            undoBlock.getBlock().removeMetadata("backfire", this.plugin);
        }
        if (undoBlock.undo(applyPhysics)) {
            UndoList.removeFromModified(undoBlock, priorState);
            return true;
        }
        return false;
    }

    public void undoEntityEffects() {
        if (this.entities != null || this.modifiedEntities != null) {
            if (this.entities != null) {
                for (WeakReference<Entity> entityReference : this.entities) {
                    Entity entity = (Entity)entityReference.get();
                    if (entity == null || !entity.isValid()) continue;
                    entity.remove();
                }
                this.entities = null;
            }
            if (this.modifiedEntities != null) {
                for (EntityData data : this.modifiedEntities.values()) {
                    if (!this.undoEntityEffects && this.undoEntityTypes != null && !this.undoEntityTypes.contains(data.getType())) continue;
                    data.undo();
                }
                this.modifiedEntities = null;
            }
        }
    }

    @Override
    public void undo() {
        this.undo(false);
    }

    @Override
    public void undo(boolean blocking) {
        this.undo(blocking, true);
    }

    @Override
    public void undoScheduled(boolean blocking) {
        this.undo(blocking, false);
    }

    @Override
    public void undoScheduled() {
        this.undoScheduled(false);
    }

    public void undo(boolean blocking, boolean undoEntities) {
        this.undoEntityEffects = this.undoEntityEffects || undoEntities;
        this.unlink();
        if (this.isComplete()) {
            return;
        }
        this.undone = true;
        if (this.context != null) {
            this.context.cancelEffects();
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockList == null) {
            this.undoEntityEffects();
            return;
        }
        UndoBatch batch = new UndoBatch(this);
        if (blocking) {
            while (!batch.isFinished()) {
                batch.process(1000);
            }
        } else {
            this.owner.addUndoBatch(batch);
        }
        this.blockList = null;
    }

    @Override
    public void load(ConfigurationSection node) {
        super.load(node);
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.name = node.getString("name", this.name);
        this.applyPhysics = node.getBoolean("apply_physics", this.applyPhysics);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("name", (Object)this.name);
        node.set("apply_physics", (Object)this.applyPhysics);
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        entity.setMetadata("MagicBlockList", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this));
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities == null) {
            this.entities = new ArrayList<WeakReference<Entity>>();
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        this.entities.add(new WeakReference<Entity>(entity));
        if (this.isScheduled()) {
            entity.setMetadata("temporary", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
        this.watch(entity);
        this.contain(entity.getLocation().toVector());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.runnables == null) {
            this.runnables = new LinkedList<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public EntityData modify(Entity entity) {
        EntityData entityData = null;
        if (entity == null) {
            return entityData;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return entityData;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        UUID entityId = entity.getUniqueId();
        if (this.entities != null && this.entities.contains(entityId) && !entity.isValid()) {
            this.entities.remove(entityId);
        } else {
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap();
            }
            if ((entityData = this.modifiedEntities.get(entityId)) == null) {
                entityData = new EntityData(entity);
                this.modifiedEntities.put(entityId, entityData);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
        return entityData;
    }

    @Override
    public void move(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasMoved(true);
        }
    }

    @Override
    public void modifyVelocity(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasVelocity(true);
        }
    }

    @Override
    public void addPotionEffects(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasPotionEffects(true);
        }
    }

    @Override
    public void remove(Entity entity) {
        UUID entityId = entity.getUniqueId();
        if (this.entities != null && this.entities.contains(entityId)) {
            this.entities.remove(entityId);
        }
        if (this.modifiedEntities != null && this.modifiedEntities.containsKey(entityId)) {
            this.entities.remove(entityId);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        if (this.entities != null) {
            this.entities.remove(fallingBlock);
        }
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void finalizeExplosion(Entity explodingEntity, List<Block> blocks) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
        }
        if (this.isScheduled()) {
            for (Block block : blocks) {
                BlockState state = block.getState();
                if (state instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)state;
                    holder.getInventory().clear();
                    state.update();
                }
                block.setType(Material.AIR);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
            this.modifiedTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        if (location == null || this.area == null || this.worldName == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return this.area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockList == null) {
            return;
        }
        ArrayList current = new ArrayList(this.blockList);
        this.blockList = null;
        this.blockIdMap = null;
        for (com.elmakers.mine.bukkit.api.block.BlockData block : current) {
            if (block.isDifferent()) {
                super.add(block);
                continue;
            }
            UndoList.removeFromModified(block, block.getPriorState());
            block.unlink();
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UndoableSpell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getOwner() {
        return this.owner;
    }

    @Override
    public CastContext getContext() {
        return this.context;
    }

    @Override
    public long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public boolean isScheduled() {
        return this.timeToLive > 0;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.block.UndoList o) {
        return (int)(this.scheduledTime - o.getScheduledTime());
    }

    @Override
    public void setEntityUndo(boolean undoEntityEffects) {
        this.undoEntityEffects = undoEntityEffects;
    }

    @Override
    public void setEntityUndoTypes(Set<EntityType> undoTypes) {
        this.undoEntityTypes = undoTypes;
    }

    public void setNext(UndoList next) {
        this.next = next;
    }

    public void setPrevious(UndoList previous) {
        this.previous = previous;
    }

    public void setUndoQueue(com.elmakers.mine.bukkit.api.block.UndoQueue undoQueue) {
        if (undoQueue != null && undoQueue instanceof UndoQueue) {
            this.undoQueue = (UndoQueue)undoQueue;
        }
    }

    public boolean hasUndoQueue() {
        return this.undoQueue != null;
    }

    public void unlink() {
        if (this.undoQueue != null) {
            this.undoQueue.removed(this);
            this.undoQueue = null;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        this.previous = null;
        this.next = null;
    }

    public UndoList getNext() {
        return this.next;
    }

    public UndoList getPrevious() {
        return this.previous;
    }

    public void setApplyPhysics(boolean applyPhysics) {
        this.applyPhysics = applyPhysics;
    }

    public boolean getApplyPhysics() {
        return this.applyPhysics;
    }

    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity != null && entity.hasMetadata("MagicBlockList")) {
            List values = entity.getMetadata("MagicBlockList");
            for (MetadataValue metadataValue : values) {
                Object value = metadataValue.value();
                if (!(value instanceof com.elmakers.mine.bukkit.api.block.UndoList)) continue;
                blockList = (com.elmakers.mine.bukkit.api.block.UndoList)value;
            }
        }
        return blockList;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData getBlockData(Location location) {
        return modified.get(BlockData.getBlockId(location.getBlock()));
    }

    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Location location) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        com.elmakers.mine.bukkit.api.block.BlockData modifiedBlock = modified.get(BlockData.getBlockId(location.getBlock()));
        if (modifiedBlock != null) {
            blockList = modifiedBlock.getUndoList();
        }
        return blockList;
    }

    public static Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> getModified() {
        return modified;
    }

    @Override
    public void setUndoBreakable(boolean breakable) {
        this.undoBreakable = breakable;
    }

    @Override
    public void setUndoReflective(boolean reflective) {
        this.undoReflective = reflective;
    }

    static {
        modified = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
    }
}

