/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.Collection;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class WeatherAction
extends BaseSpellAction {
    private String weatherString = "";

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.weatherString = parameters.getString("weather", "");
    }

    @Override
    public SpellResult perform(CastContext context) {
        World world = context.getWorld();
        if (world == null) {
            return SpellResult.WORLD_REQUIRED;
        }
        boolean hasStorm = world.hasStorm();
        boolean makeStorm = this.weatherString.equals("storm");
        if (this.weatherString.equals("cycle")) {
            boolean bl = makeStorm = !hasStorm;
        }
        if (makeStorm) {
            world.setStorm(true);
            world.setThundering(true);
        } else {
            world.setStorm(false);
            world.setThundering(false);
        }
        return makeStorm ? SpellResult.CAST : SpellResult.ALTERNATE;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("weather");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("weather")) {
            examples.add("storm");
            examples.add("cycle");
            examples.add("clear");
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

