/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class SpellShopAction
extends BaseShopAction {
    private boolean showRequired = false;
    private boolean showFree = false;
    private Map<String, Double> spells = new HashMap<String, Double>();

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.spells.clear();
        if (parameters.contains("spells")) {
            ConfigurationSection spellSection = parameters.getConfigurationSection("spells");
            Set spellKeys = spellSection.getKeys(false);
            for (String spellKey : spellKeys) {
                this.spells.put(spellKey, spellSection.getDouble(spellKey));
            }
        }
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.showRequired = parameters.getBoolean("show_required", false);
        this.showFree = parameters.getBoolean("show_free", false);
        this.requireWand = true;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        SpellResult contextResult = this.checkContext(context);
        if (!contextResult.isSuccess()) {
            return contextResult;
        }
        Wand wand = mage.getActiveWand();
        WandUpgradePath path = wand.getPath();
        HashMap<String, Double> spellPrices = new HashMap<String, Double>();
        if (this.spells.size() > 0) {
            spellPrices.putAll(this.spells);
        } else {
            if (path == null) {
                context.sendMessage(context.getMessage("no_path").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            Collection<String> pathSpells = path.getSpells();
            for (String string : pathSpells) {
                spellPrices.put(string, null);
            }
            if (this.showRequired) {
                Collection<String> requiredSpells = path.getRequiredSpells();
                for (String requiredSpell : requiredSpells) {
                    spellPrices.put(requiredSpell, null);
                }
            }
        }
        ArrayList<BaseShopAction.ShopItem> shopItems = new ArrayList<BaseShopAction.ShopItem>();
        for (Map.Entry entry : spellPrices.entrySet()) {
            String spellKey = (String)entry.getKey();
            if (wand.hasSpell(spellKey)) continue;
            SpellTemplate spell = controller.getSpellTemplate(spellKey);
            Double worth = (Double)entry.getValue();
            if (worth == null) {
                worth = spell.getWorth();
                spellPrices.put(spellKey, worth);
            }
            if (worth <= 0.0 && !this.showFree) continue;
            ItemStack spellItem = controller.createSpellItem(spellKey);
            shopItems.add(new BaseShopAction.ShopItem(this, spellItem, worth));
        }
        return this.showItems(context, shopItems);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("show_free");
        parameters.add("show_required");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("show_free") || parameterKey.equals("show_required")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

