/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectAction
extends BaseSpellAction {
    private List<String> removeEffects;
    private Collection<PotionEffect> addEffects;
    private Integer duration;

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.removeEffects = parameters.contains("remove_effects") ? parameters.getStringList("remove_effects") : null;
        this.duration = parameters.contains("duration") ? Integer.valueOf(parameters.getInt("duration")) : null;
        this.addEffects = BaseSpell.getPotionEffects(parameters, this.duration);
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        if (parameters.contains("duration")) {
            int durationOverride = parameters.getInt("duration");
            if (this.duration == null || durationOverride != this.duration) {
                this.addEffects = BaseSpell.getPotionEffects(parameters, durationOverride);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (!(entity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity targetEntity = (LivingEntity)entity;
        context.registerPotionEffects((Entity)targetEntity);
        if (this.addEffects != null) {
            CompatibilityUtils.applyPotionEffects(targetEntity, this.addEffects);
        }
        if (this.removeEffects != null) {
            for (String removeKey : this.removeEffects) {
                PotionEffectType removeType = PotionEffectType.getByName((String)removeKey);
                targetEntity.removePotionEffect(removeType);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        PotionEffectType[] effectTypes;
        super.getParameterNames(spell, parameters);
        parameters.add("duration");
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            if (effectType == null) continue;
            parameters.add("effect_" + effectType.getName().toLowerCase());
        }
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

