/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class TraceEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public int refresh = 5;
    public int maxWayPoints = 30;
    protected List<Vector> wayPoints;
    protected int step = 0;
    protected World world;

    public TraceEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 600;
        this.wayPoints = new ArrayList<Vector>();
    }

    @Override
    public void onRun() {
        Location location = this.getLocation();
        if (this.world == null) {
            this.world = location.getWorld();
        } else if (!location.getWorld().equals(this.world)) {
            this.cancel(true);
            return;
        }
        if (this.wayPoints.size() >= this.maxWayPoints) {
            this.wayPoints.remove(0);
        }
        this.wayPoints.add(location.toVector());
        ++this.step;
        if (this.step % this.refresh != 0) {
            return;
        }
        for (Vector position : this.wayPoints) {
            Location particleLocation = new Location(this.world, position.getX(), position.getY(), position.getZ());
            this.display(this.particle, particleLocation);
        }
    }
}

