/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.maps;

import com.elmakers.mine.bukkit.maps.MapController;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLMap
extends MapRenderer
implements com.elmakers.mine.bukkit.api.maps.URLMap {
    private final MapController controller;
    private BufferedImage image;
    protected String world;
    protected Short id;
    protected String url;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Integer xOverlay;
    protected Integer yOverlay;
    protected String name;
    protected boolean enabled = true;
    protected boolean rendered = false;
    protected volatile boolean loading = false;
    protected Set<String> sentToPlayers = new HashSet<String>();
    protected Integer priority;

    protected URLMap(MapController controller, String world, short mapId, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        this.controller = controller;
        this.world = world;
        this.url = url;
        this.name = name;
        this.x = x;
        this.y = y;
        this.xOverlay = xOverlay;
        this.yOverlay = yOverlay;
        this.width = width;
        this.height = height;
        this.id = mapId;
        this.priority = priority;
    }

    public void render(MapView mapView, MapCanvas canvas, Player player) {
        if (this.rendered) {
            if (this.priority != null) {
                this.sendToPlayer(player, mapView);
            }
            return;
        }
        BufferedImage image = this.getImage();
        if (image != null) {
            canvas.drawImage(0, 0, (Image)image);
            this.rendered = true;
        }
    }

    public void initialize(MapView mapView) {
        this.rendered = false;
    }

    @Override
    public boolean matches(String keyword) {
        if (keyword == null || keyword.length() == 0) {
            return true;
        }
        String lowerUrl = this.url == null ? "" : this.url.toLowerCase();
        String lowerName = this.name == null ? "" : this.name.toLowerCase();
        String lowerKeyword = keyword.toLowerCase();
        return lowerUrl.contains(lowerKeyword) || lowerName.contains(lowerKeyword);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    protected MapView getMapView() {
        return this.getMapView(true);
    }

    @Override
    public short getId() {
        return this.id;
    }

    protected MapView getMapView(boolean recreateIfNecessary) {
        if (!this.enabled) {
            return null;
        }
        MapView mapView = Bukkit.getMap((short)this.id);
        if (mapView == null) {
            this.controller.remove(this.getKey());
            this.enabled = false;
            this.controller.warning("Failed to get map id " + this.id + " for key " + this.getKey() + ", disabled, re-enable in config and fix id");
            this.controller.save();
            return mapView;
        }
        List renderers = mapView.getRenderers();
        boolean needsRenderer = false;
        for (MapRenderer renderer : renderers) {
            if (renderer instanceof URLMap) continue;
            mapView.removeRenderer(renderer);
            needsRenderer = true;
        }
        if (needsRenderer) {
            mapView.addRenderer((MapRenderer)this);
        }
        return mapView;
    }

    protected void disable() {
        this.enabled = false;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected String getKey() {
        return URLMap.getKey(this.world, this.url, this.x, this.y, this.width, this.height);
    }

    protected static String getKey(String world, String url, int x, int y, int width, int height) {
        return world + "|" + x + "," + y + "|" + width + "," + height + "|" + url;
    }

    protected void resendTo(String playerName) {
        this.sentToPlayers.remove(playerName);
    }

    protected void reload() {
        this.sentToPlayers.clear();
        this.rendered = false;
        this.loading = false;
        this.image = null;
    }

    protected BufferedImage getImage() {
        if (this.loading || !this.enabled) {
            return null;
        }
        if (this.image == null) {
            this.loading = true;
            this.image = new BufferedImage(128, 128, 2);
            Plugin plugin = this.controller.getPlugin();
            if (plugin == null) {
                return null;
            }
            final File cacheFolder = this.controller.getCacheFolder();
            Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        URL imageUrl;
                        File cacheFile;
                        BufferedImage rawImage = null;
                        String cacheFileName = URLEncoder.encode(URLMap.this.url);
                        File file = cacheFile = cacheFolder != null ? new File(cacheFolder, cacheFileName) : null;
                        if (cacheFile != null) {
                            if (cacheFile.exists()) {
                                URLMap.this.controller.info("Loading from cache: " + cacheFile.getName());
                                rawImage = ImageIO.read(cacheFile);
                            } else {
                                int len;
                                URLMap.this.controller.info("Loading " + URLMap.this.url);
                                imageUrl = new URL(URLMap.this.url);
                                HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
                                conn.setConnectTimeout(30000);
                                conn.setReadTimeout(30000);
                                conn.setInstanceFollowRedirects(true);
                                InputStream in = conn.getInputStream();
                                FileOutputStream out = new FileOutputStream(cacheFile);
                                byte[] buffer = new byte[10240];
                                while ((len = in.read(buffer)) != -1) {
                                    ((OutputStream)out).write(buffer, 0, len);
                                }
                                ((OutputStream)out).close();
                                in.close();
                                rawImage = ImageIO.read(cacheFile);
                            }
                        } else {
                            URLMap.this.controller.info("Loading " + URLMap.this.url);
                            imageUrl = new URL(URLMap.this.url);
                            rawImage = ImageIO.read(imageUrl);
                        }
                        URLMap.this.width = URLMap.this.width <= 0 ? rawImage.getWidth() + URLMap.this.width : URLMap.this.width;
                        URLMap.this.height = URLMap.this.height <= 0 ? rawImage.getHeight() + URLMap.this.height : URLMap.this.height;
                        BufferedImage croppedImage = rawImage.getSubimage(URLMap.this.x, URLMap.this.y, URLMap.this.width, URLMap.this.height);
                        Graphics2D graphics = URLMap.this.image.createGraphics();
                        AffineTransform transform = AffineTransform.getScaleInstance(128.0f / (float)URLMap.this.width, 128.0f / (float)URLMap.this.height);
                        graphics.drawRenderedImage(croppedImage, transform);
                        if (URLMap.this.xOverlay != null && URLMap.this.yOverlay != null) {
                            BufferedImage croppedOverlay = rawImage.getSubimage(URLMap.this.xOverlay, URLMap.this.yOverlay, URLMap.this.width, URLMap.this.height);
                            graphics.drawRenderedImage(croppedOverlay, transform);
                        }
                        URLMap.this.loading = false;
                    }
                    catch (Exception ex) {
                        URLMap.this.controller.warning("Failed to load url " + URLMap.this.url + ": " + ex.getMessage());
                    }
                }
            });
            return null;
        }
        return this.image;
    }

    protected void reset() {
        this.image = null;
        this.rendered = false;
        this.loading = false;
        this.sentToPlayers.clear();
    }

    protected void sendToPlayer(Player player, MapView mapView) {
        if (this.priority == null || !this.enabled) {
            return;
        }
        String playerName = player.getName();
        if (!this.sentToPlayers.contains(playerName) && Math.random() * (double)this.priority.intValue() <= 1.0) {
            this.sentToPlayers.add(playerName);
            player.sendMap(mapView);
        }
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}

