/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class VolumeAction
extends CompoundAction {
    public static final float DEGTORAD = (float)Math.PI / 180;
    private static final int DEFAULT_RADIUS = 2;
    protected boolean autoOrient;
    protected int radius;
    protected int currentRadius;
    protected float centerProbability;
    protected float outerProbability;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    private int dy;
    private int dx;
    private int dz;
    private int xDirection;
    private int zDirection;
    private int startRadius;
    private boolean checked;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radius = parameters.getInt("radius", 2);
        this.xSize = parameters.getInt("x_size", this.radius);
        this.ySize = parameters.getInt("y_size", this.radius);
        this.zSize = parameters.getInt("z_size", this.radius);
        int thickness = parameters.getInt("thickness", 0);
        this.autoOrient = parameters.getBoolean("orient", false);
        this.centerProbability = (float)parameters.getDouble("probability", 1.0);
        this.outerProbability = (float)parameters.getDouble("probability", 1.0);
        this.centerProbability = (float)parameters.getDouble("center_probability", (double)this.centerProbability);
        this.outerProbability = (float)parameters.getDouble("outer_probability", (double)this.outerProbability);
        this.xSize = (int)(context.getMage().getRadiusMultiplier() * (float)this.xSize);
        this.ySize = (int)(context.getMage().getRadiusMultiplier() * (float)this.ySize);
        this.zSize = (int)(context.getMage().getRadiusMultiplier() * (float)this.zSize);
        this.radius = Math.max(this.xSize, this.zSize);
        this.startRadius = thickness > 0 ? this.radius - thickness : 0;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context);
        this.currentRadius = this.startRadius;
        this.dx = -this.startRadius;
        this.dy = -this.ySize;
        this.dz = -this.startRadius;
        this.xDirection = 1;
        this.zDirection = 0;
        this.checked = false;
        MaterialBrush brush = context.getBrush();
        brush.setTarget(context.getTargetLocation());
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = -yaw * ((float)Math.PI / 180);
        double sinYaw = Math.sin(angle);
        double cosYaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinPitch = Math.sin(angle);
        double cosPitch = Math.cos(angle);
        double pitchedX = x;
        double pitchedY = y * cosPitch - z * sinPitch;
        double pitchedZ = y * sinPitch + z * cosPitch;
        double finalX = pitchedX * cosYaw + pitchedZ * sinYaw;
        double finalY = pitchedY;
        double finalZ = -pitchedX * sinYaw + pitchedZ * cosYaw;
        return new Vector(finalX + 0.5, finalY + 0.5, finalZ + 0.5);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        if (this.radius < 1 && this.ySize < 1) {
            if (!this.checked && this.centerProbability < 1.0f && context.getRandom().nextDouble() <= (double)this.centerProbability) {
                return SpellResult.NO_ACTION;
            }
            this.checked = true;
            this.actionContext.setTargetLocation(block.getLocation());
            return this.performActions(this.actionContext);
        }
        Location location = context.getLocation();
        SpellResult result = SpellResult.NO_ACTION;
        Vector offset = new Vector();
        while (this.currentRadius <= this.radius) {
            if (!this.checked) {
                this.checked = this.containsPoint(this.dx, this.dy, this.dz);
                float probability = this.centerProbability;
                if (this.centerProbability != this.outerProbability) {
                    float weight = Math.abs((float)this.dx + (float)this.dz) / ((float)this.radius * 2.0f);
                    probability = RandomUtils.lerp(Float.valueOf(this.centerProbability), Float.valueOf(this.outerProbability), weight).floatValue();
                }
                boolean bl = this.checked = this.checked && (probability >= 1.0f || context.getRandom().nextDouble() <= (double)probability);
            }
            if (this.checked) {
                if (this.autoOrient) {
                    offset.setX(this.dx);
                    offset.setY(this.dz);
                    offset.setZ(this.dy);
                    offset = VolumeAction.rotate(location.getYaw(), location.getPitch(), offset.getX(), offset.getY(), offset.getZ());
                } else {
                    offset.setX(this.dx);
                    offset.setY(this.dy);
                    offset.setZ(this.dz);
                }
                Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
                this.actionContext.setTargetLocation(targetBlock.getLocation());
                SpellResult actionResult = this.performActions(this.actionContext);
                result = result.min(actionResult);
                if (actionResult == SpellResult.PENDING) {
                    break;
                }
            } else {
                this.skippedActions(context);
            }
            ++this.dy;
            if (this.dy < this.startRadius && this.dy >= -this.startRadius) {
                this.dy = this.startRadius;
            }
            if (this.dy > this.ySize) {
                this.dy = -this.ySize;
                int nextX = this.dx + this.xDirection;
                int nextZ = this.dz + this.zDirection;
                int endX = Math.min(this.currentRadius, this.xSize);
                int endZ = Math.min(this.currentRadius, this.zSize);
                if (this.xDirection == 0 && this.zDirection == -1 && nextX == -endX && nextZ == -endZ || this.currentRadius == 0) {
                    ++this.currentRadius;
                    this.dx = -this.currentRadius;
                    this.dz = -this.currentRadius;
                    this.xDirection = 1;
                    this.zDirection = 0;
                } else if (nextX > this.currentRadius || nextZ > endZ || nextX < -endX || nextZ < -endZ) {
                    if (this.xDirection == 1 && this.zDirection == 0) {
                        this.xDirection = 0;
                        this.zDirection = 1;
                        this.dz += this.zDirection;
                    } else if (this.xDirection == 0 && this.zDirection == 1) {
                        this.xDirection = -1;
                        this.zDirection = 0;
                        this.dx += this.xDirection;
                    } else {
                        this.xDirection = 0;
                        this.zDirection = -1;
                        this.dz += this.zDirection;
                    }
                } else {
                    this.dx = nextX;
                    this.dz = nextZ;
                }
            }
            this.checked = false;
            super.reset(context);
        }
        return result;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    protected boolean containsPoint(int x, int y, int z) {
        return true;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("radius");
        parameters.add("probability");
        parameters.add("center_probability");
        parameters.add("outer_probability");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("radius")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("probability") || parameterKey.equals("center_probability") || parameterKey.equals("outer_probability")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    public int getActionCount() {
        int volume = (1 + this.xSize * 2) * (1 + this.ySize * 2) * (1 + this.zSize * 2);
        return volume * this.actions.getActionCount();
    }
}

