/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class SpreadAction
extends CompoundAction {
    private int radius;
    private float centerProbability;
    private float outerProbability;
    private float yawMax;
    private float pitchMax;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radius = parameters.getInt("radius", 2);
        this.yawMax = (float)parameters.getDouble("yaw_max", 0.0);
        this.pitchMax = (float)parameters.getDouble("pitch_max", 0.0);
        this.centerProbability = (float)parameters.getDouble("probability", 1.0);
        this.outerProbability = (float)parameters.getDouble("probability", 1.0);
        this.centerProbability = (float)parameters.getDouble("center_probability", (double)this.centerProbability);
        this.outerProbability = (float)parameters.getDouble("outer_probability", (double)this.outerProbability);
    }

    @Override
    public SpellResult perform(CastContext context) {
        CastContext actionContext;
        Location targetLocation;
        Location sourceLocation = context.getEyeLocation();
        Entity source = context.getEntity();
        Random random = context.getRandom();
        if (this.pitchMax > 0.0f || this.yawMax > 0.0f) {
            sourceLocation = sourceLocation.clone();
            if (this.pitchMax > 0.0f) {
                sourceLocation.setPitch(sourceLocation.getPitch() + this.pitchMax * random.nextFloat() - this.pitchMax / 2.0f);
            }
            if (this.yawMax > 0.0f) {
                sourceLocation.setYaw(sourceLocation.getYaw() + this.yawMax * random.nextFloat() - this.yawMax / 2.0f);
            }
        }
        if ((targetLocation = (actionContext = this.createContext(context, source, sourceLocation)).getTargetLocation().clone()) != null) {
            double weight = RandomUtils.lerp(Float.valueOf(this.centerProbability - this.outerProbability), Float.valueOf(this.centerProbability + this.outerProbability), random.nextFloat()).floatValue();
            double xOffset = (double)this.radius * weight;
            weight = RandomUtils.lerp(Float.valueOf(this.centerProbability - this.outerProbability), Float.valueOf(this.centerProbability + this.outerProbability), random.nextFloat()).floatValue();
            double zOffset = (double)this.radius * weight;
            targetLocation.setX(targetLocation.getX() + (xOffset -= (double)this.radius));
            targetLocation.setZ(targetLocation.getZ() + (zOffset -= (double)this.radius));
            actionContext.setTargetLocation(targetLocation);
        }
        return this.performActions(actionContext);
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("radius");
        parameters.add("probability");
        parameters.add("center_probability");
        parameters.add("outer_probability");
        parameters.add("yaw_max");
        parameters.add("pitch_max");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("radius")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("probability") || parameterKey.equals("center_probability") || parameterKey.equals("outer_probability")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else if (parameterKey.equals("yaw_max") || parameterKey.equals("pitch_max")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_VECTOR_COMPONENTS));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

