/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class SkipAction
extends CompoundAction {
    private int skipCount;
    private int skipCounter;
    private boolean pending = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.skipCount = parameters.getInt("skip", 1);
        this.skipCounter = 0;
        this.pending = false;
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpellResult result;
        if (!this.pending && this.skipCounter++ <= this.skipCount) {
            return SpellResult.NO_ACTION;
        }
        this.skipCounter = 0;
        if (!this.pending) {
            super.reset(context);
        }
        this.pending = (result = this.performActions(context)) == SpellResult.PENDING;
        return result;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("skip");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("skip")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        }
    }
}

