/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HatAction
extends BaseSpellAction {
    private com.elmakers.mine.bukkit.api.block.MaterialAndData material;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.material = ConfigurationUtils.getMaterialAndData(parameters, "material");
    }

    @Override
    public SpellResult perform(CastContext context) {
        Material baseMaterial;
        Block targetBlock;
        com.elmakers.mine.bukkit.api.block.MaterialAndData material;
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            entity = context.getEntity();
        }
        if ((material = this.material) == null && (context.getSpell().usesBrush() || context.getSpell().hasBrushOverride())) {
            material = context.getBrush();
        }
        if (material == null && (targetBlock = context.getTargetBlock()) != null && ((baseMaterial = (material = new MaterialAndData(targetBlock)).getMaterial()).getId() == 176 || baseMaterial.getId() == 177)) {
            ((MaterialAndData)material).setMaterialId(425);
        }
        if (entity == null || !(entity instanceof Player) || material == null || material.getMaterial() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)entity;
        ItemStack hatItem = material.getItemStack(1);
        ItemMeta meta = hatItem.getItemMeta();
        String hatName = context.getMessage("hat_name", "");
        String materialName = material.getName();
        if (materialName == null || materialName.isEmpty()) {
            materialName = "?";
        }
        if (hatName != null && !hatName.isEmpty()) {
            meta.setDisplayName(hatName.replace("$hat", materialName));
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(context.getMessage("hat_lore"));
        meta.setLore(lore);
        hatItem.setItemMeta(meta);
        hatItem = InventoryUtils.makeReal(hatItem);
        NMSUtils.makeTemporary(hatItem, context.getMessage("removed").replace("$hat", materialName));
        ItemStack itemStack = player.getInventory().getHelmet();
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            if (NMSUtils.isTemporary(itemStack)) {
                itemStack = NMSUtils.getReplacement(itemStack);
            }
            if (itemStack != null) {
                NMSUtils.setReplacement(hatItem, itemStack);
            }
        }
        player.getInventory().setHelmet(hatItem);
        context.registerForUndo(new HatUndoAction(player));
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("material");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("material")) {
            examples.addAll(MagicPlugin.getAPI().getBrushes());
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class HatUndoAction
    implements Runnable {
        private final Player player;

        public HatUndoAction(Player player) {
            this.player = player;
        }

        @Override
        public void run() {
            ItemStack helmetItem = this.player.getInventory().getHelmet();
            if (NMSUtils.isTemporary(helmetItem)) {
                ItemStack replacement = NMSUtils.getReplacement(helmetItem);
                this.player.getInventory().setHelmet(replacement);
            }
        }
    }
}

