/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ChangeContextAction
extends CompoundAction {
    private Vector sourceOffset;
    private Vector targetOffset;
    private boolean targetSelf;
    private Vector randomSourceOffset;
    private Vector randomTargetOffset;
    private Double targetDirectionSpeed;
    private Double sourceDirectionSpeed;
    private Vector sourceDirection;
    private Vector targetDirection;
    private Vector sourceDirectionOffset;
    private Vector targetDirectionOffset;
    private boolean persistTarget;
    private boolean attachBlock;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetSelf = parameters.getBoolean("target_caster");
        this.targetOffset = ConfigurationUtils.getVector(parameters, "target_offset");
        this.sourceOffset = ConfigurationUtils.getVector(parameters, "source_offset");
        this.targetOffset = ConfigurationUtils.getVector(parameters, "random_target_offset");
        this.sourceOffset = ConfigurationUtils.getVector(parameters, "random_source_offset");
        this.randomTargetOffset = ConfigurationUtils.getVector(parameters, "random_target_offset");
        this.randomSourceOffset = ConfigurationUtils.getVector(parameters, "random_source_offset");
        this.sourceDirection = ConfigurationUtils.getVector(parameters, "source_direction");
        this.targetDirection = ConfigurationUtils.getVector(parameters, "target_direction");
        this.targetDirection = ConfigurationUtils.getVector(parameters, "target_direction");
        this.sourceDirectionOffset = ConfigurationUtils.getVector(parameters, "source_direction_offset");
        this.targetDirectionOffset = ConfigurationUtils.getVector(parameters, "source_direction_offset");
        this.persistTarget = parameters.getBoolean("persist_target", false);
        this.attachBlock = parameters.getBoolean("target_attachment", false);
        this.targetDirectionSpeed = parameters.contains("target_direction_speed") ? Double.valueOf(parameters.getDouble("target_direction_speed")) : null;
        this.sourceDirectionSpeed = parameters.contains("source_direction_speed") ? Double.valueOf(parameters.getDouble("source_direction_speed")) : null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block previousBlock;
        Entity sourceEntity = context.getEntity();
        Location sourceLocation = context.getEyeLocation().clone();
        Entity targetEntity = context.getTargetEntity();
        Location targetLocation = context.getTargetLocation().clone();
        Vector direction = context.getDirection().normalize();
        if (sourceLocation == null) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (this.targetSelf) {
            targetEntity = sourceEntity;
            targetLocation = sourceLocation;
        }
        if (this.attachBlock && (previousBlock = context.getPreviousBlock()) != null) {
            Location current = targetLocation;
            targetLocation = previousBlock.getLocation();
            context.getBrush().setTarget(current, targetLocation);
        }
        if (this.sourceOffset != null) {
            sourceLocation = sourceLocation.add(this.sourceOffset);
        }
        if (this.targetOffset != null) {
            targetLocation = targetLocation.add(this.targetOffset);
        }
        if (this.randomSourceOffset != null) {
            sourceLocation = RandomUtils.randomizeLocation(sourceLocation, this.randomSourceOffset);
        }
        if (this.randomTargetOffset != null) {
            targetLocation = RandomUtils.randomizeLocation(targetLocation, this.randomTargetOffset);
        }
        if (this.targetDirection != null) {
            targetLocation.setDirection(this.targetDirection);
        }
        if (this.sourceDirection != null) {
            sourceLocation.setDirection(this.sourceDirection);
            direction = this.sourceDirection.clone();
        }
        if (this.targetDirectionOffset != null) {
            targetLocation.setDirection(targetLocation.getDirection().add(this.targetDirectionOffset));
        }
        if (this.sourceDirectionOffset != null) {
            sourceLocation.setDirection(direction.add(this.sourceDirectionOffset));
        }
        if (this.sourceDirectionSpeed != null) {
            sourceLocation = sourceLocation.add(direction.clone().multiply(this.sourceDirectionSpeed.doubleValue()));
        }
        if (this.targetDirectionSpeed != null) {
            targetLocation = targetLocation.add(direction.clone().multiply(this.targetDirectionSpeed.doubleValue()));
        }
        if (this.persistTarget) {
            context.setTargetLocation(targetLocation);
        }
        CastContext newContext = this.createContext(context, sourceEntity, sourceLocation, targetEntity, targetLocation);
        return this.performActions(newContext);
    }
}

