/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class Messages
implements com.elmakers.mine.bukkit.api.magic.Messages {
    private static String PARAMETER_PATTERN_STRING = "\\$([^ :]+)";
    private static Pattern PARAMETER_PATTERN = Pattern.compile(PARAMETER_PATTERN_STRING);
    private static Random random = new Random();
    private Map<String, String> messageMap = new HashMap<String, String>();
    private Map<String, List<String>> randomized = new HashMap<String, List<String>>();
    private ConfigurationSection configuration = null;

    public void load(ConfigurationSection messages) {
        this.configuration = messages;
        Set keys = messages.getKeys(true);
        for (String key : keys) {
            if (key.equals("randomized")) {
                ConfigurationSection randomSection = messages.getConfigurationSection(key);
                Set randomKeys = randomSection.getKeys(false);
                for (String randomKey : randomKeys) {
                    this.randomized.put(randomKey, randomSection.getStringList(randomKey));
                }
                continue;
            }
            if (!messages.isString(key)) continue;
            String value = messages.getString(key);
            value = StringEscapeUtils.unescapeHtml((String)value);
            this.messageMap.put(key, value);
        }
    }

    @Override
    public List<String> getAll(String path) {
        if (this.configuration == null) {
            return new ArrayList<String>();
        }
        return this.configuration.getStringList(path);
    }

    public void reset() {
        this.messageMap.clear();
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.messageMap.containsKey(key) ? ChatColor.translateAlternateColorCodes((char)'&', (String)this.messageMap.get(key)) : defaultValue;
    }

    @Override
    public String get(String key) {
        return this.get(key, key);
    }

    @Override
    public String getParameterized(String key, String paramName, String paramValue) {
        return this.get(key, key).replace(paramName, paramValue);
    }

    @Override
    public String getParameterized(String key, String paramName1, String paramValue1, String paramName2, String paramValue2) {
        return this.get(key, key).replace(paramName1, paramValue1).replace(paramName2, paramValue2);
    }

    @Override
    public String getRandomized(String key) {
        if (!this.randomized.containsKey(key)) {
            return null;
        }
        List<String> options = this.randomized.get(key);
        if (options.size() == 0) {
            return "";
        }
        return options.get(random.nextInt(options.size()));
    }

    @Override
    public String escape(String source) {
        Matcher matcher = PARAMETER_PATTERN.matcher(source);
        String result = source;
        while (matcher.find()) {
            String randomized;
            String key = matcher.group(1);
            if (key == null || (randomized = this.getRandomized(key)) == null) continue;
            result = result.replace("$" + key, randomized);
        }
        return result;
    }
}

