/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class SpawnEntityAction
extends BaseSpellAction {
    private final LinkedList<WeightedPair<String>> entityTypeProbability = new LinkedList();
    private CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
    private WeakReference<Entity> current = null;
    private boolean track = true;
    private boolean loot = false;
    private boolean setTarget = false;
    private String entityName;
    private EntityType entityType;
    private boolean spawnBaby = false;
    private Vector direction = null;
    private double speed;
    private double dyOffset;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.track = parameters.getBoolean("track", true);
        this.loot = parameters.getBoolean("loot", false);
        this.entityName = parameters.getString("name", "");
        this.spawnBaby = parameters.getBoolean("baby", false);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.speed = parameters.getDouble("speed", 0.0);
        this.direction = ConfigurationUtils.getVector(parameters, "direction");
        this.dyOffset = parameters.getDouble("dy_offset", 0.0);
        try {
            String entityTypeName = parameters.getString("type", "");
            if (!entityTypeName.isEmpty()) {
                this.entityType = EntityType.valueOf((String)entityTypeName.toUpperCase());
            }
        }
        catch (Exception ex) {
            this.entityType = null;
        }
        if (parameters.contains("reason")) {
            String reasonText = parameters.getString("reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        LivingEntity livingEntity;
        Block targetBlock = context.getTargetBlock();
        Entity currentEntity = this.current == null ? null : (Entity)this.current.get();
        this.current = null;
        if (currentEntity != null) {
            currentEntity.remove();
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        Location spawnLocation = targetBlock.getLocation();
        Location sourceLocation = context.getLocation();
        spawnLocation.setPitch(sourceLocation.getPitch());
        spawnLocation.setYaw(sourceLocation.getYaw());
        EntityType useType = this.entityType;
        if (useType == null) {
            String randomType = (String)RandomUtils.weightedRandom(this.entityTypeProbability);
            try {
                useType = EntityType.valueOf((String)randomType.toUpperCase());
            }
            catch (Throwable ex) {
                useType = null;
            }
        }
        if (useType == null) {
            return SpellResult.FAIL;
        }
        Entity spawnedEntity = this.spawnEntity(spawnLocation, this.entityType);
        if (spawnedEntity == null) {
            return SpellResult.FAIL;
        }
        MageController controller = context.getController();
        LivingEntity livingEntity2 = livingEntity = spawnedEntity instanceof LivingEntity ? (LivingEntity)spawnedEntity : null;
        if (this.entityName != null && !this.entityName.isEmpty() && livingEntity != null) {
            livingEntity.setCustomName(this.entityName);
        }
        if (!this.loot) {
            livingEntity.setMetadata("nodrops", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
        }
        if (this.spawnBaby && spawnedEntity instanceof Ageable) {
            Ageable ageable = (Ageable)spawnedEntity;
            ageable.setBaby();
        }
        if (this.speed > 0.0) {
            Vector motion = this.direction;
            motion = motion == null ? context.getDirection() : motion.clone();
            if (this.dyOffset != 0.0) {
                motion.setY(motion.getY() + this.dyOffset);
            }
            motion.normalize();
            motion.multiply(this.speed);
            CompatibilityUtils.setEntityMotion(spawnedEntity, motion);
        }
        context.registerForUndo(spawnedEntity);
        if (this.track) {
            this.current = new WeakReference<Entity>(spawnedEntity);
        }
        if (this.setTarget) {
            context.setTargetEntity(spawnedEntity);
        }
        return SpellResult.CAST;
    }

    protected Entity spawnEntity(Location target, EntityType famType) {
        Entity entity = null;
        try {
            World world = target.getWorld();
            try {
                Method spawnMethod = world.getClass().getMethod("spawn", Location.class, Class.class, CreatureSpawnEvent.SpawnReason.class);
                entity = (Entity)spawnMethod.invoke((Object)world, target, famType.getEntityClass(), this.spawnReason);
            }
            catch (Exception ex) {
                entity = target.getWorld().spawnEntity(target, famType);
            }
            if (entity != null && entity instanceof Skeleton) {
                Skeleton skellie = (Skeleton)entity;
                skellie.getEquipment().setItemInHand(new ItemStack(Material.BOW));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entity;
    }

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        if (parameters.contains("entity_types")) {
            RandomUtils.populateStringProbabilityMap(this.entityTypeProbability, parameters.getConfigurationSection("entity_types"), 0, 0, 0.0f);
        } else {
            this.entityTypeProbability.add(new WeightedPair<String>(Float.valueOf(100.0f), "pig"));
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("track");
        parameters.add("loot");
        parameters.add("baby");
        parameters.add("name");
        parameters.add("type");
        parameters.add("speed");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("type")) {
            for (EntityType type : EntityType.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("track") || parameterKey.equals("loot") || parameterKey.equals("baby")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("name")) {
            examples.add("Philbert");
        } else if (parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

