/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class BlockSearchAction
extends CompoundAction {
    private static final int MAX_SEARCH_DISTANCE = 255;
    private BlockFace direction;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.direction = BlockFace.UP;
        try {
            this.direction = BlockFace.valueOf((String)parameters.getString("direction", "up").toUpperCase());
        }
        catch (Exception ex) {
            context.getLogger().info("Invalid search direction: " + parameters.getString("direction"));
            this.direction = BlockFace.DOWN;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block attachBlock = context.getTargetBlock();
        BlockFace direction = BlockFace.UP;
        Block targetBlock = attachBlock.getRelative(direction);
        for (int distance = 0; context.isTargetable(targetBlock.getType()) && distance <= 255; ++distance) {
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (context.isTargetable(targetBlock.getType())) {
            return SpellResult.NO_TARGET;
        }
        this.createActionContext(context);
        this.actionContext.setTargetLocation(targetBlock.getLocation());
        context.getBrush().setTarget(attachBlock.getLocation(), targetBlock.getLocation());
        return this.performActions(this.actionContext);
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

