/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class LostWand
implements com.elmakers.mine.bukkit.api.wand.LostWand {
    private Location location;
    private String id;
    private String name;
    private String description;
    private String owner;
    private String ownerId;
    private boolean indestructible;

    public LostWand(String id, ConfigurationSection config) {
        this.id = id;
        this.load(config);
    }

    public LostWand(Wand wand, Location location) {
        this.update(wand, location);
    }

    public void update(Wand wand, Location location) {
        this.location = location;
        this.id = wand.getLostId();
        this.name = wand.getName();
        this.owner = wand.getOwner();
        this.ownerId = wand.getOwnerId();
        this.description = wand.getHTMLDescription();
        this.setIndestructible(wand.isIndestructible());
    }

    public void update(LostWand other) {
        this.location = other.location;
        this.name = other.getName();
        this.owner = other.getOwner();
        this.ownerId = other.getOwnerId();
        this.setIndestructible(other.isIndestructible());
        String description = other.getDescription();
        if (description != null && description.length() > 0) {
            this.description = description;
        }
    }

    public boolean isValid() {
        return this.location != null && this.id != null && this.id.length() > 0;
    }

    public void save(ConfigurationSection configNode) {
        try {
            configNode.set("location", (Object)ConfigurationUtils.fromLocation(this.location));
            configNode.set("name", (Object)this.name);
            configNode.set("description", (Object)this.description);
            configNode.set("owner", (Object)this.owner);
            configNode.set("owner_id", (Object)this.ownerId);
            configNode.set("indestructible", (Object)this.indestructible);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void load(ConfigurationSection configNode) {
        try {
            if (configNode == null) {
                return;
            }
            this.location = ConfigurationUtils.getLocation(configNode, "location");
            this.name = configNode.getString("name");
            this.description = configNode.getString("description");
            this.owner = configNode.getString("owner");
            this.ownerId = configNode.getString("owner_id");
            this.indestructible = configNode.getBoolean("indestructible");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LostWand)) {
            return false;
        }
        LostWand other = (LostWand)obj;
        return other.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean isIndestructible() {
        return this.indestructible;
    }

    public void setIndestructible(boolean indestructible) {
        this.indestructible = indestructible;
    }
}

