/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Art;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends NMSUtils {
    public static final int MAX_ENTITY_RANGE = 72;
    private static ThrownPotion potion = null;

    @Deprecated
    public static Location setDirection(Location location, Vector vector) {
        return location.setDirection(vector);
    }

    public static void applyPotionEffects(LivingEntity entity, Collection<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            CompatibilityUtils.applyPotionEffect(entity, effect);
        }
    }

    public static void applyPotionEffect(LivingEntity entity, PotionEffect effect) {
        boolean applyEffect = true;
        Collection currentEffects = entity.getActivePotionEffects();
        for (PotionEffect currentEffect : currentEffects) {
            if (!currentEffect.getType().equals((Object)effect.getType())) continue;
            if (effect.getAmplifier() < 0) {
                applyEffect = false;
                entity.removePotionEffect(effect.getType());
                break;
            }
            if (currentEffect.getAmplifier() <= effect.getAmplifier()) continue;
            applyEffect = false;
            break;
        }
        if (applyEffect) {
            entity.addPotionEffect(effect, true);
        }
    }

    public static boolean setDisplayName(ItemStack itemStack, String displayName) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        CompatibilityUtils.setMeta(displayNode, "Name", displayName);
        return true;
    }

    public static boolean setLore(ItemStack itemStack, Collection<String> lore) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        Object loreList = CompatibilityUtils.setStringList(displayNode, "Lore", lore);
        return loreList != null;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            inventory = (Inventory)class_CraftInventoryCustom_constructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static void addPotionEffect(LivingEntity entity, Color color) {
        CompatibilityUtils.addPotionEffect(entity, color.asRGB());
    }

    public static void setInvulnerable(Entity entity) {
        CompatibilityUtils.setInvulnerable(entity, true);
    }

    public static void setInvulnerable(Entity entity, boolean flag) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_invulnerableField.set(handle, flag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void removePotionEffect(LivingEntity entity) {
        CompatibilityUtils.watch((Entity)entity, 7, (Object)0);
    }

    @Deprecated
    public static Painting spawnPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting = null;
        try {
            Constructor paintingConstructor = class_EntityPainting.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = paintingConstructor.newInstance(worldHandle, location.getBlockX(), location.getBlockY(), location.getBlockZ(), CompatibilityUtils.getFacing(facing));
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Painting)) {
                    return null;
                }
                newPainting = (Painting)bukkitEntity;
                newPainting.setFacingDirection(facing, true);
                newPainting.setArt(art, true);
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newPainting;
    }

    @Deprecated
    public static ItemFrame spawnItemFrame(Location location, BlockFace facing, Rotation rotation, ItemStack item) {
        ItemFrame newItemFrame = null;
        try {
            Constructor itemFrameConstructor = class_EntityItemFrame.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = itemFrameConstructor.newInstance(worldHandle, location.getBlockX(), location.getBlockY(), location.getBlockZ(), CompatibilityUtils.getFacing(facing));
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof ItemFrame)) {
                    return null;
                }
                newItemFrame = (ItemFrame)bukkitEntity;
                newItemFrame.setItem(CompatibilityUtils.getCopy(item));
                newItemFrame.setFacingDirection(facing, true);
                newItemFrame.setRotation(rotation);
                try {
                    addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                }
                catch (Exception ex) {}
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newItemFrame;
    }

    public static void watch(Object entityHandle, int key, Object data) {
        try {
            Method getDataWatcherMethod = class_Entity.getMethod("getDataWatcher", new Class[0]);
            Object dataWatcher = getDataWatcherMethod.invoke(entityHandle, new Object[0]);
            class_DataWatcher_watchMethod.invoke(dataWatcher, key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void watch(Entity entity, int key, Object data) {
        try {
            Method geHandleMethod = entity.getClass().getMethod("getHandle", new Class[0]);
            CompatibilityUtils.watch(geHandleMethod.invoke((Object)entity, new Object[0]), key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addPotionEffect(LivingEntity entity, int color) {
        if (color == 0) {
            color = 65793;
        }
        CompatibilityUtils.watch((Entity)entity, 7, (Object)color);
    }

    public static List<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        if (location == null) {
            return null;
        }
        Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
        try {
            x = Math.min(x, 72.0);
            z = Math.min(z, 72.0);
            Object bb = class_AxisAlignedBB_createBBMethod.invoke(null, location.getX() - x, location.getY() - y, location.getZ() - z, location.getX() + x, location.getY() + y, location.getZ() + z);
            List entityList = (List)class_World_getEntitiesMethod.invoke(worldHandle, null, bb);
            ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
            for (Object entity : entityList) {
                bukkitEntityList.add((Entity)class_Entity_getBukkitEntityMethod.invoke(entity, new Object[0]));
            }
            return bukkitEntityList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Minecart spawnCustomMinecart(Location location, MaterialAndData display, int offset) {
        Minecart newMinecart = null;
        try {
            Constructor minecartConstructor = class_EntityMinecartRideable.getConstructor(class_World, Double.TYPE, Double.TYPE, Double.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Method setPositionRotationMethod = class_Entity.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = minecartConstructor.newInstance(worldHandle, location.getX(), location.getY(), location.getZ());
            if (newEntity != null) {
                setPositionRotationMethod.invoke(newEntity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                int materialId = display.getMaterial().getId() & 0xFFFF | display.getData() << 16;
                CompatibilityUtils.watch(newEntity, 20, (Object)materialId);
                CompatibilityUtils.watch(newEntity, 21, (Object)offset);
                CompatibilityUtils.watch(newEntity, 22, (Object)1);
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Minecart)) {
                    return null;
                }
                newMinecart = (Minecart)bukkitEntity;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newMinecart;
    }

    public static Class<? extends Runnable> getTaskClass(BukkitTask task) {
        Class taskClass = null;
        try {
            Method getTaskClassMethod = class_CraftTask.getDeclaredMethod("getTaskClass", new Class[0]);
            getTaskClassMethod.setAccessible(true);
            taskClass = (Class)getTaskClassMethod.invoke((Object)task, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return taskClass;
    }

    public static Runnable getTaskRunnable(BukkitTask task) {
        Runnable runnable = null;
        try {
            Field taskField = class_CraftTask.getDeclaredField("task");
            taskField.setAccessible(true);
            runnable = (Runnable)taskField.get(task);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return runnable;
    }

    public static void ageItem(Item item, int ticksToAge) {
        try {
            Class<?> itemClass = CompatibilityUtils.fixBukkitClass("net.minecraft.server.EntityItem");
            Object handle = CompatibilityUtils.getHandle((Entity)item);
            Field ageField = itemClass.getDeclaredField("age");
            ageField.setAccessible(true);
            ageField.set(handle, ticksToAge);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void magicDamage(LivingEntity target, double amount, Entity source) {
        try {
            if (target == null || target.isDead()) {
                return;
            }
            Object targetHandle = CompatibilityUtils.getHandle(target);
            if (targetHandle == null) {
                return;
            }
            Object sourceHandle = CompatibilityUtils.getHandle(source);
            if (!(target instanceof Player)) {
                target.damage(amount, source);
                return;
            }
            if (sourceHandle != null && source instanceof LivingEntity) {
                if (potion == null) {
                    Location location = target.getLocation();
                    potion = (ThrownPotion)location.getWorld().spawnEntity(location, EntityType.SPLASH_POTION);
                    potion.remove();
                }
                potion.setShooter((ProjectileSource)((LivingEntity)source));
                Object potionHandle = CompatibilityUtils.getHandle((Entity)potion);
                Object damageSource = class_DamageSource_getMagicSourceMethod.invoke(null, potionHandle, sourceHandle);
                class_EntityLiving_damageEntityMethod.invoke(targetHandle, damageSource, Float.valueOf((float)amount));
            } else {
                Object magicSource = class_DamageSource_MagicField.get(null);
                class_EntityLiving_damageEntityMethod.invoke(targetHandle, magicSource, Float.valueOf((float)amount));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public static void setTarget(LivingEntity entity, Location target) {
    }

    public static Location getEyeLocation(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEyeLocation();
        }
        return entity.getLocation();
    }

    public static BoundingBox getHitbox(Entity entity) {
        return new BoundingBox(entity.getLocation().toVector(), -0.75, 0.75, 0.0, 2.0, -0.75, 0.75);
    }

    public static Object getSkullProfile(Skull state) {
        if (isLegacy) {
            return null;
        }
        Object profile = null;
        try {
            if (state == null || !class_CraftSkull.isInstance(state)) {
                return false;
            }
            profile = class_CraftSkull_profile.get(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profile;
    }

    public static boolean setSkullProfile(Skull state, Object data) {
        if (isLegacy) {
            return false;
        }
        try {
            if (state == null || !class_CraftSkull.isInstance(state)) {
                return false;
            }
            class_CraftSkull_profile.set(state, data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setSkullOwner(Skull state, String playerName, UUID playerId) {
        ItemStack skullItem = InventoryUtils.getPlayerSkull(playerName, playerId);
        if (skullItem == null) {
            return false;
        }
        return CompatibilityUtils.setSkullProfile(state, InventoryUtils.getSkullProfile(skullItem.getItemMeta()));
    }

    public static boolean setSkullOwner(Skull state, Player owner) {
        return CompatibilityUtils.setSkullOwner(state, owner.getName(), owner.getUniqueId());
    }

    public static Object getBannerPatterns(BlockState state) {
        if (isLegacy) {
            return null;
        }
        Object data = null;
        try {
            if (state == null || !class_CraftBanner.isInstance(state)) {
                return null;
            }
            data = class_CraftBanner_getPatternsMethod.invoke((Object)state, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static DyeColor getBannerBaseColor(BlockState state) {
        if (isLegacy) {
            return null;
        }
        DyeColor color = null;
        try {
            if (state == null || !class_CraftBanner.isInstance(state)) {
                return null;
            }
            color = (DyeColor)class_CraftBanner_getBaseColorMethod.invoke((Object)state, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    public static boolean setBannerPatterns(BlockState state, Object patterns) {
        if (isLegacy || patterns == null) {
            return false;
        }
        Object data = null;
        try {
            if (state == null || !class_CraftBanner.isInstance(state)) {
                return false;
            }
            data = class_CraftBanner_setPatternsMethod.invoke((Object)state, patterns);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean setBannerBaseColor(BlockState state, DyeColor color) {
        if (isLegacy || color == null) {
            return false;
        }
        try {
            if (state == null || !class_CraftBanner.isInstance(state)) {
                return false;
            }
            color = (DyeColor)class_CraftBanner_setBaseColorMethod.invoke((Object)state, color);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static ConfigurationSection loadConfiguration(String fileName) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static ConfigurationSection loadConfiguration(InputStream stream) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static ConfigurationSection loadConfiguration(File file) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }
}

