/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Color;

public class SpellCategory
implements com.elmakers.mine.bukkit.api.spell.SpellCategory {
    protected List<SpellTemplate> spells = new ArrayList<SpellTemplate>();
    protected final String key;
    protected final String name;
    protected final String description;
    protected final Color color;
    protected long castCount = 0L;
    protected long lastCast = 0L;
    protected final MageController controller;

    public SpellCategory(String key, MageController controller) {
        this.key = key;
        this.controller = controller;
        Messages messages = controller.getMessages();
        this.name = messages.get("categories." + key + ".name", key);
        this.description = messages.get("categories." + key + ".description", "");
        this.color = ConfigurationUtils.toColor(messages.get("categories." + key + ".color", ""));
    }

    public SpellCategory(String key, MageController controller, long castCount, long lastCast) {
        this(key, controller);
        this.castCount = castCount;
        this.lastCast = lastCast;
    }

    public void addSpellTemplate(SpellTemplate template) {
        this.spells.add(template);
    }

    public Collection<SpellTemplate> getSpells() {
        return this.spells;
    }

    @Override
    public void addCast() {
        ++this.castCount;
        this.lastCast = System.currentTimeMillis();
    }

    @Override
    public void addCasts(long castCount, long lastCast) {
        this.castCount += castCount;
        this.lastCast = Math.max(this.lastCast, lastCast);
    }

    @Override
    public long getCastCount() {
        return this.castCount;
    }

    @Override
    public long getLastCast() {
        return this.lastCast;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.spell.SpellCategory other) {
        return this.name.compareTo(other.getName());
    }
}

