/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class LineLocationEffect
extends LocationEffect {
    protected final Vector link;
    protected final float length;
    public ParticleEffect particle = ParticleEffect.FLAME;
    public int particles = 100;

    public LineLocationEffect(EffectManager effectManager, Location start, Location stop) {
        super(effectManager, start);
        this.link = stop.toVector().subtract(start.toVector());
        this.length = (float)this.link.length();
        this.link.normalize();
        this.type = EffectType.INSTANT;
        this.period = 5;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        float ratio = this.length / (float)this.particles;
        Vector v = this.link.clone().multiply(ratio);
        Location loc = this.location.clone().subtract(v);
        for (int i = 0; i < this.particles; ++i) {
            loc.add(v);
            this.particle.display(loc, this.visibleRange);
        }
    }
}

