/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.onarandombox.MultiverseCore.MultiverseCore;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MultiverseManager {
    private boolean enabled = false;
    private MultiverseCore mv = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.mv != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin mvPlugin = plugin.getServer().getPluginManager().getPlugin("Multiverse-Core");
                if (mvPlugin instanceof MultiverseCore) {
                    this.mv = (MultiverseCore)mvPlugin;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.mv != null) {
                plugin.getLogger().info("Multiverse-Core found, will respect PVP settings");
            }
        } else {
            this.mv = null;
        }
    }

    public boolean isPVPAllowed(World world) {
        if (!this.enabled || this.mv == null || world == null) {
            return true;
        }
        return this.mv.getMVWorldManager().getMVWorld(world).isPVPEnabled();
    }
}

