/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FactionsManager {
    private boolean enabled = false;
    private Class<?> factionsManager = null;
    private Method factionsCanBuildMethod = null;
    private Method psFactoryMethod = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.factionsManager != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            Plugin factionsPlugin = plugin.getServer().getPluginManager().getPlugin("Factions");
            if (factionsPlugin != null) {
                try {
                    Class<?> psClass = Class.forName("com.massivecraft.massivecore.ps.PS");
                    this.factionsManager = Class.forName("com.massivecraft.factions.engine.EngineMain");
                    this.factionsCanBuildMethod = this.factionsManager.getMethod("canPlayerBuildAt", Object.class, psClass, Boolean.TYPE);
                    this.psFactoryMethod = psClass.getMethod("valueOf", Location.class);
                    if (this.factionsManager == null || this.factionsCanBuildMethod == null || this.psFactoryMethod == null) {
                        this.factionsManager = null;
                        this.factionsCanBuildMethod = null;
                        this.psFactoryMethod = null;
                    }
                }
                catch (Throwable ex) {
                    this.psFactoryMethod = null;
                    try {
                        this.factionsManager = Class.forName("com.massivecraft.factions.listeners.FactionsBlockListener");
                        this.factionsCanBuildMethod = this.factionsManager.getMethod("playerCanBuildDestroyBlock", Player.class, Block.class, String.class, Boolean.TYPE);
                        if (this.factionsManager == null || this.factionsCanBuildMethod == null) {
                            this.factionsManager = null;
                            this.factionsCanBuildMethod = null;
                        } else {
                            plugin.getLogger().info("Factions 1.8.2+ build found");
                        }
                    }
                    catch (Throwable ex2) {
                        plugin.getLogger().log(Level.WARNING, "Failed to find mcore", ex);
                        plugin.getLogger().log(Level.WARNING, "Failed to find FactionsBlockListener", ex2);
                    }
                }
                if (this.factionsManager == null) {
                    plugin.getLogger().info("Factions integration failed.");
                } else {
                    plugin.getLogger().info("Factions found, will integrate for build checks.");
                }
            } else {
                plugin.getLogger().info("Factions not found, will not integrate.");
            }
        } else {
            plugin.getLogger().info("Factions integration disabled");
        }
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.factionsManager != null && this.factionsCanBuildMethod != null) {
            if (player == null) {
                return false;
            }
            try {
                if (this.psFactoryMethod != null) {
                    Object loc = this.psFactoryMethod.invoke(null, block.getLocation());
                    return loc != null && (Boolean)this.factionsCanBuildMethod.invoke(null, player, loc, false) != false;
                }
                return (Boolean)this.factionsCanBuildMethod.invoke(null, player, block, "destroy", true);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

