/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.TriggeredCompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class TNTAction
extends TriggeredCompoundAction {
    private int size;
    private int count;
    private int fuse;
    private boolean useFire;
    private boolean breakBlocks;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.parameters = parameters;
        this.size = parameters.getInt("size", 6);
        this.count = parameters.getInt("count", 1);
        this.fuse = parameters.getInt("fuse", 80);
        this.useFire = parameters.getBoolean("fire", false);
        this.breakBlocks = parameters.getBoolean("break_blocks", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        int size = (int)(mage.getRadiusMultiplier() * (float)this.size);
        Location loc = context.getWandLocation();
        if (loc == null) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (!context.hasBuildPermission(loc.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Random rand = new Random();
        for (int i = 0; i < this.count; ++i) {
            TNTPrimed grenade;
            Location targetLoc = loc.clone();
            if (this.count > 1) {
                targetLoc.setX(targetLoc.getX() + (double)rand.nextInt(2 * this.count) - (double)this.count);
                targetLoc.setZ(targetLoc.getZ() + (double)rand.nextInt(2 * this.count) - (double)this.count);
            }
            if ((grenade = (TNTPrimed)context.getWorld().spawnEntity(targetLoc, EntityType.PRIMED_TNT)) == null) {
                return SpellResult.FAIL;
            }
            Vector aim = context.getDirection();
            grenade.setVelocity(aim);
            grenade.setYield((float)size);
            grenade.setFuseTicks(this.fuse);
            grenade.setIsIncendiary(this.useFire);
            Collection<EffectPlayer> projectileEffects = context.getEffects("projectile");
            for (EffectPlayer effectPlayer : projectileEffects) {
                effectPlayer.start(grenade.getLocation(), (Entity)grenade, null, null);
            }
            context.registerForUndo((Entity)grenade);
            if (!this.breakBlocks) {
                grenade.setMetadata("cancel_explosion", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
            }
            ActionHandler.setActions((Entity)grenade, this.actions, context, this.parameters, "indirect_player_message");
            ActionHandler.setEffects((Entity)grenade, context, "explode");
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("size");
        parameters.add("count");
        parameters.add("fuse");
        parameters.add("fire");
        parameters.add("break_blocks");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("fire") || parameterKey.equals("break_blocks")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("size") || parameterKey.equals("count") || parameterKey.equals("fuse")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }
}

