/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WandOrganizer {
    private final Wand wand;
    private final Mage mage;
    protected static final int inventoryOrganizeSize = 22;
    protected static final int inventoryOrganizeNewGroupSize = 16;
    protected static final int favoriteCastCountThreshold = 20;
    protected static final int favoriteCountThreshold = 8;
    protected static final int favoritePageSize = 16;
    private int currentInventoryIndex = 0;
    private int currentInventoryCount = 0;

    public WandOrganizer(Wand wand, Mage mage) {
        this.wand = wand;
        this.mage = mage;
    }

    public WandOrganizer(Wand wand) {
        this.wand = wand;
        this.mage = null;
    }

    protected void removeHotbar(Map<String, Integer> spells, Map<String, Integer> brushes) {
        List<Inventory> hotbars = this.wand.getHotbars();
        for (Inventory hotbar : hotbars) {
            int hotbarSize = hotbar.getSize();
            for (int i = 0; i < hotbarSize; ++i) {
                ItemStack hotbarItem = hotbar.getItem(i);
                if (hotbarItem == null || hotbarItem.getType() == Material.AIR) continue;
                String spellName = Wand.getSpell(hotbarItem);
                if (spellName != null) {
                    spells.remove(spellName);
                    continue;
                }
                String materialKey = Wand.getBrush(hotbarItem);
                if (materialKey == null) continue;
                brushes.remove(materialKey);
            }
        }
    }

    public void organize() {
        Map<String, Integer> spells = this.wand.getSpellInventory();
        Map<String, Integer> brushes = this.wand.getBrushInventory();
        this.removeHotbar(spells, brushes);
        MagicController master = this.wand.getMaster();
        TreeMap favoriteSpells = new TreeMap();
        TreeMap<String, TreeSet<String>> groupedSpells = new TreeMap<String, TreeSet<String>>();
        for (String spellName : spells.keySet()) {
            TreeSet<String> spellList;
            String category;
            long castCount;
            MageSpell mageSpell = this.mage == null ? null : this.mage.getSpell(spellName);
            SpellTemplate spell = mageSpell == null ? master.getSpellTemplate(spellName) : mageSpell;
            if (spell == null) continue;
            long l = castCount = mageSpell == null ? 0L : mageSpell.getCastCount();
            if (castCount > 20L) {
                List<String> favorites = null;
                if (!favoriteSpells.containsKey(castCount)) {
                    favorites = new ArrayList();
                    favoriteSpells.put(castCount, favorites);
                } else {
                    favorites = (List)favoriteSpells.get(castCount);
                }
                favorites.add(spellName);
            }
            if ((category = spell.getCategory().getKey()) == null || category.length() == 0) {
                category = "default";
            }
            if ((spellList = (TreeSet<String>)groupedSpells.get(category)) == null) {
                spellList = new TreeSet<String>();
                groupedSpells.put(category, spellList);
            }
            spellList.add(spellName);
        }
        TreeMap<String, String> materials = new TreeMap<String, String>();
        if (this.wand.getBrushMode() == WandMode.INVENTORY) {
            for (String materialKey : brushes.keySet()) {
                if (MaterialBrush.isSpecialMaterialKey(materialKey)) {
                    materials.put(" " + materialKey, materialKey);
                    continue;
                }
                materials.put(materialKey, materialKey);
            }
        }
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        HashSet<String> addedFavorites = new HashSet<String>();
        ArrayList<String> favoriteList = new ArrayList<String>();
        block2: for (List favorites : favoriteSpells.descendingMap().values()) {
            if (addedFavorites.size() >= 16) break;
            for (String spellName : favorites) {
                addedFavorites.add(spellName);
                favoriteList.add(spellName);
                if (addedFavorites.size() < 16) continue;
                continue block2;
            }
        }
        if (addedFavorites.size() > 8) {
            for (String favorite : favoriteList) {
                int slot = this.getNextSlot();
                spells.put(favorite, slot);
            }
            this.nextPage();
        } else {
            addedFavorites.clear();
        }
        for (Collection spellGroup : groupedSpells.values()) {
            if (this.currentInventoryCount > 16) {
                this.nextPage();
            }
            for (String spellName : spellGroup) {
                if (addedFavorites.contains(spellName)) continue;
                int slot = this.getNextSlot();
                spells.put(spellName, slot);
            }
        }
        if (materials.size() > 0) {
            this.nextPage();
            for (String materialName : materials.values()) {
                brushes.put(materialName, this.getNextSlot());
            }
        }
        this.wand.updateSpellInventory(spells);
        if (materials.size() > 0) {
            this.wand.updateBrushInventory(brushes);
        }
    }

    public void alphabetize() {
        Map<String, Integer> spells = this.wand.getSpellInventory();
        Map<String, Integer> brushes = this.wand.getBrushInventory();
        this.removeHotbar(spells, brushes);
        TreeMap<String, String> materials = new TreeMap<String, String>();
        if (this.wand.getBrushMode() == WandMode.INVENTORY) {
            for (String materialKey : brushes.keySet()) {
                if (MaterialBrush.isSpecialMaterialKey(materialKey)) {
                    materials.put(" " + materialKey, materialKey);
                    continue;
                }
                materials.put(materialKey, materialKey);
            }
        }
        TreeMap<String, String> alphabetized = new TreeMap<String, String>();
        Iterator<String> i$ = spells.keySet().iterator();
        while (i$.hasNext()) {
            String spellKey;
            String name = spellKey = i$.next();
            SpellTemplate spell = this.wand.getController().getSpellTemplate(spellKey);
            if (spell != null) {
                name = spell.getName();
            }
            alphabetized.put(name, spellKey);
        }
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        for (String spellName : alphabetized.values()) {
            spells.put(spellName, this.getNextSlot(27));
        }
        if (materials.size() > 0) {
            this.nextPage();
            for (String materialName : materials.values()) {
                brushes.put(materialName, this.getNextSlot(27));
            }
        }
        this.wand.updateSpellInventory(spells);
        if (materials.size() > 0) {
            this.wand.updateBrushInventory(brushes);
        }
    }

    protected int getNextSlot() {
        return this.getNextSlot(22);
    }

    protected int getNextSlot(int nextPageSize) {
        int slot = this.wand.getHotbarSize() + this.currentInventoryCount + this.currentInventoryIndex * 27;
        ++this.currentInventoryCount;
        if (this.currentInventoryCount > nextPageSize) {
            this.nextPage();
        }
        return slot;
    }

    protected void nextPage() {
        this.currentInventoryCount = 0;
        ++this.currentInventoryIndex;
    }
}

