/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.RandomUtils;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ConeLocationEffect
extends LocationEffect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public float lenghtGrow = 0.05f;
    public double angularVelocity = 0.19634954084936207;
    public int particles = 10;
    public float radiusGrow = 0.006f;
    public int particlesCone = 180;
    public double rotation = 0.0;
    public boolean randomize = false;
    protected int step = 0;

    public ConeLocationEffect(EffectManager effectManager, Location location) {
        super(effectManager, location);
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        for (int x = 0; x < this.particles; ++x) {
            if (this.step > this.particlesCone) {
                this.step = 0;
            }
            if (this.randomize && this.step == 0) {
                this.rotation = RandomUtils.getRandomAngle();
            }
            double angle = (double)this.step * this.angularVelocity + this.rotation;
            float radius = (float)this.step * this.radiusGrow;
            float lenght = (float)this.step * this.lenghtGrow;
            Vector v = new Vector(Math.cos(angle) * (double)radius, (double)lenght, Math.sin(angle) * (double)radius);
            VectorUtils.rotateAroundAxisX(v, (this.location.getPitch() + 90.0f) * ((float)Math.PI / 180));
            VectorUtils.rotateAroundAxisY(v, -this.location.getYaw() * ((float)Math.PI / 180));
            this.location.add(v);
            this.particle.display(this.location, (double)this.visibleRange, 0.0f, 0.0f, 0.0f, 0.0f, 0);
            this.location.subtract(v);
            ++this.step;
        }
    }
}

