/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialAndData {
    protected Material material;
    protected Short data;
    protected String[] signLines = null;
    protected String commandLine = null;
    protected String customName = null;
    protected ItemStack[] inventoryContents = null;
    protected boolean isValid = true;
    protected BlockFace rotation = null;
    protected Object customData = null;
    protected SkullType skullType = null;
    protected DyeColor color = null;
    public Material DEFAULT_MATERIAL;

    public MaterialAndData() {
        this.material = this.DEFAULT_MATERIAL = Material.AIR;
        this.data = 0;
    }

    public MaterialAndData(Material material) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, short data) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = material;
        this.data = data;
    }

    public MaterialAndData(ItemStack item) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = item.getType();
        this.data = item.getDurability();
        if (this.material == Material.SKULL_ITEM) {
            ItemMeta meta = item.getItemMeta();
            this.customData = InventoryUtils.getSkullProfile(meta);
            try {
                this.skullType = SkullType.values()[this.data];
            }
            catch (Exception exception) {}
        } else if (this.material.getId() == 425) {
            ItemMeta meta = item.getItemMeta();
            this.customData = InventoryUtils.getBannerPatterns(meta);
            this.color = InventoryUtils.getBannerBaseColor(meta);
        }
    }

    public MaterialAndData(Block block) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.updateFrom(block);
    }

    public MaterialAndData(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.updateFrom(other);
    }

    public MaterialAndData(Material material, byte data, String customName) {
        this(material, data);
        this.customName = customName;
    }

    public MaterialAndData(String materialKey) {
        this();
        this.update(materialKey);
    }

    public void update(String materialKey) {
        Material material;
        Short data;
        block22: {
            if (materialKey == null || materialKey.length() == 0) {
                this.isValid = false;
                return;
            }
            String[] pieces = MaterialAndData.splitMaterialKey(materialKey);
            data = 0;
            material = null;
            try {
                if (pieces.length > 0) {
                    if (pieces[0].equals("*")) {
                        material = null;
                    } else {
                        try {
                            Integer id = Integer.parseInt(pieces[0]);
                            material = Material.getMaterial((int)id);
                        }
                        catch (Exception ex) {
                            material = Material.getMaterial((String)pieces[0].toUpperCase());
                        }
                    }
                }
            }
            catch (Exception ex) {
                material = null;
            }
            try {
                if (pieces.length <= 1) break block22;
                if (pieces[1].equals("*")) {
                    data = null;
                    break block22;
                }
                if (material == Material.MOB_SPAWNER) {
                    this.customName = pieces[1];
                    this.setMaterial(Material.MOB_SPAWNER, (short)0);
                    return;
                }
                if (material == Material.SKULL_ITEM) {
                    if (pieces.length > 2) {
                        this.setMaterial(Material.SKULL_ITEM, (short)3);
                        this.skullType = SkullType.PLAYER;
                        String dataString = pieces[1];
                        for (int i = 2; i < pieces.length; ++i) {
                            dataString = dataString + ":" + pieces[i];
                        }
                        ItemStack item = InventoryUtils.getURLSkull(dataString);
                        this.customData = InventoryUtils.getSkullProfile(item.getItemMeta());
                    } else {
                        try {
                            data = Short.parseShort(pieces[1]);
                            this.setMaterial(Material.SKULL_ITEM, data);
                        }
                        catch (Exception ex) {
                            this.setMaterial(Material.SKULL_ITEM, (short)3);
                            this.skullType = SkullType.PLAYER;
                            ItemStack item = InventoryUtils.getPlayerSkull(pieces[1]);
                            this.customData = InventoryUtils.getSkullProfile(item.getItemMeta());
                        }
                    }
                    return;
                }
                try {
                    data = Short.parseShort(pieces[1]);
                }
                catch (Exception ex) {
                    data = 0;
                }
            }
            catch (Exception ex) {
                material = null;
            }
        }
        if (material == null) {
            this.setMaterial(null, null);
            this.isValid = false;
        } else {
            this.setMaterial(material, data);
        }
    }

    public int hashCode() {
        return this.material.getId() << 16 | this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MaterialAndData)) {
            return false;
        }
        MaterialAndData other = (MaterialAndData)obj;
        return other.data == this.data && other.material == this.material;
    }

    @Override
    public void updateFrom(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.material = other.getMaterial();
        this.data = other.getData();
        if (other instanceof MaterialAndData) {
            MaterialAndData o = (MaterialAndData)other;
            this.commandLine = o.commandLine;
            this.inventoryContents = o.inventoryContents;
            this.signLines = o.signLines;
            this.customName = o.customName;
            this.isValid = o.isValid;
            this.skullType = o.skullType;
            this.customData = o.customData;
            this.color = o.color;
        }
    }

    @Override
    public void setMaterial(Material material, short data) {
        this.setMaterial(material, (Short)data);
    }

    public void setMaterial(Material material, Short data) {
        this.material = material;
        this.data = data;
        this.signLines = null;
        this.commandLine = null;
        this.inventoryContents = null;
        this.customName = null;
        this.skullType = null;
        this.customData = null;
        this.color = null;
        this.isValid = true;
    }

    @Override
    public void setMaterial(Material material) {
        this.setMaterial(material, (short)0);
    }

    @Override
    public void updateFrom(Block block) {
        this.updateFrom(block, null);
    }

    public void updateFrom(Block block, Set<Material> restrictedMaterials) {
        if (block == null) {
            this.isValid = false;
            return;
        }
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return;
        }
        Material blockMaterial = block.getType();
        if (restrictedMaterials != null && restrictedMaterials.contains(blockMaterial)) {
            this.isValid = false;
            return;
        }
        this.signLines = null;
        this.commandLine = null;
        this.inventoryContents = null;
        this.customName = null;
        this.skullType = null;
        this.customData = null;
        this.color = null;
        try {
            BlockState blockState = block.getState();
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                this.signLines = sign.getLines();
            } else if (blockState instanceof CommandBlock) {
                CommandBlock command = (CommandBlock)blockState;
                this.commandLine = command.getCommand();
                this.customName = command.getName();
            } else if (blockState instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)blockState;
                Inventory holderInventory = holder.getInventory();
                this.inventoryContents = holderInventory.getContents();
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                this.rotation = skull.getRotation();
                this.skullType = skull.getSkullType();
                this.customData = CompatibilityUtils.getSkullProfile(skull);
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                this.customName = spawner.getCreatureTypeName();
            } else if (blockMaterial.getId() == 176 || blockMaterial.getId() == 177) {
                this.customData = CompatibilityUtils.getBannerPatterns(blockState);
                this.color = CompatibilityUtils.getBannerBaseColor(blockState);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.material = blockMaterial;
        this.data = block.getData();
        this.isValid = true;
    }

    @Override
    public void modify(Block block) {
        this.modify(block, false);
    }

    @Override
    public void modify(Block block, boolean applyPhysics) {
        if (!this.isValid) {
            return;
        }
        try {
            BlockState blockState;
            BlockState oldState = block.getState();
            if (oldState instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)oldState;
                Inventory inventory = holder.getInventory();
                inventory.clear();
                oldState.update();
            }
            if (this.material != null) {
                byte blockData = this.data != null ? (byte)this.data.shortValue() : block.getData();
                block.setTypeIdAndData(this.material.getId(), blockData, applyPhysics);
            }
            if ((blockState = block.getState()) != null && this.material != null && this.material.getId() == 176 || this.material.getId() == 177) {
                CompatibilityUtils.setBannerPatterns(blockState, this.customData);
                CompatibilityUtils.setBannerBaseColor(blockState, this.color);
                blockState.update(true, false);
            } else if (blockState instanceof Sign && this.signLines != null) {
                Sign sign = (Sign)blockState;
                for (int i = 0; i < this.signLines.length; ++i) {
                    sign.setLine(i, this.signLines[i]);
                }
                sign.update();
            } else if (blockState instanceof CommandBlock && this.commandLine != null) {
                CommandBlock command = (CommandBlock)blockState;
                command.setCommand(this.commandLine);
                if (this.customName != null) {
                    command.setName(this.customName);
                }
                command.update();
            } else if (blockState instanceof InventoryHolder && this.inventoryContents != null) {
                InventoryHolder holder = (InventoryHolder)blockState;
                Inventory newInventory = holder.getInventory();
                int maxSize = Math.min(newInventory.getSize(), this.inventoryContents.length);
                for (int i = 0; i < maxSize; ++i) {
                    ItemStack item = this.inventoryContents[i];
                    if ((item = NMSUtils.getCopy(item)) == null) continue;
                    newInventory.setItem(i, item);
                }
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                if (this.skullType != null) {
                    skull.setSkullType(this.skullType);
                }
                if (this.rotation != null) {
                    skull.setRotation(this.rotation);
                }
                if (this.customData != null) {
                    CompatibilityUtils.setSkullProfile(skull, this.customData);
                }
                skull.update(true, false);
            } else if (blockState instanceof CreatureSpawner && this.customName != null && this.customName.length() > 0) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                spawner.setCreatureTypeByName(this.customName);
                spawner.update();
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Error updating block state: " + ex.getMessage());
        }
    }

    @Override
    public Short getData() {
        return this.data;
    }

    @Override
    public Byte getBlockData() {
        return this.data == null ? null : Byte.valueOf((byte)this.data.shortValue());
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getKey() {
        return this.getKey(this.data);
    }

    public String getKey(Short data) {
        String materialKey;
        String string = materialKey = this.material == null ? "*" : this.material.name().toLowerCase();
        if (data == null) {
            materialKey = materialKey + ":*";
        } else if (this.material == Material.SKULL_ITEM && this.customData != null) {
            materialKey = materialKey + ":" + InventoryUtils.getProfileURL(this.customData);
        } else if (this.material == Material.MOB_SPAWNER && this.customName != null && this.customName.length() > 0) {
            materialKey = materialKey + ":" + this.customName;
        } else if (data != 0) {
            materialKey = materialKey + ":" + data;
        }
        return materialKey;
    }

    public String getWildDataKey() {
        return this.getKey(null);
    }

    @Override
    public boolean is(Block block) {
        return this.material == block.getType() && this.data.shortValue() == block.getData();
    }

    @Override
    public boolean isDifferent(Block block) {
        CommandBlock command;
        Material blockMaterial = block.getType();
        byte blockData = block.getData();
        if (this.material != null && blockMaterial != this.material || this.data != null && blockData != this.data) {
            return true;
        }
        if (this.material.getId() == 176 || this.material.getId() == 177) {
            return true;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Sign && this.signLines != null) {
            Sign sign = (Sign)blockState;
            String[] currentLines = sign.getLines();
            for (int i = 0; i < this.signLines.length; ++i) {
                if (currentLines[i].equals(this.signLines[i])) continue;
                return true;
            }
        } else if (blockState instanceof CommandBlock && this.commandLine != null ? !(command = (CommandBlock)blockState).getCommand().equals(this.commandLine) : blockState instanceof InventoryHolder && this.inventoryContents != null) {
            return true;
        }
        return false;
    }

    @Override
    public void setSignLines(String[] lines) {
        this.signLines = (String[])lines.clone();
    }

    @Override
    public String[] getSignLines() {
        return (String[])this.signLines.clone();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setInventoryContents(ItemStack[] contents) {
        this.inventoryContents = contents;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        ItemStack stack = new ItemStack(this.material, amount, this.data.shortValue());
        this.applyToItem(stack);
        return stack;
    }

    public ItemStack applyToItem(ItemStack stack) {
        stack.setType(this.material);
        stack.setDurability(this.data.shortValue());
        if (this.material == Material.SKULL_ITEM) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof SkullMeta && this.customData != null) {
                SkullMeta skullMeta = (SkullMeta)meta;
                InventoryUtils.setSkullProfile((ItemMeta)skullMeta, this.customData);
                stack.setItemMeta(meta);
            }
        } else if (this.material.getId() == 425) {
            ItemMeta meta = stack.getItemMeta();
            InventoryUtils.setBannerPatterns(meta, this.customData);
            InventoryUtils.setBannerBaseColor(meta, this.color);
        }
        return stack;
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split((String)materialKey, (String)"|");
        }
        if (materialKey.contains(":")) {
            return StringUtils.split((String)materialKey, (String)":");
        }
        return new String[]{materialKey};
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static String getMaterialName(ItemStack item) {
        MaterialAndData material = new MaterialAndData(item.getType(), item.getDurability());
        return material.getName();
    }

    public static String getMaterialName(Block block) {
        MaterialAndData material = new MaterialAndData(block.getType(), block.getData());
        return material.getName();
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getBaseName() {
        if (this.material == null) {
            return null;
        }
        return this.material.name().toLowerCase().replace('_', ' ');
    }

    public String getName(Messages messages) {
        String vaultName;
        if (!this.isValid()) {
            return null;
        }
        VaultController controller = VaultController.getInstance();
        if (controller != null && this.data != null && (vaultName = controller.getItemName(this.material, this.data)) != null && !vaultName.isEmpty()) {
            return vaultName;
        }
        String customName = this.getCustomName();
        String materialName = this.material.name();
        if (this.data != null) {
            if (this.material == Material.CARPET || this.material == Material.STAINED_GLASS || this.material == Material.STAINED_CLAY || this.material == Material.STAINED_GLASS_PANE || this.material == Material.WOOL) {
                DyeColor color = DyeColor.getByWoolData((byte)((byte)this.data.shortValue()));
                if (color != null) {
                    materialName = color.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (this.material == Material.WOOD || this.material == Material.LOG || this.material == Material.SAPLING || this.material == Material.LEAVES || this.material == Material.LOG_2 || this.material == Material.LEAVES_2) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)((byte)this.data.shortValue()));
                if (treeSpecies != null) {
                    materialName = treeSpecies.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (this.material == Material.MOB_SPAWNER && customName != null && customName.length() > 0) {
                materialName = materialName + " (" + customName + ")";
            }
        } else {
            materialName = materialName + messages.get("material.wildcard");
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    @Override
    public void setCommandLine(String command) {
        this.commandLine = command;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine;
    }

    @Override
    public void setData(Short data) {
        this.data = data;
    }
}

