/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class UndoAction
extends BaseSpellAction {
    private String undoListName;
    private int timeout;
    private String targetSpellKey;
    private boolean targetSelf;
    private boolean targetDown;
    private boolean targetBlocks;
    private boolean cancel;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.timeout = parameters.getInt("target_timeout", 0);
        this.targetSelf = parameters.getBoolean("target_self", false);
        this.targetDown = parameters.getBoolean("target_down", false);
        this.targetBlocks = parameters.getBoolean("target_blocks", true);
        this.cancel = parameters.getBoolean("cancel", true);
        this.targetSpellKey = parameters.getString("target_spell", null);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        SpellResult result = SpellResult.CAST;
        if (this.targetSelf) {
            Mage mage = context.getMage();
            targetEntity = context.getEntity();
            context.setTargetName(mage.getName());
            result = SpellResult.ALTERNATE_UP;
        }
        MageController controller = context.getController();
        if (targetEntity != null && controller.isMage(targetEntity)) {
            UndoQueue queue;
            UndoList undoList;
            Mage targetMage = controller.getMage(targetEntity);
            Batch batch = targetMage.cancelPending(this.targetSpellKey);
            if (batch != null) {
                String string = this.undoListName = batch instanceof SpellBatch ? ((SpellBatch)batch).getSpell().getName() : null;
                if (this.cancel) {
                    return SpellResult.DEACTIVATE;
                }
            }
            if ((undoList = (queue = targetMage.getUndoQueue()).undoRecent(this.timeout, this.targetSpellKey)) != null) {
                this.undoListName = undoList.getName();
            }
            return undoList != null ? result : SpellResult.NO_TARGET;
        }
        if (!this.targetBlocks) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = context.getTargetBlock();
        if (this.targetDown) {
            targetBlock = context.getLocation().getBlock();
        }
        Mage mage = context.getMage();
        if (targetBlock != null) {
            boolean targetAll = mage.isSuperPowered();
            if (targetAll) {
                UndoList undid = controller.undoRecent(targetBlock, this.timeout);
                if (undid != null) {
                    Mage targetMage = undid.getOwner();
                    this.undoListName = undid.getName();
                    context.setTargetName(targetMage.getName());
                    return result;
                }
            } else {
                context.setTargetName(mage.getName());
                UndoList undoList = mage.undo(targetBlock);
                if (undoList != null) {
                    this.undoListName = undoList.getName();
                    return result;
                }
            }
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public String transformMessage(String message) {
        return message.replace("$spell", this.undoListName == null ? "Unknown" : this.undoListName);
    }
}

