/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpellShopAction
extends BaseSpellAction
implements GUIAction {
    private String requiredPath = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;
    private boolean showRequired = false;
    private boolean autoUpgrade = false;
    private boolean showFree = false;
    private boolean useXP = false;
    private boolean showConfirmation = true;
    private MaterialAndData confirmFillMaterial;
    private CastContext context;
    private com.elmakers.mine.bukkit.api.wand.Wand wand;
    private Map<String, Double> spells = new HashMap<String, Double>();
    private Map<String, Double> spellPrices = new HashMap<String, Double>();

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.spells.clear();
        if (parameters.contains("spells")) {
            ConfigurationSection spellSection = parameters.getConfigurationSection("spells");
            Set spellKeys = spellSection.getKeys(false);
            for (String spellKey : spellKeys) {
                this.spells.put(spellKey, spellSection.getDouble(spellKey));
            }
        }
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        Messages messages = this.context.getController().getMessages();
        ItemStack item = event.getCurrentItem();
        if (this.context != null && this.wand != null && Wand.isSpell(item)) {
            Mage mage = this.context.getMage();
            String spellKey = Wand.getSpell(item);
            SpellTemplate template = this.context.getController().getSpellTemplate(spellKey);
            boolean isXP = this.useXP || !VaultController.hasEconomy();
            Double worth = this.spellPrices.get(spellKey);
            worth = worth == null ? template.getWorth() : worth.doubleValue();
            boolean hasCosts = true;
            if (worth > 0.0) {
                hasCosts = isXP ? mage.getExperience() > (int)worth.doubleValue() : VaultController.getInstance().has(mage.getPlayer(), worth);
            }
            if (!hasCosts) {
                String costString = this.context.getMessage("insufficient_resources");
                if (isXP) {
                    String xpAmount = Integer.toString((int)worth.doubleValue());
                    xpAmount = messages.get("costs.xp_amount").replace("$amount", xpAmount);
                    costString = costString.replace("$cost", xpAmount);
                } else {
                    costString = costString.replace("$cost", VaultController.getInstance().format(worth));
                }
                this.context.sendMessage(costString);
            } else {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath nextPath;
                if (InventoryUtils.hasMeta(item, "confirm")) {
                    String inventoryTitle = this.context.getMessage("confirm_title", "Buy $spell").replace("$spell", template.getName());
                    Inventory confirmInventory = CompatibilityUtils.createInventory(null, 9, inventoryTitle);
                    InventoryUtils.removeMeta(item, "confirm");
                    for (int i = 0; i < 9; ++i) {
                        if (i != 4) {
                            ItemStack filler = this.confirmFillMaterial.getItemStack(1);
                            ItemMeta meta = filler.getItemMeta();
                            if (meta != null) {
                                meta.setDisplayName(ChatColor.DARK_GRAY + (i < 4 ? "-->" : "<--"));
                                filler.setItemMeta(meta);
                            }
                            confirmInventory.setItem(i, filler);
                            continue;
                        }
                        confirmInventory.setItem(i, item);
                    }
                    mage.deactivateGUI();
                    mage.activateGUI(this);
                    mage.getPlayer().openInventory(confirmInventory);
                    return;
                }
                String costString = this.context.getMessage("deducted");
                if (isXP) {
                    String xpAmount = Integer.toString((int)worth.doubleValue());
                    xpAmount = messages.get("costs.xp_amount").replace("$amount", xpAmount);
                    costString = costString.replace("$cost", xpAmount);
                } else {
                    costString = costString.replace("$cost", VaultController.getInstance().format(worth));
                }
                costString = costString.replace("$spell", template.getName());
                this.context.sendMessage(costString);
                if (isXP) {
                    mage.removeExperience((int)worth.doubleValue());
                } else {
                    VaultController.getInstance().withdrawPlayer(mage.getPlayer(), worth);
                }
                this.wand.addSpell(spellKey);
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.wand.getPath();
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath wandUpgradePath = nextPath = path != null ? path.getUpgrade() : null;
                if (nextPath != null && this.autoUpgrade && path.checkUpgradeRequirements(this.wand, null) && !path.canEnchant(this.wand)) {
                    path.upgrade(this.wand, mage);
                }
            }
            mage.deactivateGUI();
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requiredPath = parameters.getString("path", null);
        this.exactPath = parameters.getString("path_exact", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.showRequired = parameters.getBoolean("show_required", false);
        this.showFree = parameters.getBoolean("show_free", false);
        this.autoUpgrade = parameters.getBoolean("auto_upgrade", false);
        this.useXP = parameters.getBoolean("use_xp", false);
        this.showConfirmation = parameters.getBoolean("confirm", true);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
        }
        this.confirmFillMaterial = ConfigurationUtils.getMaterialAndData(parameters, "confirm_filler", new MaterialAndData(Material.AIR));
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        this.wand = mage.getActiveWand();
        this.context = context;
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.wand == null) {
            context.sendMessage("no_wand");
            return SpellResult.FAIL;
        }
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.wand.getPath();
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                context.sendMessage(context.getMessage("no_path").replace("$wand", this.wand.getName()));
                return SpellResult.FAIL;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath) || this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath requiresPath = WandUpgradePath.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.sendMessage(context.getMessage("no_required_path").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath pathUpgrade = path.getUpgrade();
                if (pathUpgrade == null) {
                    context.sendMessage(context.getMessage("no_upgrade").replace("$wand", this.wand.getName()));
                    return SpellResult.FAIL;
                }
                if (path.canEnchant(this.wand)) {
                    context.sendMessage(context.getMessage("no_path_end").replace("$path", pathUpgrade.getName()));
                    return SpellResult.FAIL;
                }
            }
        }
        this.spellPrices.clear();
        if (this.spells.size() > 0) {
            this.spellPrices.putAll(this.spells);
        } else {
            if (path == null) {
                context.sendMessage(context.getMessage("no_path").replace("$wand", this.wand.getName()));
                return SpellResult.FAIL;
            }
            Collection<String> pathSpells = path.getSpells();
            for (String pathSpell : pathSpells) {
                this.spellPrices.put(pathSpell, null);
            }
            if (this.showRequired) {
                Collection<String> requiredSpells = path.getRequiredSpells();
                for (String requiredSpell : requiredSpells) {
                    this.spellPrices.put(requiredSpell, null);
                }
            }
        }
        ArrayList<ItemStack> spellItems = new ArrayList<ItemStack>();
        MagicAPI api = MagicPlugin.getAPI();
        boolean isXP = this.useXP || !VaultController.hasEconomy();
        String costString = context.getMessage("cost_lore");
        Messages messages = context.getController().getMessages();
        for (Map.Entry<String, Double> spellValue : this.spellPrices.entrySet()) {
            String costs;
            String spellKey = spellValue.getKey();
            if (this.wand.hasSpell(spellKey)) continue;
            SpellTemplate spell = api.getSpellTemplate(spellKey);
            Double worth = spellValue.getValue();
            if (worth == null) {
                worth = spell.getWorth();
                this.spellPrices.put(spellKey, worth);
            }
            if (worth <= 0.0 && !this.showFree) continue;
            ItemStack spellItem = api.createSpellItem(spellKey);
            ItemMeta meta = spellItem.getItemMeta();
            List lore = meta.getLore();
            if (isXP) {
                String xpAmount = Integer.toString((int)worth.doubleValue());
                xpAmount = messages.get("costs.xp_amount").replace("$amount", xpAmount);
                costs = costString.replace("$cost", xpAmount);
            } else {
                costs = costString.replace("$cost", VaultController.getInstance().format(worth));
            }
            lore.add(ChatColor.GOLD + costs);
            meta.setLore(lore);
            spellItem.setItemMeta(meta);
            if (this.showConfirmation) {
                InventoryUtils.setMeta(spellItem, "confirm", "true");
            }
            spellItems.add(spellItem);
        }
        if (spellItems.size() == 0) {
            context.sendMessage("no_spells");
            return SpellResult.FAIL;
        }
        String inventoryTitle = context.getMessage("title", "Spells ($balance)");
        if (isXP) {
            String xpAmount = Integer.toString(mage.getExperience());
            xpAmount = messages.get("costs.xp_amount").replace("$amount", xpAmount);
            inventoryTitle = inventoryTitle.replace("$balance", xpAmount);
        } else {
            double balance = VaultController.getInstance().getBalance(player);
            inventoryTitle = inventoryTitle.replace("$balance", VaultController.getInstance().format(balance));
        }
        int invSize = (spellItems.size() + 9) / 9 * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (ItemStack item : spellItems) {
            displayInventory.addItem(new ItemStack[]{item});
        }
        mage.activateGUI(this);
        mage.getPlayer().openInventory(displayInventory);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("show_free");
        parameters.add("show_required");
        parameters.add("auto_upgrade");
        parameters.add("confirm");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        } else if (parameterKey.equals("show_free") || parameterKey.equals("show_required") || parameterKey.equals("auto_upgrade") || parameterKey.equals("confirm")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

