/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class RetargetAction
extends CompoundAction {
    private int range;
    private boolean useHitbox;
    private double fov;
    private double closeRange;
    private double closeFOV;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.useHitbox = parameters.getBoolean("hitbox", false);
        this.range = parameters.getInt("range", 32);
        this.fov = parameters.getDouble("fov", 0.3);
        this.closeRange = parameters.getDouble("close_range", 1.0);
        this.closeFOV = parameters.getDouble("close_fov", 0.5);
    }

    @Override
    public SpellResult perform(CastContext context) {
        this.createActionContext(context);
        this.actionContext.addWork(this.range);
        this.actionContext.retarget(this.range, this.fov, this.closeRange, this.closeFOV, this.useHitbox);
        return this.performActions(this.actionContext);
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("fov");
        parameters.add("target_count");
        parameters.add("hitbox");
        parameters.add("range");
        parameters.add("close_range");
        parameters.add("close_fov");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("hitbox")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("target_count") || parameterKey.equals("range") || parameterKey.equals("fov") || parameterKey.equals("close_range") || parameterKey.equals("close_fov")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

