/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.action.ActionContext;
import com.elmakers.mine.bukkit.action.builtin.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.batch.BlockRecurse;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class RecurseSpell
extends BrushSpell {
    private final BlockRecurse blockRecurse = new BlockRecurse();

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        byte i;
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (!this.isDestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        int size = parameters.getInt("size", 8);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        this.blockRecurse.setMaxRecursion(size);
        ReplaceMaterialAction action = new ReplaceMaterialAction();
        action.initialize(parameters);
        action.addReplaceable(new MaterialAndData(targetBlock));
        Material targetMaterial = targetBlock.getType();
        if (targetMaterial == Material.STATIONARY_WATER || targetMaterial == Material.WATER) {
            for (i = 0; i < 9; i = (byte)(i + 1)) {
                action.addReplaceable(Material.STATIONARY_WATER, i);
                action.addReplaceable(Material.WATER, i);
            }
        } else if (targetMaterial == Material.STATIONARY_LAVA || targetMaterial == Material.LAVA) {
            for (i = 0; i < 9; i = (byte)(i + 1)) {
                action.addReplaceable(Material.STATIONARY_LAVA, i);
                action.addReplaceable(Material.LAVA, i);
            }
        } else if (targetMaterial == Material.SNOW) {
            for (i = 0; i < 8; i = (byte)(i + 1)) {
                action.addReplaceable(Material.SNOW, i);
            }
        }
        CastContext context = this.getCurrentCast();
        context.setTargetLocation(targetBlock.getLocation());
        this.blockRecurse.recurse(new ActionContext(action, parameters), context);
        this.registerForUndo();
        this.controller.updateBlock(targetBlock);
        return SpellResult.CAST;
    }
}

