/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.batch;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class UndoBatch
implements com.elmakers.mine.bukkit.api.block.UndoBatch {
    protected final MageController controller;
    private UndoList trackUndoBlocks;
    private static final BlockData[] template = new BlockData[0];
    private final BlockData[] undoBlocks;
    private int undoIndex = 0;
    private boolean finishedAttachables = false;
    protected boolean finished = false;
    protected boolean applyPhysics = false;
    protected UndoList undoList;
    private final Set<Material> attachables;
    private final Set<Material> attachablesWall;
    private final Set<Material> attachablesDouble;
    private final Set<Material> delayed;

    public UndoBatch(UndoList blockList) {
        Mage mage = blockList.getOwner();
        this.controller = mage.getController();
        this.trackUndoBlocks = new UndoList(mage, blockList.getSpell(), "Undo");
        this.trackUndoBlocks.setBypass(true);
        this.undoList = blockList;
        this.applyPhysics = blockList.getApplyPhysics();
        this.attachables = this.controller.getMaterialSet("attachable");
        this.attachablesWall = this.controller.getMaterialSet("attachable_wall");
        this.attachablesDouble = this.controller.getMaterialSet("attachable_double");
        this.delayed = this.controller.getMaterialSet("delayed");
        this.undoBlocks = blockList.toArray(template);
        ArrayUtils.reverse((Object[])this.undoBlocks);
        Arrays.sort(this.undoBlocks, new Comparator<BlockData>(){

            @Override
            public int compare(BlockData block1, BlockData block2) {
                boolean attachable2;
                Material material1 = block1.getMaterial();
                Material material2 = block2.getMaterial();
                boolean attachable1 = UndoBatch.this.attachablesWall.contains(material1) || UndoBatch.this.attachables.contains(material1) || UndoBatch.this.attachablesDouble.contains(material1) || UndoBatch.this.delayed.contains(material1);
                boolean bl = attachable2 = UndoBatch.this.attachablesWall.contains(material2) || UndoBatch.this.attachables.contains(material2) || UndoBatch.this.attachablesDouble.contains(material2) || UndoBatch.this.delayed.contains(material2);
                if (attachable1 && !attachable2) {
                    return 1;
                }
                if (attachable2 && !attachable1) {
                    return -1;
                }
                return block1.getLocation().getBlockY() - block2.getLocation().getBlockY();
            }
        });
    }

    @Override
    public int size() {
        return this.undoBlocks == null ? 0 : this.undoBlocks.length;
    }

    @Override
    public int remaining() {
        return this.undoBlocks == null ? 0 : this.undoBlocks.length - this.undoIndex;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks;
        for (processedBlocks = 0; this.undoBlocks != null && this.undoIndex < this.undoBlocks.length && processedBlocks < maxBlocks; ++processedBlocks) {
            boolean isAttachable;
            BlockData blockData = this.undoBlocks[this.undoIndex];
            Block block = blockData.getBlock();
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                break;
            }
            Material material = block.getType();
            boolean bl = isAttachable = this.attachables.contains(material) || this.attachablesWall.contains(material) || this.attachablesDouble.contains(material) || this.delayed.contains(material);
            if (isAttachable && !this.finishedAttachables || !isAttachable && this.finishedAttachables) {
                this.trackUndoBlocks.add(blockData);
                if (!UndoList.undo(blockData, this.applyPhysics)) break;
            }
            ++this.undoIndex;
        }
        if (this.undoBlocks == null || this.undoIndex >= this.undoBlocks.length && this.finishedAttachables) {
            this.finish();
        } else if (this.undoIndex >= this.undoBlocks.length) {
            this.finishedAttachables = true;
            this.undoIndex = 0;
        }
        return processedBlocks;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.undoList.undoEntityEffects();
            this.finished = true;
            this.controller.update(this.trackUndoBlocks);
            UndoableSpell spell = this.undoList.getSpell();
            if (spell != null) {
                spell.playEffects("undo");
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

