/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.Schematic;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.ChestBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import java.util.Collection;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class WorldEditSchematic
implements Schematic {
    private final CuboidClipboard weSchematic;
    private org.bukkit.util.Vector center;
    private org.bukkit.util.Vector size;

    public WorldEditSchematic(Object schematic) {
        this.weSchematic = (CuboidClipboard)schematic;
        try {
            Vector weSize = this.weSchematic.getSize();
            this.size = new org.bukkit.util.Vector(weSize.getBlockX(), weSize.getBlockY(), weSize.getBlockZ());
            this.center = new org.bukkit.util.Vector(Math.floor(this.size.getBlockX() / 2), 0.0, Math.floor(this.size.getBlockZ() / 2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.center == null) {
            this.center = new org.bukkit.util.Vector(0, 0, 0);
        }
        if (this.size == null) {
            this.size = new org.bukkit.util.Vector(0, 0, 0);
        }
    }

    @Override
    public boolean contains(org.bukkit.util.Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        return x >= 0 && x <= this.size.getBlockX() && y >= 0 && y <= this.size.getBlockY() && z >= 0 && z <= this.size.getBlockZ();
    }

    @Override
    public MaterialAndData getBlock(org.bukkit.util.Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        try {
            MaterialAndData blockData;
            block25: {
                if (x < 0 || x >= this.size.getBlockZ() || y < 0 || y >= this.size.getBlockY() || z < 0 || z >= this.size.getBlockZ()) {
                    return null;
                }
                Vector vector = new Vector(x, y, z);
                BaseBlock baseBlock = this.weSchematic.getBlock(vector);
                Material material = Material.getMaterial((int)baseBlock.getId());
                int materialData = baseBlock.getData();
                blockData = new MaterialAndData(material, (byte)materialData);
                if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                    try {
                        if (baseBlock.hasNbtData()) {
                            SignBlock signBlock = new SignBlock(material.getId(), materialData);
                            CompoundTag nbtData = baseBlock.getNbtData();
                            signBlock.setNbtData(nbtData);
                            blockData.setSignLines(signBlock.getText());
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else if (material == Material.COMMAND) {
                    try {
                        if (!baseBlock.hasNbtData()) break block25;
                        CompoundTag nbtRoot = baseBlock.getNbtData();
                        Map rootValues = nbtRoot.getValue();
                        if (rootValues.containsKey("Command")) {
                            Object commandValue = ((Tag)rootValues.get("Command")).getValue();
                            blockData.setCommandLine((String)commandValue);
                        }
                        if (rootValues.containsKey("CustomName")) {
                            Object nameValue = ((Tag)rootValues.get("CustomName")).getValue();
                            blockData.setCustomName((String)nameValue);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else if (material == Material.CHEST) {
                    try {
                        if (baseBlock.hasNbtData()) {
                            ChestBlock chestBlock = new ChestBlock(materialData);
                            CompoundTag nbtRoot = baseBlock.getNbtData();
                            chestBlock.setNbtData(nbtRoot);
                            BaseItemStack[] items = chestBlock.getItems();
                            if (items != null && items.length > 0) {
                                ItemStack[] contents = new ItemStack[items.length];
                                for (int i = 0; i < items.length; ++i) {
                                    if (items[i] == null) continue;
                                    Material itemMaterial = Material.getMaterial((int)items[i].getType());
                                    short itemData = items[i].getData();
                                    int itemAmount = items[i].getAmount();
                                    ItemStack newStack = new ItemStack(itemMaterial, itemAmount, itemData);
                                    Map enchantments = items[i].getEnchantments();
                                    if (enchantments != null && enchantments.size() > 0) {
                                        for (Map.Entry enchantment : enchantments.entrySet()) {
                                            try {
                                                Enchantment enchantmentType = Enchantment.getById((int)((Integer)enchantment.getKey()));
                                                newStack.addEnchantment(enchantmentType, ((Integer)enchantment.getValue()).intValue());
                                            }
                                            catch (Exception ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
                                    contents[i] = newStack;
                                }
                                blockData.setInventoryContents(contents);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return blockData;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public Collection<EntityData> getEntities() {
        return null;
    }

    @Override
    public org.bukkit.util.Vector getSize() {
        return this.size;
    }
}

