/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public abstract class DelayedCompoundAction
extends BaseSpellAction {
    private boolean usesBrush = false;
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    protected ActionHandler actions = null;
    protected ConfigurationSection parameters;

    @Override
    public void prepare(com.elmakers.mine.bukkit.api.action.CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.parameters = parameters;
    }

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.usesBrush = false;
        this.undoable = false;
        this.requiresBuildPermission = false;
        if (parameters != null && parameters.contains("actions")) {
            this.actions = new ActionHandler();
            this.actions.load(parameters, "actions");
        }
        if (this.actions != null) {
            this.actions.initialize(parameters);
            this.updateFlags();
        }
    }

    protected void updateFlags() {
        this.usesBrush = this.usesBrush || this.actions.usesBrush();
        this.undoable = this.undoable || this.actions.isUndoable();
        this.requiresBuildPermission = this.requiresBuildPermission || this.actions.requiresBuildPermission();
    }

    public void addAction(SpellAction action) {
        this.addAction(action, null);
    }

    public void addAction(SpellAction action, ConfigurationSection parameters) {
        if (this.actions == null) {
            this.actions = new ActionHandler();
        }
        this.actions.loadAction(action, parameters);
        this.updateFlags();
    }

    protected SpellResult performActions(com.elmakers.mine.bukkit.api.action.CastContext context) {
        if (this.actions == null) {
            return SpellResult.FAIL;
        }
        return this.actions.perform(context);
    }

    @Override
    public void load(Mage mage, ConfigurationSection data) {
        if (this.actions != null) {
            this.actions.loadData(mage, data);
        }
    }

    @Override
    public void save(Mage mage, ConfigurationSection data) {
        if (this.actions != null) {
            this.actions.saveData(mage, data);
        }
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public boolean usesBrush() {
        return this.usesBrush;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        if (this.actions != null) {
            this.actions.getParameterNames(parameters);
        }
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (this.actions != null) {
            this.actions.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public String transformMessage(String message) {
        if (this.actions == null) {
            return message;
        }
        return this.actions.transformMessage(message);
    }

    public com.elmakers.mine.bukkit.api.action.CastContext createContext(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return new CastContext(context);
    }

    public com.elmakers.mine.bukkit.api.action.CastContext createContext(com.elmakers.mine.bukkit.api.action.CastContext context, Entity sourceEntity, Location sourceLocation) {
        return new CastContext(context, sourceEntity, sourceLocation);
    }

    public com.elmakers.mine.bukkit.api.action.CastContext createContext(com.elmakers.mine.bukkit.api.action.CastContext context, Entity sourceEntity, Location sourceLocation, Entity targetEntity, Location targetLocation) {
        CastContext newContext = new CastContext(context, sourceEntity, sourceLocation);
        newContext.setTargetEntity(targetEntity);
        newContext.setTargetLocation(targetLocation);
        return newContext;
    }
}

