/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import me.NoChance.PvPManager.PvPManager;
import me.NoChance.PvPManager.PvPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PvPManagerManager {
    private boolean enabled = false;
    private PvPManager manager = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.manager != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin pvpPlugin = plugin.getServer().getPluginManager().getPlugin("PvPManager");
                if (pvpPlugin instanceof PvPManager) {
                    this.manager = (PvPManager)pvpPlugin;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.manager != null) {
                plugin.getLogger().info("PvPManager found, will respect PVP settings");
            }
        } else {
            this.manager = null;
        }
    }

    public boolean isPVPAllowed(Player player) {
        if (!this.enabled || this.manager == null || player == null) {
            return true;
        }
        PvPlayer pvpPlayer = this.manager.getPlayerHandler().get(player);
        return pvpPlayer != null && pvpPlayer.hasPvPEnabled();
    }
}

