/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class MagicRecipe {
    private String outputKey;
    private Set<Material> ingredients = new HashSet<Material>();
    private Material outputType;
    private Material substitue;
    private boolean disableDefaultRecipe;
    private Recipe recipe;
    private final MagicController controller;

    public MagicRecipe(MagicController controller) {
        this.controller = controller;
    }

    public boolean load(ConfigurationSection configuration) {
        Wand wand;
        this.outputKey = configuration.getString("output");
        this.substitue = ConfigurationUtils.getMaterial(configuration, "substitue", null);
        this.disableDefaultRecipe = configuration.getBoolean("disable_default", false);
        Wand wand2 = wand = this.outputKey != null && !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey) : null;
        if (wand != null) {
            ItemStack wandItem = wand.getItem();
            this.outputType = wandItem.getType();
            ShapedRecipe shaped = new ShapedRecipe(wandItem);
            ArrayList<String> rows = new ArrayList<String>();
            for (int i = 1; i <= 3; ++i) {
                String recipeRow = configuration.getString("row_" + i, "");
                if (recipeRow.length() <= 0) continue;
                rows.add(recipeRow);
            }
            if (rows.size() > 0) {
                shaped = shaped.shape(rows.toArray(new String[0]));
                ConfigurationSection materials = configuration.getConfigurationSection("materials");
                Set keys = materials.getKeys(false);
                for (String key : keys) {
                    MaterialAndData mat = new MaterialAndData(materials.getString(key));
                    this.ingredients.add(mat.getMaterial());
                    shaped.setIngredient(key.charAt(0), mat.getMaterial());
                }
                this.recipe = shaped;
            }
        }
        if (this.outputType == null) {
            this.outputType = ConfigurationUtils.getMaterial(configuration, "input", null);
        }
        return this.outputType != null;
    }

    public void register(Plugin plugin) {
        if (this.disableDefaultRecipe) {
            Iterator it = plugin.getServer().recipeIterator();
            while (it.hasNext()) {
                Recipe defaultRecipe = (Recipe)it.next();
                if (defaultRecipe == null || defaultRecipe.getResult().getType() != this.outputType) continue;
                plugin.getLogger().info("Disabled default crafting recipe for " + this.outputType);
                it.remove();
            }
        }
        if (this.recipe != null) {
            plugin.getLogger().info("Adding crafting recipe for " + this.outputKey);
            plugin.getServer().addRecipe(this.recipe);
        }
    }

    public Material getOutputType() {
        return this.outputType;
    }

    public Set<Material> getIngredients() {
        return this.ingredients;
    }

    public Material getSubstitute() {
        return this.substitue;
    }

    public ItemStack craft() {
        if (this.outputKey == null) {
            return null;
        }
        ItemStack item = this.controller.createWand(this.outputKey).getItem();
        return item;
    }
}

