/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpellShopAction
extends BaseSpellAction
implements GUIAction {
    private String requiredPath = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;
    private boolean showRequired = false;
    private boolean autoUpgrade = false;
    private boolean showFree = false;
    private boolean useXP = false;
    private CastContext context;
    private com.elmakers.mine.bukkit.api.wand.Wand wand;

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (this.context != null && this.wand != null && Wand.isSpell(item)) {
            Mage mage = this.context.getMage();
            String spellKey = Wand.getSpell(item);
            SpellTemplate template = this.context.getController().getSpellTemplate(spellKey);
            boolean isXP = this.useXP || !VaultController.hasEconomy();
            double worth = template.getWorth();
            boolean hasCosts = false;
            if (worth > 0.0) {
                hasCosts = isXP ? mage.getExperience() > (int)worth : VaultController.getInstance().has(mage.getPlayer(), worth);
            }
            if (!hasCosts) {
                String costString = isXP ? this.context.getMessage("insufficient_xp") : this.context.getMessage("insufficient_money");
                String costs = isXP ? costString.replace("$cost", Integer.toString((int)worth)) : costString.replace("$cost", VaultController.getInstance().format(worth));
                this.context.sendMessage(costs);
            } else {
                String costString = isXP ? this.context.getMessage("deducted_xp") : this.context.getMessage("deducted_money");
                String costs = isXP ? costString.replace("$cost", Integer.toString((int)worth)) : costString.replace("$cost", VaultController.getInstance().format(worth));
                costs = costs.replace("$spell", template.getName());
                this.context.sendMessage(costs);
                if (isXP) {
                    mage.removeExperience((int)worth);
                } else {
                    VaultController.getInstance().withdrawPlayer(mage.getPlayer(), worth);
                }
                this.wand.addSpell(spellKey);
            }
            mage.deactivateGUI();
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requiredPath = parameters.getString("path", null);
        this.exactPath = parameters.getString("path_exact", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.showRequired = parameters.getBoolean("show_required", false);
        this.showFree = parameters.getBoolean("show_free", false);
        this.autoUpgrade = parameters.getBoolean("auto_upgrade", false);
        this.useXP = parameters.getBoolean("use_xp", false);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        this.wand = mage.getActiveWand();
        this.context = context;
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.wand == null) {
            context.sendMessage("no_wand");
            return SpellResult.FAIL;
        }
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.wand.getPath();
        if (path == null) {
            context.sendMessage(context.getMessage("no_upgrade").replace("$wand", this.wand.getName()));
            return SpellResult.FAIL;
        }
        if (this.requiredPath != null || this.exactPath != null) {
            if (this.requiredPath != null && !path.hasPath(this.requiredPath) || this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath requiresPath = WandUpgradePath.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.sendMessage(context.getMessage("no_path").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath pathUpgrade = path.getUpgrade();
                if (pathUpgrade == null) {
                    context.sendMessage(context.getMessage("no_upgrade").replace("$wand", this.wand.getName()));
                    return SpellResult.FAIL;
                }
                if (path.canEnchant(this.wand)) {
                    context.sendMessage(context.getMessage("no_path_end").replace("$path", pathUpgrade.getName()));
                    return SpellResult.FAIL;
                }
            }
        }
        ArrayList<ItemStack> spellItems = new ArrayList<ItemStack>();
        ArrayList<String> availableSpells = new ArrayList<String>(path.getSpells());
        if (this.showRequired) {
            availableSpells.addAll(path.getRequiredSpells());
        }
        Collections.sort(availableSpells);
        MagicAPI api = MagicPlugin.getAPI();
        boolean isXP = this.useXP || !VaultController.hasEconomy();
        String costString = isXP ? context.getMessage("cost_xp_lore") : context.getMessage("cost_lore");
        for (String spellKey : availableSpells) {
            SpellTemplate spell;
            double worth;
            if (this.wand.hasSpell(spellKey) || (worth = (spell = api.getSpellTemplate(spellKey)).getWorth()) <= 0.0 && !this.showFree) continue;
            ItemStack spellItem = api.createSpellItem(spellKey);
            ItemMeta meta = spellItem.getItemMeta();
            List lore = meta.getLore();
            String costs = isXP ? costString.replace("$cost", Integer.toString((int)worth)) : costString.replace("$cost", VaultController.getInstance().format(worth));
            lore.add(ChatColor.GOLD + costs);
            meta.setLore(lore);
            spellItem.setItemMeta(meta);
            spellItems.add(spellItem);
        }
        if (spellItems.size() == 0) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath nextPath = path.getUpgrade();
            if (nextPath != null && this.autoUpgrade) {
                path.upgrade(this.wand, mage);
                return SpellResult.CAST;
            }
            context.sendMessage("no_spells");
            return SpellResult.FAIL;
        }
        String inventoryTitle = context.getMessage("title", "Spell Shop");
        int invSize = (spellItems.size() + 9) / 9 * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (ItemStack item : spellItems) {
            displayInventory.addItem(new ItemStack[]{item});
        }
        mage.activateGUI(this);
        mage.getPlayer().openInventory(displayInventory);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("show_free");
        parameters.add("show_required");
        parameters.add("auto_upgrade");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        } else if (parameterKey.equals("show_free") || parameterKey.equals("show_required") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }
}

