/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class CoverAction
extends CompoundAction {
    private static final int DEFAULT_RADIUS = 2;
    private int radius;
    private float centerProbability;
    private float outerProbability;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radius = parameters.getInt("radius", 2);
        this.centerProbability = (float)parameters.getDouble("probability", 1.0);
        this.outerProbability = (float)parameters.getDouble("probability", 1.0);
        this.centerProbability = (float)parameters.getDouble("center_probability", (double)this.centerProbability);
        this.outerProbability = (float)parameters.getDouble("outer_probability", (double)this.outerProbability);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        Mage mage = context.getMage();
        int radius = (int)(mage.getRadiusMultiplier() * (float)this.radius);
        block = context.findSpaceAbove(block);
        CastContext actionContext = this.createContext(context);
        if (radius < 1) {
            if (this.centerProbability >= 1.0f || context.getRandom().nextDouble() <= (double)this.centerProbability) {
                actionContext.setTargetLocation(context.findBlockUnder(block).getLocation());
            }
            return this.performActions(actionContext);
        }
        SpellResult result = SpellResult.NO_ACTION;
        int y = block.getY();
        for (int dx = -radius; dx < radius; ++dx) {
            for (int dz = -radius; dz < radius; ++dz) {
                if (!this.isInCircle(dx, dz, radius)) continue;
                int x = block.getX() + dx;
                int z = block.getZ() + dz;
                Block targetBlock = context.getWorld().getBlockAt(x, y, z);
                targetBlock = context.findBlockUnder(targetBlock);
                Block coveringBlock = targetBlock.getRelative(BlockFace.UP);
                if (context.isTransparent(targetBlock.getType()) || !context.isTransparent(coveringBlock.getType())) continue;
                float probability = this.centerProbability;
                if (this.centerProbability != this.outerProbability) {
                    float weight = Math.abs((float)dx + (float)dz) / ((float)radius * 2.0f);
                    probability = RandomUtils.lerp(Float.valueOf(this.centerProbability), Float.valueOf(this.outerProbability), weight).floatValue();
                }
                if (!(probability >= 1.0f) && !(context.getRandom().nextDouble() <= (double)probability)) continue;
                actionContext.setTargetLocation(targetBlock.getLocation());
                result = result.min(this.actions.perform(actionContext));
            }
        }
        return result;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    protected boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("radius");
        parameters.add("probability");
        parameters.add("center_probability");
        parameters.add("outer_probability");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("radius")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("probability") || parameterKey.equals("center_probability") || parameterKey.equals("outer_probability")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        }
    }
}

