/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ChangeContextAction
extends CompoundAction {
    private Vector sourceOffset;
    private Vector targetOffset;
    private boolean targetSelf;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetSelf = parameters.getBoolean("target_caster");
        this.targetOffset = ConfigurationUtils.getVector(parameters, "target_offset");
        this.sourceOffset = ConfigurationUtils.getVector(parameters, "source_offset");
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity sourceEntity = context.getEntity();
        Location sourceLocation = context.getEyeLocation();
        Entity targetEntity = context.getTargetEntity();
        Location targetLocation = context.getTargetLocation();
        if (sourceLocation == null) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (this.targetSelf) {
            targetEntity = sourceEntity;
        }
        if (this.sourceOffset != null) {
            sourceLocation = sourceLocation.clone().add(this.sourceOffset);
        }
        if (this.targetOffset != null) {
            targetLocation = targetLocation.clone().add(this.targetOffset);
        }
        CastContext newContext = this.createContext(context, sourceEntity, sourceLocation, targetEntity, targetLocation);
        return this.performActions(newContext);
    }
}

