/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AddSpellAction
extends BaseSpellAction {
    private String spellKey;
    private String requiredPath = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.spellKey = parameters.getString("spell");
        this.requiredPath = parameters.getString("path", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.exactPath = parameters.getString("path_exact", null);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (wand == null || this.spellKey == null || this.spellKey.isEmpty()) {
            context.sendMessage("no_wand");
            return SpellResult.FAIL;
        }
        if (wand.hasSpell(this.spellKey)) {
            return SpellResult.NO_TARGET;
        }
        if (this.requiredPath != null || this.exactPath != null) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = wand.getPath();
            if (path == null) {
                context.sendMessage(context.getMessage("no_upgrade").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath) || this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath requiresPath = WandUpgradePath.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.sendMessage(context.getMessage("no_path").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath pathUpgrade = path.getUpgrade();
                if (pathUpgrade == null) {
                    context.sendMessage(context.getMessage("no_upgrade").replace("$wand", wand.getName()));
                    return SpellResult.FAIL;
                }
                if (path.canEnchant(wand)) {
                    context.sendMessage(context.getMessage("no_path_end").replace("$path", pathUpgrade.getName()));
                    return SpellResult.FAIL;
                }
            }
        }
        SpellTemplate currentSpell = wand.getBaseSpell(this.spellKey);
        if (!wand.addSpell(this.spellKey)) {
            return SpellResult.NO_TARGET;
        }
        Messages messages = context.getController().getMessages();
        SpellTemplate spell = context.getController().getSpellTemplate(this.spellKey);
        if (spell != null) {
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spell.getName();
                }
                context.sendMessage(messages.get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$wand", wand.getName()).replace("$level", levelDescription));
                context.sendMessage(spell.getUpgradeDescription().replace("$name", currentSpell.getName()));
            } else {
                context.sendMessage(messages.get("wand.spell_added").replace("$name", spell.getName()).replace("$wand", wand.getName()));
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("spell");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("spell")) {
            Collection<SpellTemplate> spellList = MagicPlugin.getAPI().getSpellTemplates();
            for (SpellTemplate spell : spellList) {
                examples.add(spell.getKey());
            }
        } else if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        }
    }
}

