/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CastContext
implements com.elmakers.mine.bukkit.api.action.CastContext {
    protected static Random random;
    private final Location location;
    private final Entity entity;
    private Location targetLocation;
    private Entity targetEntity;
    private UndoList undoList;
    private String targetName = null;
    private Collection<Entity> targetedEntities = Collections.newSetFromMap(new WeakHashMap());
    private Set<UUID> targetMessagesSent = new HashSet<UUID>();
    private Spell spell;
    private BaseSpell baseSpell;
    private BlockSpell blockSpell;
    private MageSpell mageSpell;
    private BrushSpell brushSpell;
    private TargetingSpell targetingSpell;
    private UndoableSpell undoSpell;
    private MaterialBrush brush;

    public CastContext(Spell spell) {
        this.setSpell(spell);
        this.location = null;
        this.entity = null;
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy) {
        this(copy, copy.getEntity(), copy.getLocation());
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity) {
        this(copy, sourceEntity, null);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Location sourceLocation) {
        this(copy, null, sourceLocation);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity, Location sourceLocation) {
        this.location = sourceLocation;
        this.entity = sourceEntity;
        this.setSpell(copy.getSpell());
        this.targetEntity = copy.getTargetEntity();
        this.targetLocation = copy.getTargetLocation();
        this.targetedEntities = copy.getTargetEntities();
        this.undoList = copy.getUndoList();
        this.targetName = copy.getTargetName();
        this.brush = copy.getBrush();
        if (copy instanceof CastContext) {
            this.targetMessagesSent = ((CastContext)copy).targetMessagesSent;
        }
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        if (spell instanceof BaseSpell) {
            this.baseSpell = (BaseSpell)spell;
        }
        if (spell instanceof MageSpell) {
            this.mageSpell = (MageSpell)spell;
        }
        if (spell instanceof UndoableSpell) {
            this.undoSpell = (UndoableSpell)spell;
            this.undoList = this.undoSpell.getUndoList();
        }
        if (spell instanceof TargetingSpell) {
            this.targetingSpell = (TargetingSpell)spell;
        }
        if (spell instanceof BlockSpell) {
            this.blockSpell = (BlockSpell)spell;
        }
        if (spell instanceof BrushSpell) {
            this.brushSpell = (BrushSpell)spell;
        }
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.entity != null) {
            if (this.entity instanceof LivingEntity) {
                return ((LivingEntity)this.entity).getEyeLocation();
            }
            return this.entity.getLocation();
        }
        return this.spell.getEyeLocation();
    }

    @Override
    public Entity getEntity() {
        if (this.entity != null) {
            return this.entity;
        }
        return this.spell.getEntity();
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.entity != null) {
            return this.entity.getLocation();
        }
        return this.spell.getLocation();
    }

    @Override
    public Location getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    public Block getTargetBlock() {
        return this.targetLocation == null ? null : this.targetLocation.getBlock();
    }

    @Override
    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public Vector getDirection() {
        return this.getLocation().getDirection();
    }

    @Override
    public World getWorld() {
        Location location = this.getLocation();
        return location == null ? null : location.getWorld();
    }

    @Override
    public void setTargetEntity(Entity targetEntity) {
        this.targetEntity = targetEntity;
        this.addTargetEntity(targetEntity);
    }

    @Override
    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getMage() {
        return this.mageSpell == null ? null : this.mageSpell.getMage();
    }

    @Override
    public Collection<EffectPlayer> getEffects(String key) {
        return this.spell.getEffects(key);
    }

    @Override
    public MageController getController() {
        Mage mage = this.getMage();
        return mage == null ? null : mage.getController();
    }

    @Override
    public void registerForUndo(Runnable runnable) {
        if (this.undoList != null) {
            this.undoList.add(runnable);
        }
    }

    @Override
    public void registerModified(Entity entity) {
        if (this.undoList != null) {
            this.undoList.modify(entity);
        }
    }

    @Override
    public void registerForUndo(Entity entity) {
        if (this.undoList != null) {
            this.undoList.add(entity);
        }
    }

    @Override
    public void registerForUndo(Block block) {
        if (this.undoList != null) {
            this.undoList.add(block);
        }
    }

    @Override
    public void registerForUndo(Block block, boolean addNeighbors) {
        if (this.undoList != null) {
            this.undoList.add(block, addNeighbors);
        }
    }

    @Override
    public void updateBlock(Block block) {
        MageController controller = this.getController();
        if (controller != null) {
            controller.updateBlock(block);
        }
    }

    @Override
    public void registerVelocity(Entity entity) {
        if (this.undoList != null) {
            this.undoList.modifyVelocity(entity);
        }
    }

    @Override
    public void registerMoved(Entity entity) {
        if (this.undoList != null) {
            this.undoList.move(entity);
        }
    }

    @Override
    public void registerPotionEffects(Entity entity) {
        if (this.undoList != null) {
            this.undoList.addPotionEffects(entity);
        }
    }

    @Override
    public Block getPreviousBlock() {
        return this.targetingSpell != null ? this.targetingSpell.getPreviousBlock() : null;
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.blockSpell != null ? this.blockSpell.isIndestructible(block) : true;
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.blockSpell != null ? this.blockSpell.hasBuildPermission(block) : false;
    }

    @Override
    public void playEffects(String key) {
        if (this.baseSpell != null) {
            this.baseSpell.playEffects(key, this);
        }
    }

    @Override
    public String getMessage(String key) {
        return this.getMessage(key, key);
    }

    @Override
    public String getMessage(String key, String def) {
        return this.baseSpell != null ? this.baseSpell.getMessage(key, def) : def;
    }

    @Override
    public Location tryFindPlaceToStand(Location location) {
        return this.baseSpell != null ? this.baseSpell.tryFindPlaceToStand(location) : location;
    }

    @Override
    public void castMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(this.getMessage(message));
        }
    }

    @Override
    public void sendMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(this.getMessage(message));
        }
    }

    @Override
    public void setTargetedLocation(Location location) {
        if (this.targetingSpell != null) {
            this.targetingSpell.setTarget(location);
        }
    }

    @Override
    public Block findBlockUnder(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findBlockUnder(block);
        }
        return block;
    }

    @Override
    public Block findSpaceAbove(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findSpaceAbove(block);
        }
        return block;
    }

    @Override
    public boolean isTransparent(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTransparent(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isDestructible(Block block) {
        if (this.blockSpell != null) {
            return this.blockSpell.isDestructible(block);
        }
        return true;
    }

    @Override
    public boolean isTargetable(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTargetable(material);
        }
        return true;
    }

    @Override
    public boolean canTarget(Entity entity) {
        return this.targetingSpell != null ? true : this.targetingSpell.canTarget(entity);
    }

    @Override
    public MaterialBrush getBrush() {
        if (this.brush != null) {
            return this.brush;
        }
        return this.brushSpell == null ? null : this.brushSpell.getBrush();
    }

    @Override
    public void setBrush(MaterialBrush brush) {
        this.brush = brush;
    }

    @Override
    public void addTargetEntity(Entity entity) {
        if (entity != null) {
            this.targetedEntities.add(entity);
        }
    }

    @Override
    public Collection<Entity> getTargetEntities() {
        return this.targetedEntities;
    }

    @Override
    public void messageTargets(String messageKey) {
        Mage mage = this.getMage();
        MageController controller = this.getController();
        LivingEntity sourceEntity = mage == null ? null : mage.getLivingEntity();
        String playerMessage = this.getMessage(messageKey);
        if (!mage.isStealth() && playerMessage.length() > 0) {
            Collection<Entity> targets = this.getTargetEntities();
            for (Entity target : targets) {
                UUID targetUUID = target.getUniqueId();
                if (!(target instanceof Player) || target == sourceEntity || this.targetMessagesSent.contains(targetUUID)) continue;
                this.targetMessagesSent.add(targetUUID);
                playerMessage = playerMessage.replace("$spell", this.spell.getName());
                Mage targetMage = controller.getMage(target);
                targetMage.sendMessage(playerMessage);
            }
        }
    }

    @Override
    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock.getType())) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    @Override
    public Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    @Override
    public UndoList getUndoList() {
        return this.undoList;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String name) {
        this.targetName = name;
    }

    @Override
    public Logger getLogger() {
        return this.getController().getLogger();
    }
}

