/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class ActionSpell
extends BrushSpell {
    private Map<String, ActionHandler> actions = new HashMap<String, ActionHandler>();
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    private ActionHandler currentHandler = null;

    @Override
    protected void processResult(SpellResult result, ConfigurationSection castParameters) {
        ActionHandler handler;
        if (!result.isSuccess() && (handler = this.actions.get(result.name().toLowerCase())) != null) {
            handler.perform(this.getCurrentCast(), castParameters);
        }
        super.processResult(result, castParameters);
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        if (this.undoable) {
            this.registerForUndo();
        }
        SpellResult result = SpellResult.CAST;
        this.currentHandler = this.actions.get("cast");
        ActionHandler downHandler = this.actions.get("alternate_down");
        ActionHandler upHandler = this.actions.get("alternate_up");
        ActionHandler sneakHandler = this.actions.get("alternate_sneak");
        if (downHandler != null && this.isLookingDown()) {
            result = SpellResult.ALTERNATE_DOWN;
            this.currentHandler = downHandler;
        } else if (upHandler != null && this.isLookingUp()) {
            result = SpellResult.ALTERNATE_UP;
            this.currentHandler = upHandler;
        } else if (sneakHandler != null && this.mage.isSneaking()) {
            result = SpellResult.ALTERNATE_SNEAK;
            this.currentHandler = sneakHandler;
        }
        if (this.currentHandler != null) {
            result = result.max(this.currentHandler.perform(this, parameters));
        }
        return result;
    }

    @Override
    public void load(ConfigurationSection data) {
        for (ActionHandler handler : this.actions.values()) {
            handler.loadData(this.getMage(), data);
        }
    }

    @Override
    public void save(ConfigurationSection data) {
        for (ActionHandler handler : this.actions.values()) {
            handler.saveData(this.getMage(), data);
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        this.usesBrush = false;
        this.undoable = false;
        this.requiresBuildPermission = false;
        this.castOnNoTarget = true;
        if (template.contains("actions")) {
            ConfigurationSection parameters = template.getConfigurationSection("parameters");
            ConfigurationSection actionsNode = template.getConfigurationSection("actions");
            Set actionKeys = actionsNode.getKeys(false);
            for (String actionKey : actionKeys) {
                ActionHandler handler = new ActionHandler();
                handler.load(actionsNode, actionKey);
                handler.initialize(parameters);
                this.usesBrush = this.usesBrush || handler.usesBrush();
                this.undoable = this.undoable || handler.isUndoable();
                this.requiresBuildPermission = this.requiresBuildPermission || handler.requiresBuildPermission();
                this.actions.put(actionKey, handler);
            }
        }
        this.undoable = template.getBoolean("undoable", this.undoable);
        super.loadTemplate(template);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterNames(parameters);
        }
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        if (this.currentHandler != null) {
            message = this.currentHandler.transformMessage(message);
        }
        return message;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }
}

