/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.block.BlockList;
import com.elmakers.mine.bukkit.api.block.BoundingBox;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.event.SaveEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.Automaton;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.WorldEditSchematic;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.dynmap.DynmapController;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.elementals.ElementalsController;
import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.PhysicsHandler;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.listener.AnvilController;
import com.elmakers.mine.bukkit.magic.listener.CraftingController;
import com.elmakers.mine.bukkit.magic.listener.EnchantingController;
import com.elmakers.mine.bukkit.maps.MapController;
import com.elmakers.mine.bukkit.metrics.CategoryCastPlotter;
import com.elmakers.mine.bukkit.metrics.DeltaPlotter;
import com.elmakers.mine.bukkit.metrics.SpellCastPlotter;
import com.elmakers.mine.bukkit.plugins.magic.mcstats.Metrics;
import com.elmakers.mine.bukkit.protection.FactionsManager;
import com.elmakers.mine.bukkit.protection.LocketteManager;
import com.elmakers.mine.bukkit.protection.MultiverseManager;
import com.elmakers.mine.bukkit.protection.PreciousStonesManager;
import com.elmakers.mine.bukkit.protection.PvPManagerManager;
import com.elmakers.mine.bukkit.protection.TownyManager;
import com.elmakers.mine.bukkit.protection.WorldGuardManager;
import com.elmakers.mine.bukkit.spell.SpellCategory;
import com.elmakers.mine.bukkit.traders.TradersController;
import com.elmakers.mine.bukkit.utilities.CompleteDragTask;
import com.elmakers.mine.bukkit.utilities.DataStore;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.TimedRunnable;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.warp.WarpController;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;

public class MagicController
implements Listener,
MageController {
    private static final int MAX_Y = 255;
    private static final String BUILTIN_SPELL_CLASSPATH = "com.elmakers.mine.bukkit.spell.builtin";
    private static int VOLUME_UPDATE_THRESHOLD = 32;
    private static int MAGE_FORGET_THRESHOLD = 30000;
    private final String SPELLS_FILE = "spells";
    private final String CONFIG_FILE = "config";
    private final String WANDS_FILE = "wands";
    private final String ENCHANTING_FILE = "enchanting";
    private final String CRAFTING_FILE = "crafting";
    private final String MESSAGES_FILE = "messages";
    private final String MATERIALS_FILE = "materials";
    private final String LOST_WANDS_FILE = "lostwands";
    private final String SPELLS_DATA_FILE = "spells";
    private final String AUTOMATA_FILE = "automata";
    private final String URL_MAPS_FILE = "imagemaps";
    private boolean disableDefaultSpells = false;
    private boolean loadDefaultSpells = true;
    private boolean loadDefaultWands = true;
    private boolean loadDefaultEnchanting = true;
    private boolean loadDefaultCrafting = true;
    private MaterialAndData redstoneReplacement = new MaterialAndData(Material.OBSIDIAN);
    private Set<Material> buildingMaterials = new HashSet<Material>();
    private Set<Material> indestructibleMaterials = new HashSet<Material>();
    private Set<Material> restrictedMaterials = new HashSet<Material>();
    private Set<Material> destructibleMaterials = new HashSet<Material>();
    private Set<Material> interactibleMaterials = new HashSet<Material>();
    private Set<Material> wearableMaterials = new HashSet<Material>();
    private Map<String, Set<Material>> materialSets = new HashMap<String, Set<Material>>();
    private int undoTimeWindow = 6000;
    private int undoBlockBorderSize = 2;
    private int maxTNTPerChunk = 0;
    private int undoQueueDepth = 256;
    private int pendingQueueDepth = 16;
    private int undoMaxPersistSize = 0;
    private boolean undoOnWorldSave = false;
    private boolean backupInventory = false;
    private boolean commitOnQuit = false;
    private boolean saveNonPlayerMages = false;
    private String defaultWandPath = "";
    private WandMode defaultWandMode = WandMode.INVENTORY;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private boolean indestructibleWands = true;
    private boolean keepWandsOnDeath = true;
    private String welcomeWand = "";
    private int messageThrottle = 0;
    private int clickCooldown = 150;
    private boolean bindingEnabled = false;
    private boolean spellDroppingEnabled = false;
    private boolean keepingEnabled = false;
    private boolean fillingEnabled = false;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private boolean dynmapOnlyPlayerSpells = false;
    private boolean dynmapShowSpells = true;
    private boolean createWorldsEnabled = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 2.5f;
    private float maxRadiusPowerMultiplierMax = 4.0f;
    private float maxRangePowerMultiplier = 3.0f;
    private float maxRangePowerMultiplierMax = 5.0f;
    private float maxPower = 100.0f;
    private float maxHaste = 5.0f;
    private float maxHealthRegeneration = 1.0f;
    private float maxHungerRegeneration = 1.0f;
    private float maxDamageReduction = 0.2f;
    private float maxDamageReductionExplosions = 0.2f;
    private float maxDamageReductionFalling = 0.2f;
    private float maxDamageReductionFire = 0.2f;
    private float maxDamageReductionPhysical = 0.2f;
    private float maxDamageReductionProjectiles = 0.2f;
    private float maxCostReduction = 0.5f;
    private float maxCooldownReduction = 0.5f;
    private int maxMana = 1000;
    private int maxManaRegeneration = 100;
    private float castCommandCostReduction = 1.0f;
    private float castCommandCooldownReduction = 1.0f;
    private float castCommandPowerMultiplier = 0.0f;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private int maxBlockUpdates = 100;
    private int ageDroppedItems = 0;
    private int autoUndo = 0;
    private int autoSaveTaskId = 0;
    private double wandAbuseDamage = 0.0;
    private boolean preventMeleeDamage = false;
    private WarpController warpController = null;
    private final Map<String, SpellTemplate> spells = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellTemplate> spellAliases = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellCategory> categories = new HashMap<String, SpellCategory>();
    private final Map<String, com.elmakers.mine.bukkit.api.magic.Mage> mages = new HashMap<String, com.elmakers.mine.bukkit.api.magic.Mage>();
    private final Map<String, Long> forgetMages = new HashMap<String, Long>();
    private final Set<com.elmakers.mine.bukkit.api.magic.Mage> pendingConstruction = new HashSet<com.elmakers.mine.bukkit.api.magic.Mage>();
    private final Set<com.elmakers.mine.bukkit.api.magic.Mage> pendingConstructionRemoval = new HashSet<com.elmakers.mine.bukkit.api.magic.Mage>();
    private final PriorityQueue<com.elmakers.mine.bukkit.api.block.UndoList> scheduledUndo = new PriorityQueue();
    private final Set<String> pendingUndo = new HashSet<String>();
    private final Map<String, WeakReference<WorldEditSchematic>> schematics = new HashMap<String, WeakReference<WorldEditSchematic>>();
    private MagicPlugin plugin = null;
    private final File configFolder;
    private final File dataFolder;
    private final File schematicFolder;
    private final File defaultsFolder;
    private final File playerDataFolder;
    private boolean enableItemHacks = true;
    private boolean enableCreativeModeEjecting = true;
    private int toggleCooldown = 1000;
    private int toggleMessageRange = 1024;
    private int mageUpdateFrequency = 20;
    private int blockUpdateFrequency = 1;
    private int undoFrequency = 10;
    private boolean showCastHoloText = false;
    private boolean showActivateHoloText = false;
    private int castHoloTextRange = 0;
    private int activateHoloTextRange = 0;
    private boolean urlIconsEnabled = true;
    private boolean bypassBuildPermissions = false;
    private boolean bypassPvpPermissions = false;
    private boolean allPvpRestricted = false;
    private String extraSchematicFilePath = null;
    private Class<?> cuboidClipboardClass = null;
    private Mailer mailer = null;
    private Material defaultMaterial = Material.DIRT;
    private PhysicsHandler physicsHandler = null;
    private Map<String, Map<Long, Automaton>> automata = new HashMap<String, Map<Long, Automaton>>();
    private Map<String, LostWand> lostWands = new HashMap<String, LostWand>();
    private Map<String, Set<String>> lostWandChunks = new HashMap<String, Set<String>>();
    private int metricsLevel = 5;
    private Metrics metrics = null;
    private boolean hasDynmap = false;
    private boolean hasEssentials = false;
    private boolean hasCommandBook = false;
    private boolean hasWorldEdit = false;
    private String exampleDefaults = null;
    private Collection<String> addExamples = null;
    private boolean initialized = false;
    private final Object saveLock = new Object();
    private CraftingController crafting = null;
    private EnchantingController enchanting = null;
    private AnvilController anvil = null;
    private Messages messages = null;
    private MapController maps = null;
    private TradersController tradersController = null;
    private DynmapController dynmap = null;
    private ElementalsController elementals = null;
    private CitizensController citizens = null;
    private boolean citizensEnabled = true;
    private FactionsManager factionsManager = new FactionsManager();
    private LocketteManager locketteManager = new LocketteManager();
    private WorldGuardManager worldGuardManager = new WorldGuardManager();
    private PvPManagerManager pvpManager = new PvPManagerManager();
    private MultiverseManager multiverseManager = new MultiverseManager();
    private PreciousStonesManager preciousStonesManager = new PreciousStonesManager();
    private TownyManager townyManager = new TownyManager();

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        this.configFolder.mkdirs();
        this.dataFolder = new File(this.configFolder, "data");
        this.dataFolder.mkdirs();
        this.schematicFolder = new File(this.configFolder, "schematics");
        this.schematicFolder.mkdirs();
        this.playerDataFolder = new File(this.dataFolder, "players");
        this.playerDataFolder.mkdirs();
        this.defaultsFolder = new File(this.configFolder, "defaults");
        this.defaultsFolder.mkdirs();
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, String mageName) {
        return this.getMage(mageId, mageName, null, null);
    }

    public com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, CommandSender commandSender, Entity entity) {
        return this.getMage(mageId, null, commandSender, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, String mageName, CommandSender commandSender, Entity entity) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = null;
        if (!this.mages.containsKey(mageId)) {
            File playerFile;
            final Mage mage = new Mage(mageId, this);
            this.mages.put(mageId, mage);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (commandSender instanceof Player) {
                mage.setPlayer((Player)commandSender);
            }
            if ((playerFile = new File(this.playerDataFolder, mageId + ".dat")).exists()) {
                if (commandSender instanceof Player) {
                    mage.setLoading(true);
                    this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = MagicController.this.saveLock;
                            synchronized (object) {
                                MagicController.this.getLogger().info("Loading mage data from file " + playerFile.getName());
                                try {
                                    YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MagicController.this.plugin, new Runnable((Configuration)playerData){
                                        final /* synthetic */ Configuration val$playerData;
                                        {
                                            this.val$playerData = configuration;
                                        }

                                        @Override
                                        public void run() {
                                            mage.load((ConfigurationSection)this.val$playerData);
                                        }
                                    }, 1L);
                                }
                                catch (Exception ex) {
                                    MagicController.this.getLogger().warning("Failed to load mage data from file " + playerFile.getName());
                                    ex.printStackTrace();
                                }
                                mage.setLoading(false);
                            }
                        }
                    });
                    return mage;
                }
                this.getLogger().info("Loading mage data from file " + playerFile.getName() + " synchronously");
                Object object = this.saveLock;
                synchronized (object) {
                    try {
                        YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
                        mage.load((ConfigurationSection)playerData);
                    }
                    catch (Exception ex) {
                        this.getLogger().warning("Failed to load mage data from file " + playerFile.getName());
                        ex.printStackTrace();
                    }
                    return mage;
                }
            }
            mage.load(null);
            return mage;
        }
        apiMage = this.mages.get(mageId);
        if (!(apiMage instanceof Mage)) return apiMage;
        Mage mage = (Mage)apiMage;
        mage.setName(mageName);
        mage.setCommandSender(commandSender);
        mage.setEntity(entity);
        if (!(commandSender instanceof Player)) return apiMage;
        mage.setPlayer((Player)commandSender);
        return apiMage;
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Player player) {
        return this.getMage((Entity)player, (CommandSender)player);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity) {
        Player commandSender = entity instanceof Player ? (Player)entity : null;
        return this.getMage(entity, (CommandSender)commandSender);
    }

    protected com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity, CommandSender commandSender) {
        if (entity == null) {
            return this.getMage(commandSender);
        }
        String id = entity.getUniqueId().toString();
        if (this.isNPC(entity)) {
            id = "NPC-" + id;
        }
        return this.getMage(id, commandSender, entity);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(CommandSender commandSender) {
        String mageId = "COMMAND";
        if (commandSender instanceof ConsoleCommandSender) {
            mageId = "CONSOLE";
        } else {
            BlockCommandSender commandBlock;
            String commandName;
            if (commandSender instanceof Player) {
                return this.getMage((Player)commandSender);
            }
            if (commandSender instanceof BlockCommandSender && (commandName = (commandBlock = (BlockCommandSender)commandSender).getName()) != null && commandName.length() > 0) {
                mageId = "COMMAND-" + commandBlock.getName();
            }
        }
        return this.getMage(mageId, commandSender, null);
    }

    public void addSpell(Spell variant) {
        SpellTemplate conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell key: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
            String alias = variant.getAlias();
            if (alias != null && alias.length() > 0) {
                this.spellAliases.put(alias, variant);
            }
        }
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplierMax() {
        return this.maxRadiusPowerMultiplierMax;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public float getMaxRangePowerMultiplierMax() {
        return this.maxRangePowerMultiplierMax;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public float getMaxHaste() {
        return this.maxHaste;
    }

    public float getMaxHealthRegeneration() {
        return this.maxHealthRegeneration;
    }

    public float getMaxHungerRegeneration() {
        return this.maxHungerRegeneration;
    }

    public float getMaxDamageReduction() {
        return this.maxDamageReduction;
    }

    public float getMaxDamageReductionExplosions() {
        return this.maxDamageReductionExplosions;
    }

    public float getMaxDamageReductionFalling() {
        return this.maxDamageReductionFalling;
    }

    public float getMaxDamageReductionFire() {
        return this.maxDamageReductionFire;
    }

    public float getMaxDamageReductionPhysical() {
        return this.maxDamageReductionPhysical;
    }

    public float getMaxDamageReductionProjectiles() {
        return this.maxDamageReductionProjectiles;
    }

    public float getMaxCostReduction() {
        return this.maxCostReduction;
    }

    public float getMaxCooldownReduction() {
        return this.maxCooldownReduction;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public int getMaxManaRegeneration() {
        return this.maxManaRegeneration;
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public int getPendingQueueDepth() {
        return this.pendingQueueDepth;
    }

    @Override
    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    @Override
    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillingEnabled;
    }

    public boolean bindWands() {
        return this.bindingEnabled;
    }

    public boolean keepWands() {
        return this.keepingEnabled;
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.contains(block.getType());
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.contains(block.getType());
    }

    protected boolean isRestricted(Material material) {
        return this.restrictedMaterials.contains(material);
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        boolean allowed = true;
        if (this.bypassBuildPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_build")) {
            return true;
        }
        allowed = allowed && this.worldGuardManager.hasBuildPermission(player, block);
        allowed = allowed && this.factionsManager.hasBuildPermission(player, block);
        allowed = allowed && this.locketteManager.hasBuildPermission(player, block);
        allowed = allowed && this.preciousStonesManager.hasBuildPermission(player, block);
        allowed = allowed && this.townyManager.hasBuildPermission(player, block);
        return allowed;
    }

    public boolean schematicsEnabled() {
        return this.cuboidClipboardClass != null;
    }

    public void clearCache() {
        String[] schematicFiles;
        for (String schematicFilename : schematicFiles = this.schematicFolder.list()) {
            InputStream builtin;
            if (!schematicFilename.endsWith(".schematic") || (builtin = this.plugin.getResource("schematics/" + schematicFilename)) == null) continue;
            File schematicFile = new File(this.schematicFolder, schematicFilename);
            schematicFile.delete();
            this.plugin.getLogger().info("Deleted file " + schematicFile.getAbsolutePath());
        }
        this.schematics.clear();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).clearCache();
        }
        this.maps.clearCache();
    }

    @Override
    public WorldEditSchematic loadSchematic(String schematicName) {
        WorldEditSchematic cached;
        WeakReference<WorldEditSchematic> schematic;
        if (schematicName == null || schematicName.length() == 0 || !this.schematicsEnabled()) {
            return null;
        }
        if (this.schematics.containsKey(schematicName) && (schematic = this.schematics.get(schematicName)) != null && (cached = (WorldEditSchematic)schematic.get()) != null) {
            return cached;
        }
        String fileName = schematicName + ".schematic";
        File schematicFile = new File(this.schematicFolder, fileName);
        if (!schematicFile.exists()) {
            try {
                File extraSchematicFile = null;
                if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                    File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                    extraSchematicFile = new File(schematicFolder, schematicName + ".schematic");
                    this.getLogger().info("Checking for external schematic: " + extraSchematicFile.getAbsolutePath());
                }
                if (extraSchematicFile != null && extraSchematicFile.exists()) {
                    schematicFile = extraSchematicFile;
                    this.getLogger().info("Loading file: " + extraSchematicFile.getAbsolutePath());
                } else {
                    this.plugin.saveResource("schematics/" + fileName, true);
                    this.getLogger().info("Adding builtin schematic: schematics/" + fileName);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!schematicFile.exists()) {
            this.getLogger().warning("Could not load file: " + schematicFile.getAbsolutePath());
            return null;
        }
        try {
            Method loadSchematicMethod = this.cuboidClipboardClass.getMethod("loadSchematic", File.class);
            this.getLogger().info("Loading schematic file: " + schematicFile.getAbsolutePath());
            WorldEditSchematic schematic2 = new WorldEditSchematic(loadSchematicMethod.invoke(null, schematicFile));
            this.schematics.put(schematicName, new WeakReference<WorldEditSchematic>(schematic2));
            return schematic2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Collection<String> getBrushKeys() {
        Material[] materials;
        ArrayList<String> names = new ArrayList<String>();
        for (Material material : materials = Material.values()) {
            if (!material.isBlock()) continue;
            names.add(material.name().toLowerCase());
        }
        for (String string : MaterialBrush.SPECIAL_MATERIAL_KEYS) {
            names.add(string.toLowerCase());
        }
        Collection<String> collection = this.getSchematicNames();
        for (String schematic : collection) {
            names.add("schematic:" + schematic);
        }
        return names;
    }

    public Collection<String> getSchematicNames() {
        String schematicName;
        ArrayList<String> schematicNames = new ArrayList<String>();
        if (!MaterialBrush.SchematicsEnabled) {
            return schematicNames;
        }
        try {
            CodeSource codeSource = MagicTabExecutor.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL jar = codeSource.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.startsWith("schematics/") && name.endsWith(".schematic")) {
                        schematicName = name.replace(".schematic", "").replace("schematics/", "");
                        schematicNames.add(schematicName);
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                for (File schematicFile : schematicFolder.listFiles()) {
                    if (!schematicFile.getName().endsWith(".schematic")) continue;
                    schematicName = schematicFile.getName().replace(".schematic", "");
                    schematicNames.add(schematicName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schematicNames;
    }

    public void initialize() {
        Player[] players;
        block34: {
            this.warpController = new WarpController();
            this.crafting = new CraftingController(this);
            this.enchanting = new EnchantingController(this);
            this.anvil = new AnvilController(this);
            this.messages = new Messages();
            File urlMapFile = this.getDataFile("imagemaps");
            File imageCache = new File(this.dataFolder, "imagemapcache");
            imageCache.mkdirs();
            this.maps = new MapController((Plugin)this.plugin, urlMapFile, imageCache);
            if (EffectPlayer.initialize((Plugin)this.plugin)) {
                this.getLogger().info("EffectLib initialized");
            } else {
                this.getLogger().warning("Failed to initialize EffectLib");
            }
            try {
                this.cuboidClipboardClass = Class.forName("com.sk89q.worldedit.CuboidClipboard");
                Method loadSchematicMethod = this.cuboidClipboardClass.getMethod("loadSchematic", File.class);
                if (loadSchematicMethod != null) {
                    this.getLogger().info("WorldEdit found, schematic brushes enabled.");
                    MaterialBrush.SchematicsEnabled = true;
                    this.hasWorldEdit = true;
                } else {
                    this.cuboidClipboardClass = null;
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this.load();
            Plugin essentials = this.plugin.getServer().getPluginManager().getPlugin("Essentials");
            boolean bl = this.hasEssentials = essentials != null;
            if (this.hasEssentials) {
                if (this.warpController.setEssentials(essentials)) {
                    this.getLogger().info("Integrating with Essentials for Recall warps");
                }
                try {
                    this.mailer = new Mailer(essentials);
                }
                catch (Exception ex) {
                    this.getLogger().warning("Essentials found, but failed to hook up to Mailer");
                    this.mailer = null;
                }
            }
            if (this.essentialsSignsEnabled) {
                final MagicController me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Plugin essentials = me.plugin.getServer().getPluginManager().getPlugin("Essentials");
                            if (essentials != null) {
                                Class<?> essentialsClass = essentials.getClass();
                                Field itemDbField = essentialsClass.getDeclaredField("itemDb");
                                itemDbField.setAccessible(true);
                                Object oldEntry = itemDbField.get(essentials);
                                if (oldEntry == null) {
                                    MagicController.this.getLogger().info("Essentials integration failure");
                                    return;
                                }
                                if (oldEntry instanceof MagicItemDb) {
                                    MagicController.this.getLogger().info("Essentials integration already set up, skipping");
                                    return;
                                }
                                if (!oldEntry.getClass().getName().equals("com.earth2me.essentials.ItemDb")) {
                                    MagicController.this.getLogger().info("Essentials Item DB class unexepcted: " + oldEntry.getClass().getName() + ", skipping integration");
                                    return;
                                }
                                MagicItemDb newEntry = new MagicItemDb(me, essentials);
                                itemDbField.set(essentials, (Object)newEntry);
                                Field confListField = essentialsClass.getDeclaredField("confList");
                                confListField.setAccessible(true);
                                List confList = (List)confListField.get(essentials);
                                confList.remove(oldEntry);
                                confList.add(newEntry);
                                MagicController.this.getLogger().info("Essentials found, hooked up custom item handler");
                            }
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                }, 5L);
            }
            this.tradersController = null;
            try {
                Plugin tradersPlugin = this.plugin.getServer().getPluginManager().getPlugin("dtlTraders");
                if (tradersPlugin != null) {
                    this.tradersController = new TradersController();
                    this.tradersController.initialize(this, tradersPlugin);
                    this.getLogger().info("dtlTraders found, integrating for selling Wands, Spells, Brushes and Upgrades");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.tradersController = null;
            }
            if (this.tradersController == null) {
                this.getLogger().info("dtlTraders not found, will not integrate.");
            }
            this.hasCommandBook = false;
            try {
                Plugin commandBookPlugin = this.plugin.getServer().getPluginManager().getPlugin("CommandBook");
                if (commandBookPlugin != null) {
                    if (this.warpController.setCommandBook(commandBookPlugin)) {
                        this.getLogger().info("CommandBook found, integrating for Recall warps");
                        this.hasCommandBook = true;
                    } else {
                        this.getLogger().warning("CommandBook integration failed");
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (this.cuboidClipboardClass == null) {
                this.getLogger().info("WorldEdit not found, schematic brushes will not work.");
                MaterialBrush.SchematicsEnabled = false;
                this.hasWorldEdit = false;
            }
            this.factionsManager.initialize((Plugin)this.plugin);
            this.worldGuardManager.initialize((Plugin)this.plugin);
            this.pvpManager.initialize((Plugin)this.plugin);
            this.multiverseManager.initialize((Plugin)this.plugin);
            this.preciousStonesManager.initialize((Plugin)this.plugin);
            this.townyManager.initialize((Plugin)this.plugin);
            this.locketteManager.initialize((Plugin)this.plugin);
            try {
                Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
                this.dynmap = dynmapPlugin != null ? new DynmapController((Plugin)this.plugin, dynmapPlugin) : null;
            }
            catch (Throwable ex) {
                this.plugin.getLogger().warning(ex.getMessage());
            }
            if (this.dynmap == null) {
                this.getLogger().info("dynmap not found, not integrating.");
            } else {
                this.getLogger().info("dynmap found, integrating.");
            }
            try {
                Plugin elementalsPlugin = this.plugin.getServer().getPluginManager().getPlugin("Splateds_Elementals");
                this.elementals = elementalsPlugin != null ? new ElementalsController(elementalsPlugin) : null;
            }
            catch (Throwable ex) {
                this.plugin.getLogger().warning(ex.getMessage());
            }
            if (this.elementals != null) {
                this.getLogger().info("Elementals found, integrating.");
            }
            if (this.citizensEnabled) {
                try {
                    Plugin citizensPlugin = this.plugin.getServer().getPluginManager().getPlugin("Citizens");
                    if (citizensPlugin != null) {
                        this.citizens = new CitizensController(citizensPlugin);
                        break block34;
                    }
                    this.citizens = null;
                    this.getLogger().info("Citizens not found, Magic trait unavailable.");
                }
                catch (Throwable ex) {
                    this.citizens = null;
                    this.getLogger().warning("Error integrating with Citizens");
                    this.plugin.getLogger().warning(ex.getMessage());
                }
            } else {
                this.citizens = null;
                this.getLogger().info("Citizens integration disabled.");
            }
        }
        this.activateMetrics();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TimedRunnable("Mage Tick"){

            @Override
            public void onRun() {
                long threshold = System.currentTimeMillis() - (long)MAGE_FORGET_THRESHOLD;
                for (Map.Entry mageEntry : MagicController.this.forgetMages.entrySet()) {
                    if ((Long)mageEntry.getValue() >= threshold) continue;
                    MagicController.this.mages.remove(mageEntry.getKey());
                }
                MagicController.this.forgetMages.clear();
                for (com.elmakers.mine.bukkit.api.magic.Mage mage : MagicController.this.mages.values()) {
                    if (!(mage instanceof Mage)) continue;
                    try {
                        ((Mage)mage).tick();
                    }
                    catch (Exception ex) {
                        MagicController.this.getLogger().log(Level.WARNING, "Error ticking Mage " + mage.getName(), ex);
                    }
                }
            }
        }, 0L, (long)this.mageUpdateFrequency);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TimedRunnable("Block Updates"){

            @Override
            public void onRun() {
                for (com.elmakers.mine.bukkit.api.magic.Mage mage : MagicController.this.pendingConstruction) {
                    if (!(mage instanceof Mage)) continue;
                    ((Mage)mage).processPendingBatches(MagicController.this.maxBlockUpdates);
                }
                MagicController.this.pendingConstruction.removeAll(MagicController.this.pendingConstructionRemoval);
                MagicController.this.pendingConstructionRemoval.clear();
            }
        }, 0L, (long)this.blockUpdateFrequency);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TimedRunnable("Undo Scheduler"){

            @Override
            public void onRun() {
                com.elmakers.mine.bukkit.api.block.UndoList undo;
                long now = System.currentTimeMillis();
                while (MagicController.this.scheduledUndo.size() > 0 && now >= (undo = (com.elmakers.mine.bukkit.api.block.UndoList)MagicController.this.scheduledUndo.peek()).getScheduledTime()) {
                    MagicController.this.scheduledUndo.poll();
                    undo.undoScheduled();
                }
            }
        }, 0L, (long)this.undoFrequency);
        this.registerListeners();
        for (Player player : players = this.plugin.getServer().getOnlinePlayers()) {
            this.getMage(player);
        }
        this.crafting.register((Plugin)this.plugin);
        this.initialized = true;
    }

    protected void activateMetrics() {
        final MagicController controller = this;
        this.metrics = null;
        if (this.metricsLevel > 0) {
            try {
                this.metrics = new Metrics((Plugin)this.plugin);
                if (this.metricsLevel > 1) {
                    Metrics.Graph integrationGraph = this.metrics.createGraph("Plugin Integration");
                    integrationGraph.addPlotter(new Metrics.Plotter("Essentials"){

                        @Override
                        public int getValue() {
                            return controller.hasEssentials ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("WorldEdit"){

                        @Override
                        public int getValue() {
                            return controller.hasWorldEdit ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Dynmap"){

                        @Override
                        public int getValue() {
                            return controller.hasDynmap ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Factions"){

                        @Override
                        public int getValue() {
                            return controller.factionsManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("WorldGuard"){

                        @Override
                        public int getValue() {
                            return controller.worldGuardManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Elementals"){

                        @Override
                        public int getValue() {
                            return controller.elementalsEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Citizens"){

                        @Override
                        public int getValue() {
                            return controller.citizens != null ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Traders"){

                        @Override
                        public int getValue() {
                            return controller.tradersController != null ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("CommandBook"){

                        @Override
                        public int getValue() {
                            return controller.hasCommandBook ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("PvpManager"){

                        @Override
                        public int getValue() {
                            return controller.pvpManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Multiverse-Core"){

                        @Override
                        public int getValue() {
                            return controller.multiverseManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Towny"){

                        @Override
                        public int getValue() {
                            return controller.townyManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("PreciousStones"){

                        @Override
                        public int getValue() {
                            return controller.preciousStonesManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Lockette"){

                        @Override
                        public int getValue() {
                            return controller.locketteManager.isEnabled() ? 1 : 0;
                        }
                    });
                    Metrics.Graph featuresGraph = this.metrics.createGraph("Features Enabled");
                    featuresGraph.addPlotter(new Metrics.Plotter("Crafting"){

                        @Override
                        public int getValue() {
                            return controller.crafting.isEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Enchanting"){

                        @Override
                        public int getValue() {
                            return controller.enchanting.isEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Combining"){

                        @Override
                        public int getValue() {
                            return controller.anvil.isCombiningEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Organizing"){

                        @Override
                        public int getValue() {
                            return controller.anvil.isOrganizingEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Binding"){

                        @Override
                        public int getValue() {
                            return controller.bindingEnabled ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Keeping"){

                        @Override
                        public int getValue() {
                            return controller.keepingEnabled ? 1 : 0;
                        }
                    });
                }
                if (this.metricsLevel > 2) {
                    Metrics.Graph categoryGraph = this.metrics.createGraph("Casts by Category");
                    for (SpellCategory category : this.categories.values()) {
                        categoryGraph.addPlotter(new DeltaPlotter(new CategoryCastPlotter(category)));
                    }
                    Metrics.Graph totalCategoryGraph = this.metrics.createGraph("Total Casts by Category");
                    for (SpellCategory category : this.categories.values()) {
                        totalCategoryGraph.addPlotter(new CategoryCastPlotter(category));
                    }
                }
                if (this.metricsLevel > 3) {
                    Metrics.Graph spellGraph = this.metrics.createGraph("Casts");
                    for (SpellTemplate spell : this.spells.values()) {
                        if (!(spell instanceof Spell)) continue;
                        spellGraph.addPlotter(new DeltaPlotter(new SpellCastPlotter((Spell)spell)));
                    }
                    Metrics.Graph totalCastGraph = this.metrics.createGraph("Total Casts");
                    for (SpellTemplate spell : this.spells.values()) {
                        if (!(spell instanceof Spell)) continue;
                        totalCastGraph.addPlotter(new SpellCastPlotter((Spell)spell));
                    }
                }
                this.metrics.start();
                this.plugin.getLogger().info("Activated MCStats");
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to load MCStats: " + ex.getMessage());
            }
        }
    }

    protected void registerListeners() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.crafting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.enchanting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.anvil, (Plugin)this.plugin);
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getPending() {
        return this.pendingConstruction;
    }

    protected void addPending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstruction.add(mage);
    }

    protected void removePending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstructionRemoval.add(mage);
    }

    public boolean removeMarker(String id, String group) {
        boolean removed = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            return this.dynmap.removeMarker(id, group);
        }
        return removed;
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            created = this.dynmap.addMarker(id, group, title, world, x, y, z, description);
        }
        return created;
    }

    protected File getDataFile(String fileName) {
        return new File(this.dataFolder, fileName + ".yml");
    }

    protected ConfigurationSection loadDataFile(String fileName) {
        File dataFile = this.getDataFile(fileName);
        if (!dataFile.exists()) {
            return null;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)dataFile);
        return configuration;
    }

    protected DataStore createDataFile(String fileName) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        DataStore configuration = new DataStore(this.getLogger(), dataFile);
        return configuration;
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults) {
        return this.loadConfigFile(fileName, loadDefaults, false);
    }

    protected void enableAll(ConfigurationSection rootSection) {
        Set keys = rootSection.getKeys(false);
        for (String key : keys) {
            ConfigurationSection section = rootSection.getConfigurationSection(key);
            if (section.isSet("enabled")) continue;
            section.set("enabled", (Object)true);
        }
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults, boolean disableDefaults) {
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.getLogger().info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFileName = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName + ".yml" : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        this.plugin.saveResource(defaultsFileName, true);
        this.getLogger().info("Loading " + configFile.getName());
        YamlConfiguration overrides = YamlConfiguration.loadConfiguration((File)configFile);
        MemoryConfiguration config = new MemoryConfiguration();
        if (loadDefaults) {
            this.getLogger().info(" Based on defaults " + defaultsFileName);
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((InputStream)this.plugin.getResource(defaultsFileName));
            if (disableDefaults) {
                Set keys = defaultConfig.getKeys(false);
                for (String key : keys) {
                    defaultConfig.getConfigurationSection(key).set("enabled", (Object)false);
                }
                this.enableAll((ConfigurationSection)overrides);
            }
            config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)defaultConfig);
        }
        if (usingExample) {
            try {
                InputStream input = this.plugin.getResource(examplesFileName);
                if (input != null) {
                    YamlConfiguration exampleConfig = YamlConfiguration.loadConfiguration((InputStream)input);
                    if (disableDefaults) {
                        this.enableAll((ConfigurationSection)exampleConfig);
                    }
                    config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig);
                    this.getLogger().info(" Using " + examplesFileName);
                }
            }
            catch (Exception ex) {
                this.getLogger().info(ex.getMessage());
            }
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                try {
                    examplesFileName = "examples/" + example + "/" + fileName + ".yml";
                    this.plugin.saveResource(examplesFileName, true);
                    InputStream input = this.plugin.getResource(examplesFileName);
                    if (input == null) continue;
                    YamlConfiguration exampleConfig = YamlConfiguration.loadConfiguration((InputStream)input);
                    if (disableDefaults) {
                        this.enableAll((ConfigurationSection)exampleConfig);
                    }
                    config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig);
                    this.getLogger().info(" Added " + examplesFileName);
                }
                catch (Exception ex) {
                    this.getLogger().info(ex.getMessage());
                }
            }
        }
        config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)overrides);
        return config;
    }

    public void loadConfiguration() {
        this.schematics.clear();
        try {
            this.loadProperties(this.loadConfigFile("config", true));
            if (this.exampleDefaults != null && this.exampleDefaults.length() > 0 || this.addExamples != null && this.addExamples.size() > 0) {
                if (this.exampleDefaults != null && this.exampleDefaults.length() > 0) {
                    this.getLogger().info("Overriding configuration with example: " + this.exampleDefaults);
                }
                if (this.addExamples != null && this.addExamples.size() > 0) {
                    this.getLogger().info("Adding examples: " + StringUtils.join(this.addExamples, (String)","));
                }
                this.loadProperties(this.loadConfigFile("config", true));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.messages.reset();
            this.messages.load(this.loadConfigFile("messages", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadMaterials(this.loadConfigFile("materials", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadSpells(this.loadConfigFile("spells", this.loadDefaultSpells, this.disableDefaultSpells));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.spells.size() + " spells");
        try {
            this.enchanting.load(this.loadConfigFile("enchanting", this.loadDefaultEnchanting));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.enchanting.getCount() + " enchanting paths");
        try {
            Wand.loadTemplates(this.loadConfigFile("wands", this.loadDefaultWands));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + Wand.getWandTemplates().size() + " wands");
        try {
            this.crafting.load(this.loadConfigFile("crafting", this.loadDefaultCrafting));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.crafting.getCount() + " crafting recipes");
    }

    protected void loadSpellData() {
        try {
            ConfigurationSection configNode = this.loadDataFile("spells");
            if (configNode == null) {
                return;
            }
            Set keys = configNode.getKeys(false);
            for (String key : keys) {
                SpellTemplate spell = this.getSpellTemplate(key);
                if (spell == null || !(spell instanceof MageSpell)) continue;
                ConfigurationSection spellSection = configNode.getConfigurationSection(key);
                ((MageSpell)spell).load(spellSection);
            }
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to load spell metrics");
        }
    }

    public void load() {
        this.loadConfiguration();
        this.loadSpellData();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                MagicController.this.getLogger().info("Loading lost wand data");
                MagicController.this.loadLostWands();
                MagicController.this.getLogger().info("Loading automata data");
                MagicController.this.loadAutomata();
                try {
                    MagicController.this.maps.resetAll();
                    MagicController.this.maps.loadConfiguration();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MagicController.this.getLogger().info("Finished loading data.");
            }
        }, 10L);
    }

    protected void loadLostWands() {
        try {
            ConfigurationSection lostWandConfiguration = this.loadDataFile("lostwands");
            if (lostWandConfiguration != null) {
                Set wandIds = lostWandConfiguration.getKeys(false);
                for (String wandId : wandIds) {
                    if (wandId == null || wandId.length() == 0) continue;
                    LostWand lostWand = new LostWand(wandId, lostWandConfiguration.getConfigurationSection(wandId));
                    if (!lostWand.isValid()) {
                        this.getLogger().info("Skipped invalid entry in lostwands.yml file, entry will be deleted. The wand is really lost now!");
                        continue;
                    }
                    this.addLostWand(lostWand);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.lostWands.size() + " lost wands");
    }

    protected void saveSpellData(Collection<DataStore> stores) {
        String lastKey = "";
        try {
            DataStore spellsDataFile = this.createDataFile("spells");
            for (SpellTemplate spell : this.spells.values()) {
                lastKey = spell.getKey();
                ConfigurationSection spellNode = spellsDataFile.createSection(lastKey);
                if (spellNode == null) {
                    this.getLogger().warning("Error saving spell data for " + lastKey);
                    continue;
                }
                if (spell == null || !(spell instanceof MageSpell)) continue;
                ((MageSpell)spell).save(spellNode);
            }
            stores.add(spellsDataFile);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving spell data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void saveLostWands(Collection<DataStore> stores) {
        String lastKey = "";
        try {
            DataStore lostWandsConfiguration = this.createDataFile("lostwands");
            for (Map.Entry<String, LostWand> wandEntry : this.lostWands.entrySet()) {
                lastKey = wandEntry.getKey();
                if (lastKey == null || lastKey.length() == 0) continue;
                ConfigurationSection wandNode = lostWandsConfiguration.createSection(lastKey);
                if (wandNode == null) {
                    this.getLogger().warning("Error saving lost wand data for " + lastKey);
                    continue;
                }
                if (!wandEntry.getValue().isValid()) {
                    this.getLogger().warning("Invalid lost and data for " + lastKey);
                    continue;
                }
                wandEntry.getValue().save(wandNode);
            }
            stores.add(lostWandsConfiguration);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving lost wand data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void loadAutomata() {
        int automataCount = 0;
        try {
            ConfigurationSection toggleBlockData = this.loadDataFile("automata");
            if (toggleBlockData != null) {
                Set chunkIds = toggleBlockData.getKeys(false);
                for (String chunkId : chunkIds) {
                    ConfigurationSection chunkNode = toggleBlockData.getConfigurationSection(chunkId);
                    HashMap<Long, Automaton> restoreChunk = new HashMap<Long, Automaton>();
                    this.automata.put(chunkId, restoreChunk);
                    Set blockIds = chunkNode.getKeys(false);
                    for (String blockId : blockIds) {
                        ConfigurationSection toggleConfig = chunkNode.getConfigurationSection(blockId);
                        Automaton toggle = new Automaton(toggleConfig);
                        restoreChunk.put(toggle.getId(), toggle);
                        ++automataCount;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + automataCount + " automata");
    }

    protected void saveAutomata(Collection<DataStore> stores) {
        try {
            DataStore automataData = this.createDataFile("automata");
            for (Map.Entry<String, Map<Long, Automaton>> toggleEntry : this.automata.entrySet()) {
                Collection<Automaton> blocks = toggleEntry.getValue().values();
                if (blocks.size() <= 0) continue;
                ConfigurationSection chunkNode = automataData.createSection(toggleEntry.getKey());
                for (Automaton block : blocks) {
                    ConfigurationSection node = chunkNode.createSection(Long.toString(block.getId()));
                    block.save(node);
                }
            }
            stores.add(automataData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + "|" + chunk.getX() + "," + chunk.getZ();
    }

    public boolean addLostWand(LostWand lostWand) {
        this.lostWands.put(lostWand.getId(), lostWand);
        String chunkKey = this.getChunkKey(lostWand.getLocation().getChunk());
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands == null) {
            chunkWands = new HashSet<String>();
            this.lostWandChunks.put(chunkKey, chunkWands);
        }
        chunkWands.add(lostWand.getId());
        if (this.dynmapShowWands) {
            this.addLostWandMarker(lostWand);
        }
        return true;
    }

    public boolean addLostWand(Wand wand, Location dropLocation) {
        this.addLostWand(wand.makeLost(dropLocation));
        return true;
    }

    public boolean removeLostWand(String wandId) {
        if (wandId == null || wandId.length() == 0 || !this.lostWands.containsKey(wandId)) {
            return false;
        }
        LostWand lostWand = this.lostWands.get(wandId);
        this.lostWands.remove(wandId);
        String chunkKey = this.getChunkKey(lostWand.getLocation().getChunk());
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands != null) {
            chunkWands.remove(wandId);
            if (chunkWands.size() == 0) {
                this.lostWandChunks.remove(chunkKey);
            }
        }
        if (this.dynmapShowWands && this.removeMarker("wand-" + wandId, "Wands")) {
            this.getLogger().info("Wand removed from map");
        }
        return true;
    }

    public WandMode getDefaultWandMode() {
        return this.defaultWandMode;
    }

    public String getDefaultWandPath() {
        return this.defaultWandPath;
    }

    protected void savePlayerData(Collection<DataStore> stores) {
        try {
            for (Map.Entry<String, com.elmakers.mine.bukkit.api.magic.Mage> mageEntry : this.mages.entrySet()) {
                File playerData = new File(this.playerDataFolder, mageEntry.getKey() + ".dat");
                DataStore playerConfig = new DataStore(this.getLogger(), playerData);
                com.elmakers.mine.bukkit.api.magic.Mage mage = mageEntry.getValue();
                if (!mage.isPlayer() && !this.saveNonPlayerMages) {
                    if (mage.isValid()) continue;
                    this.forgetMages.put(mageEntry.getKey(), 0L);
                    continue;
                }
                if (!mage.isLoading()) {
                    mage.save((ConfigurationSection)playerConfig);
                    stores.add(playerConfig);
                }
                if (mage.isValid()) continue;
                this.getLogger().info("Forgetting Offline mage " + mage.getName());
                this.forgetMages.put(mageEntry.getKey(), 0L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String forgetId : this.forgetMages.keySet()) {
            this.mages.remove(forgetId);
        }
        this.forgetMages.clear();
    }

    public void save() {
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean asynchronous) {
        this.getLogger().info("Saving image map data");
        this.maps.save(asynchronous);
        final ArrayList<DataStore> saveData = new ArrayList<DataStore>();
        this.getLogger().info("Saving player data");
        this.savePlayerData(saveData);
        this.getLogger().info("Saving spell data");
        this.saveSpellData(saveData);
        this.getLogger().info("Saving lost wands data");
        this.saveLostWands(saveData);
        this.getLogger().info("Saving automata data");
        this.saveAutomata(saveData);
        if (asynchronous) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = MagicController.this.saveLock;
                    synchronized (object) {
                        for (DataStore config : saveData) {
                            config.save();
                        }
                    }
                }
            });
        } else {
            Object object = this.saveLock;
            synchronized (object) {
                for (DataStore config : saveData) {
                    config.save();
                }
            }
        }
        SaveEvent saveEvent = new SaveEvent(asynchronous);
        Bukkit.getPluginManager().callEvent((Event)saveEvent);
    }

    protected ConfigurationSection getSpellConfig(String key, ConfigurationSection config, ConfigurationSection originalConfig) {
        return this.getSpellConfig(key, config, originalConfig, true);
    }

    protected ConfigurationSection getSpellConfig(String key, ConfigurationSection config, ConfigurationSection originalConfig, boolean addInherited) {
        ConfigurationSection spellNode;
        ConfigurationSection configurationSection = spellNode = addInherited ? config.getConfigurationSection(key) : ConfigurationUtils.addConfigurations((ConfigurationSection)new MemoryConfiguration(), originalConfig.getConfigurationSection(key));
        if (spellNode == null) {
            this.getLogger().warning("Spell " + key + " not known");
            return null;
        }
        SpellKey spellKey = new SpellKey(key);
        String inheritFrom = spellNode.getString("inherit");
        String upgradeInheritsFrom = null;
        if (spellKey.isVariant()) {
            int level = spellKey.getLevel();
            upgradeInheritsFrom = spellKey.getBaseKey();
            if (level != 2) {
                upgradeInheritsFrom = upgradeInheritsFrom + "|" + (level - 1);
            }
        }
        boolean bl = addInherited = addInherited && inheritFrom != null;
        if (addInherited || upgradeInheritsFrom != null) {
            if (addInherited) {
                ConfigurationSection inheritConfig = this.getSpellConfig(inheritFrom, config, originalConfig);
                if (inheritConfig != null) {
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, inheritConfig, false);
                } else {
                    this.getLogger().warning("Spell " + key + " inherits from unknown ancestor " + inheritFrom);
                }
            }
            if (upgradeInheritsFrom != null) {
                if (config.contains(upgradeInheritsFrom)) {
                    ConfigurationSection baseInheritConfig = this.getSpellConfig(upgradeInheritsFrom, config, originalConfig, inheritFrom == null);
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, baseInheritConfig, inheritFrom != null);
                } else {
                    this.getLogger().warning("Spell upgrade " + key + " inherits from unknown level " + upgradeInheritsFrom);
                }
            }
        } else {
            ConfigurationSection defaults = config.getConfigurationSection("default");
            if (defaults != null) {
                spellNode = ConfigurationUtils.addConfigurations(spellNode, defaults, false);
            }
        }
        return spellNode;
    }

    protected void loadSpells(ConfigurationSection config) {
        if (config == null) {
            return;
        }
        this.spells.clear();
        this.spellAliases.clear();
        ConfigurationSection originalConfig = ConfigurationUtils.addConfigurations((ConfigurationSection)new MemoryConfiguration(), config);
        Set spellKeys = config.getKeys(false);
        for (String key : spellKeys) {
            String icon;
            ConfigurationSection spellNode;
            if (key.equals("default") || (spellNode = this.getSpellConfig(key, config, originalConfig)) == null || !spellNode.getBoolean("enabled", true)) continue;
            if (this.allPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)true);
            }
            Spell newSpell = null;
            try {
                newSpell = MagicController.loadSpell(key, spellNode, this);
            }
            catch (Exception ex) {
                newSpell = null;
                ex.printStackTrace();
            }
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + key);
                continue;
            }
            if (!newSpell.hasIcon() && (icon = spellNode.getString("icon")) != null && !icon.isEmpty()) {
                this.getLogger().info("Couldn't load spell icon '" + icon + "' for spell: " + newSpell.getKey());
            }
            this.addSpell(newSpell);
        }
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).loadSpells(config);
        }
    }

    public static Spell loadSpell(String name, ConfigurationSection node, MageController controller) {
        Object newObject;
        String className = node.getString("class");
        if (className == null) {
            className = "com.elmakers.mine.bukkit.spell.ActionSpell";
        } else if (className.indexOf(46) <= 0) {
            className = "com.elmakers.mine.bukkit.spell.builtin." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            return null;
        }
        if (newObject == null || !(newObject instanceof MageSpell)) {
            controller.getLogger().warning("Error loading spell: " + className + ", does it implement MageSpell?");
            return null;
        }
        MageSpell newSpell = (MageSpell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        com.elmakers.mine.bukkit.api.spell.SpellCategory category = newSpell.getCategory();
        if (category instanceof SpellCategory) {
            ((SpellCategory)category).addSpellTemplate(newSpell);
        }
        return newSpell;
    }

    protected void loadMaterials(ConfigurationSection materialNode) {
        if (materialNode == null) {
            return;
        }
        Set keys = materialNode.getKeys(false);
        for (String key : keys) {
            this.materialSets.put(key, ConfigurationUtils.getMaterials(materialNode, key));
        }
        if (this.materialSets.containsKey("building")) {
            this.buildingMaterials = this.materialSets.get("building");
        }
        if (this.materialSets.containsKey("indestructible")) {
            this.indestructibleMaterials = this.materialSets.get("indestructible");
        }
        if (this.materialSets.containsKey("restricted")) {
            this.restrictedMaterials = this.materialSets.get("restricted");
        }
        if (this.materialSets.containsKey("destructible")) {
            this.destructibleMaterials = this.materialSets.get("destructible");
        }
        if (this.materialSets.containsKey("interactible")) {
            this.interactibleMaterials = this.materialSets.get("interactible");
        }
        if (this.materialSets.containsKey("wearable")) {
            this.wearableMaterials = this.materialSets.get("wearable");
        }
    }

    protected void loadProperties(ConfigurationSection properties) {
        if (properties == null) {
            return;
        }
        if (this.autoSaveTaskId > 0) {
            Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
            this.autoSaveTaskId = 0;
        }
        EffectPlayer.debugEffects(properties.getBoolean("debug_effects", false));
        this.exampleDefaults = properties.getString("example", this.exampleDefaults);
        this.addExamples = properties.getStringList("add_examples");
        this.showCastHoloText = properties.getBoolean("show_cast_holotext", this.showCastHoloText);
        this.showActivateHoloText = properties.getBoolean("show_activate_holotext", this.showCastHoloText);
        this.castHoloTextRange = properties.getInt("cast_holotext_range", this.castHoloTextRange);
        this.activateHoloTextRange = properties.getInt("activate_holotext_range", this.activateHoloTextRange);
        this.urlIconsEnabled = properties.getBoolean("url_icons_enabled", this.urlIconsEnabled);
        this.loadDefaultSpells = properties.getBoolean("load_default_spells", this.loadDefaultSpells);
        this.disableDefaultSpells = properties.getBoolean("disable_default_spells", this.disableDefaultSpells);
        this.loadDefaultWands = properties.getBoolean("load_default_wands", this.loadDefaultWands);
        this.loadDefaultCrafting = properties.getBoolean("load_default_crafting", this.loadDefaultCrafting);
        this.loadDefaultEnchanting = properties.getBoolean("load_default_enchanting", this.loadDefaultEnchanting);
        this.maxTNTPerChunk = properties.getInt("max_tnt_per_chunk", this.maxTNTPerChunk);
        this.undoQueueDepth = properties.getInt("undo_depth", this.undoQueueDepth);
        this.blockUpdateFrequency = properties.getInt("block_update_frequency", this.blockUpdateFrequency);
        this.mageUpdateFrequency = properties.getInt("mage_update_frequency", this.mageUpdateFrequency);
        this.undoFrequency = properties.getInt("undo_frequency", this.undoFrequency);
        this.pendingQueueDepth = properties.getInt("pending_depth", this.pendingQueueDepth);
        this.undoMaxPersistSize = properties.getInt("undo_max_persist_size", this.undoMaxPersistSize);
        this.commitOnQuit = properties.getBoolean("commit_on_quit", this.commitOnQuit);
        this.saveNonPlayerMages = properties.getBoolean("save_non_player_mages", this.saveNonPlayerMages);
        this.undoOnWorldSave = properties.getBoolean("undo_on_world_save", this.undoOnWorldSave);
        this.backupInventory = properties.getBoolean("backup_inventory", this.backupInventory);
        this.defaultWandPath = properties.getString("default_wand_path", "");
        this.defaultWandMode = Wand.parseWandMode(properties.getString("default_wand_mode", ""), this.defaultWandMode);
        this.showMessages = properties.getBoolean("show_messages", this.showMessages);
        this.showCastMessages = properties.getBoolean("show_cast_messages", this.showCastMessages);
        this.clickCooldown = properties.getInt("click_cooldown", this.clickCooldown);
        this.messageThrottle = properties.getInt("message_throttle", 0);
        this.maxBlockUpdates = properties.getInt("max_block_updates", this.maxBlockUpdates);
        this.ageDroppedItems = properties.getInt("age_dropped_items", this.ageDroppedItems);
        this.enableItemHacks = properties.getBoolean("enable_custom_item_hacks", this.enableItemHacks);
        this.enableCreativeModeEjecting = properties.getBoolean("enable_creative_mode_ejecting", this.enableCreativeModeEjecting);
        this.soundsEnabled = properties.getBoolean("sounds", this.soundsEnabled);
        this.fillingEnabled = properties.getBoolean("fill_wands", this.fillingEnabled);
        this.indestructibleWands = properties.getBoolean("indestructible_wands", this.indestructibleWands);
        this.keepWandsOnDeath = properties.getBoolean("keep_wands_on_death", this.keepWandsOnDeath);
        this.welcomeWand = properties.getString("welcome_wand", "");
        this.maxDamagePowerMultiplier = (float)properties.getDouble("max_power_damage_multiplier", (double)this.maxDamagePowerMultiplier);
        this.maxConstructionPowerMultiplier = (float)properties.getDouble("max_power_construction_multiplier", (double)this.maxConstructionPowerMultiplier);
        this.maxRangePowerMultiplier = (float)properties.getDouble("max_power_range_multiplier", (double)this.maxRangePowerMultiplier);
        this.maxRangePowerMultiplierMax = (float)properties.getDouble("max_power_range_multiplier_max", (double)this.maxRangePowerMultiplierMax);
        this.maxRadiusPowerMultiplier = (float)properties.getDouble("max_power_radius_multiplier", (double)this.maxRadiusPowerMultiplier);
        this.maxRadiusPowerMultiplierMax = (float)properties.getDouble("max_power_radius_multiplier_max", (double)this.maxRadiusPowerMultiplierMax);
        this.maxPower = (float)properties.getDouble("max_power", (double)this.maxPower);
        this.maxHaste = (float)properties.getDouble("max_haste", (double)this.maxHaste);
        this.maxHealthRegeneration = (float)properties.getDouble("max_health_regeneration", (double)this.maxHealthRegeneration);
        this.maxHungerRegeneration = (float)properties.getDouble("max_hunger_regeneration", (double)this.maxHungerRegeneration);
        this.maxDamageReduction = (float)properties.getDouble("max_damage_reduction", (double)this.maxDamageReduction);
        this.maxDamageReductionExplosions = (float)properties.getDouble("max_damage_reduction_explosions", (double)this.maxDamageReductionExplosions);
        this.maxDamageReductionFalling = (float)properties.getDouble("max_damage_reduction_falling", (double)this.maxDamageReductionFalling);
        this.maxDamageReductionFire = (float)properties.getDouble("max_damage_reduction_fire", (double)this.maxDamageReductionFire);
        this.maxDamageReductionPhysical = (float)properties.getDouble("max_damage_reduction_physical", (double)this.maxDamageReductionPhysical);
        this.maxDamageReductionProjectiles = (float)properties.getDouble("max_damage_reduction_projectiles", (double)this.maxDamageReductionProjectiles);
        this.maxCostReduction = (float)properties.getDouble("max_cost_reduction", (double)this.maxCostReduction);
        this.maxCooldownReduction = (float)properties.getDouble("max_cooldown_reduction", (double)this.maxCooldownReduction);
        this.maxMana = properties.getInt("max_mana", this.maxMana);
        this.maxManaRegeneration = properties.getInt("max_mana_regeneration", this.maxManaRegeneration);
        this.costReduction = (float)properties.getDouble("cost_reduction", (double)this.costReduction);
        this.cooldownReduction = (float)properties.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.castCommandCostReduction = (float)properties.getDouble("cast_command_cost_reduction", (double)this.castCommandCostReduction);
        this.castCommandCooldownReduction = (float)properties.getDouble("cast_command_cooldown_reduction", (double)this.castCommandCooldownReduction);
        this.castCommandPowerMultiplier = (float)properties.getDouble("cast_command_power_multiplier", (double)this.castCommandPowerMultiplier);
        this.autoUndo = properties.getInt("auto_undo", this.autoUndo);
        this.spellDroppingEnabled = properties.getBoolean("allow_spell_dropping", this.spellDroppingEnabled);
        this.bindingEnabled = properties.getBoolean("enable_binding", this.bindingEnabled);
        this.keepingEnabled = properties.getBoolean("enable_keeping", this.keepingEnabled);
        this.essentialsSignsEnabled = properties.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
        this.citizensEnabled = properties.getBoolean("enable_citizens", this.citizensEnabled);
        this.dynmapShowWands = properties.getBoolean("dynmap_show_wands", this.dynmapShowWands);
        this.dynmapShowSpells = properties.getBoolean("dynmap_show_spells", this.dynmapShowSpells);
        this.dynmapOnlyPlayerSpells = properties.getBoolean("dynmap_only_player_spells", this.dynmapOnlyPlayerSpells);
        this.dynmapUpdate = properties.getBoolean("dynmap_update", this.dynmapUpdate);
        this.bypassBuildPermissions = properties.getBoolean("bypass_build", this.bypassBuildPermissions);
        this.bypassPvpPermissions = properties.getBoolean("bypass_pvp", this.bypassPvpPermissions);
        this.allPvpRestricted = properties.getBoolean("pvp_restricted", this.allPvpRestricted);
        this.extraSchematicFilePath = properties.getString("schematic_files", this.extraSchematicFilePath);
        this.createWorldsEnabled = properties.getBoolean("enable_world_creation", this.createWorldsEnabled);
        this.messagePrefix = properties.getString("message_prefix", this.messagePrefix);
        this.castMessagePrefix = properties.getString("cast_message_prefix", this.castMessagePrefix);
        this.redstoneReplacement = ConfigurationUtils.getMaterialAndData(properties, "redstone_replacement", this.redstoneReplacement);
        this.messagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagePrefix);
        this.castMessagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.castMessagePrefix);
        this.worldGuardManager.setEnabled(properties.getBoolean("region_manager_enabled", this.worldGuardManager.isEnabled()));
        this.factionsManager.setEnabled(properties.getBoolean("factions_enabled", this.factionsManager.isEnabled()));
        this.pvpManager.setEnabled(properties.getBoolean("pvp_manager_enabled", this.pvpManager.isEnabled()));
        this.multiverseManager.setEnabled(properties.getBoolean("multiverse_enabled", this.multiverseManager.isEnabled()));
        this.preciousStonesManager.setEnabled(properties.getBoolean("precious_stones_enabled", this.preciousStonesManager.isEnabled()));
        this.townyManager.setEnabled(properties.getBoolean("towny_enabled", this.townyManager.isEnabled()));
        this.locketteManager.setEnabled(properties.getBoolean("lockette_enabled", this.locketteManager.isEnabled()));
        this.metricsLevel = properties.getInt("metrics_level", this.metricsLevel);
        if (properties.contains("mana_display")) {
            Wand.retainLevelDisplay = properties.getString("mana_display").equals("hybrid");
            Wand.displayManaAsBar = !properties.getString("mana_display").equals("number");
            Wand.displayManaAsDurability = properties.getString("mana_display").equals("durability");
            Wand.displayManaAsGlow = properties.getString("mana_display").equals("glow");
        }
        Wand.DefaultUpgradeMaterial = ConfigurationUtils.getMaterial(properties, "wand_upgrade_item", Wand.DefaultUpgradeMaterial);
        Wand.EnableGlow = properties.getBoolean("wand_glow", Wand.EnableGlow);
        Wand.SpellGlow = properties.getBoolean("spell_glow", Wand.SpellGlow);
        Wand.LiveHotbar = properties.getBoolean("live_hotbar", Wand.LiveHotbar);
        Wand.BrushGlow = properties.getBoolean("brush_glow", Wand.BrushGlow);
        Wand.WAND_KEY = properties.getString("wand_key", "wand");
        MaterialBrush.CopyMaterial = ConfigurationUtils.getMaterial(properties, "copy_item", MaterialBrush.CopyMaterial);
        MaterialBrush.EraseMaterial = ConfigurationUtils.getMaterial(properties, "erase_item", MaterialBrush.EraseMaterial);
        MaterialBrush.CloneMaterial = ConfigurationUtils.getMaterial(properties, "clone_item", MaterialBrush.CloneMaterial);
        MaterialBrush.ReplicateMaterial = ConfigurationUtils.getMaterial(properties, "replicate_item", MaterialBrush.ReplicateMaterial);
        MaterialBrush.SchematicMaterial = ConfigurationUtils.getMaterial(properties, "schematic_item", MaterialBrush.SchematicMaterial);
        MaterialBrush.MapMaterial = ConfigurationUtils.getMaterial(properties, "map_item", MaterialBrush.MapMaterial);
        Wand.inventoryOpenSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_open_sound"));
        Wand.inventoryCloseSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_close_sound"));
        Wand.inventoryCycleSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_cycle_sound"));
        this.wandAbuseDamage = properties.getDouble("wand_abuse_damage", 0.0);
        this.preventMeleeDamage = properties.getBoolean("prevent_melee_damage", false);
        EffectPlayer.SOUNDS_ENABLED = this.soundsEnabled;
        final MagicController saveController = this;
        int autoSaveIntervalTicks = properties.getInt("auto_save", 0) * 20 / 1000;
        if (autoSaveIntervalTicks > 1) {
            this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TimedRunnable("Auto Save"){

                @Override
                public void onRun() {
                    saveController.getLogger().info("Auto-saving Magic data");
                    saveController.save(true);
                    saveController.getLogger().info("... Done auto-saving.");
                }
            }, (long)autoSaveIntervalTicks, (long)autoSaveIntervalTicks);
        }
        Wand.DefaultWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item", Wand.DefaultWandMaterial);
        Wand.EnchantableWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item_enchantable", Wand.EnchantableWandMaterial);
        this.enchanting.setEnabled(properties.getBoolean("enable_enchanting", this.enchanting.isEnabled()));
        if (this.enchanting.isEnabled()) {
            this.getLogger().info("Wand enchanting is enabled");
        }
        this.crafting.setEnabled(properties.getBoolean("enable_crafting", this.crafting.isEnabled()));
        if (this.crafting.isEnabled()) {
            this.getLogger().info("Wand crafting is enabled");
        }
        this.anvil.load(properties);
        if (this.anvil.isCombiningEnabled()) {
            this.getLogger().info("Wand anvil combining is enabled");
        }
        if (this.anvil.isOrganizingEnabled()) {
            this.getLogger().info("Wand anvil organizing is enabled");
        }
    }

    protected void clear() {
        this.initialized = false;
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> saveMages = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.mages.values());
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : saveMages) {
            this.playerQuit(mage);
        }
        this.mages.clear();
        this.pendingConstruction.clear();
        this.pendingConstructionRemoval.clear();
        this.spells.clear();
    }

    protected void unregisterPhysicsHandler(Listener listener) {
        BlockPhysicsEvent.getHandlerList().unregister(listener);
        this.physicsHandler = null;
    }

    protected void registerForUndo(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingUndo.add(mage.getId());
    }

    @Override
    public void scheduleUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        this.scheduledUndo.add(undoList);
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    @Override
    public boolean hasCastPermission(CommandSender sender, SpellTemplate spell) {
        if (sender == null) {
            return true;
        }
        if (sender instanceof Player && ((Player)sender).hasPermission("Magic.bypass")) {
            return true;
        }
        return this.hasPermission(sender, spell.getPermissionNode(), true);
    }

    @Override
    public Boolean getRegionCastPermission(Player player, SpellTemplate spell, Location location) {
        if (player != null && player.hasPermission("Magic.bypass")) {
            return true;
        }
        return this.worldGuardManager.getCastPermission(player, spell, location);
    }

    @Override
    public Boolean getPersonalCastPermission(Player player, SpellTemplate spell, Location location) {
        if (player != null && player.hasPermission("Magic.bypass")) {
            return true;
        }
        return this.preciousStonesManager.getCastPermission(player, spell, location);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet;
        String parentNode;
        boolean isParentSet;
        if (player == null) {
            return true;
        }
        if (pNode.contains(".") && (isParentSet = player.isPermissionSet(parentNode = pNode.substring(0, pNode.lastIndexOf(46) + 1) + "*"))) {
            defaultValue = player.hasPermission(parentNode);
        }
        return (isSet = player.isPermissionSet(pNode)) ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, false);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, defaultValue);
    }

    @EventHandler
    public void onWorldSaveEvent(WorldSaveEvent event) {
        if (!this.undoOnWorldSave) {
            return;
        }
        World world = event.getWorld();
        List players = world.getPlayers();
        for (Player player : players) {
            int undone;
            UndoQueue queue;
            if (!this.isMage((Entity)player) || (queue = this.getMage(player).getUndoQueue()) == null || (undone = queue.undoScheduled()) <= 0) continue;
            this.getLogger().info("Undid " + undone + " spells for " + player.getName() + "prior to save of world " + world.getName());
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        final Projectile projectile = event.getEntity();
        if (ActionHandler.hasActions((Entity)projectile)) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    ActionHandler.runActions((Entity)projectile, projectile.getLocation(), null);
                    ActionHandler.runEffects((Entity)projectile);
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            ActionHandler.runActions(entity, entity.getLocation(), null);
            ActionHandler.runEffects(entity);
            com.elmakers.mine.bukkit.api.block.UndoList blockList = UndoList.getUndoList(entity);
            if (blockList != null) {
                blockList.convert(entity, event.getBlock());
            } else {
                this.registerFallingBlock(entity, event.getBlock());
            }
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        Entity entity = event.getEntity();
        if (this.isMage(entity)) {
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(event.getEntity());
            if (!(apiMage instanceof Mage)) {
                return;
            }
            Mage mage = (Mage)apiMage;
            mage.onPlayerCombust(event);
        }
        if (!event.isCancelled() && (undoList = this.getPendingUndo(entity.getLocation())) != null) {
            undoList.modify(entity);
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Block targetBlock = event.getToBlock();
        Block sourceBlock = event.getBlock();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(sourceBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock, true);
        } else {
            undoList = this.getPendingUndo(targetBlock.getLocation());
            if (undoList != null) {
                undoList.add(targetBlock, true);
            }
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        Block targetBlock = event.getBlock();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(targetBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock, true);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        if (cause == BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL || cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            return;
        }
        Entity entity = event.getIgnitingEntity();
        com.elmakers.mine.bukkit.api.block.UndoList entityList = this.getEntityUndo(entity);
        if (entityList != null) {
            entityList.add(event.getBlock(), true);
            return;
        }
        Block ignitingBlock = event.getIgnitingBlock();
        Block targetBlock = event.getBlock();
        if (ignitingBlock != null && (undoList = this.getPendingUndo(ignitingBlock.getLocation())) != null) {
            undoList.add(event.getBlock(), true);
            return;
        }
        undoList = this.getPendingUndo(targetBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock, true);
        }
    }

    protected com.elmakers.mine.bukkit.api.block.UndoList getPendingUndo(Location location) {
        return UndoList.getUndoList(location);
    }

    protected void registerFallingBlock(Entity fallingBlock, Block block) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(fallingBlock.getLocation());
        if (undoList != null) {
            undoList.fall(fallingBlock, block);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.enableItemHacks || event.isCancelled()) {
            return;
        }
        ItemStack oldStack = event.getOldCursor();
        HumanEntity entity = event.getWhoClicked();
        if (oldStack != null && oldStack.hasItemMeta() && entity instanceof Player) {
            Map draggedSlots = event.getNewItems();
            if (draggedSlots.size() != 1) {
                return;
            }
            event.setCancelled(true);
            InventoryView view = event.getView();
            for (Integer dslot : draggedSlots.keySet()) {
                CompleteDragTask completeDrag = new CompleteDragTask((Player)entity, view, dslot);
                completeDrag.runTaskLater((Plugin)this.plugin, 1L);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        com.elmakers.mine.bukkit.api.magic.Mage mage;
        com.elmakers.mine.bukkit.api.wand.Wand wand;
        Player player;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        Entity damager = event.getDamager();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getEntityUndo(damager);
        if (undoList != null) {
            undoList.modify(entity);
            if (entity instanceof ItemFrame && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                ItemFrame frame = (ItemFrame)entity;
                frame.setItem(null);
            }
        }
        ActionHandler.targetEffects(damager, entity);
        ActionHandler.runActions(damager, entity.getLocation(), entity);
        if (this.preventMeleeDamage && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && damager instanceof Player && entity instanceof Player) {
            player = (Player)damager;
            ItemStack itemInHand = player.getItemInHand();
            if (!this.isSword(itemInHand)) {
                event.setCancelled(true);
            }
        } else if (this.wandAbuseDamage > 0.0 && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && damager instanceof Player && this.isMage(damager) && entity instanceof Player && (wand = (mage = this.getMage(player = (Player)damager)).getActiveWand()) != null && !this.isSword(wand.getItem())) {
            event.setCancelled(true);
            player.playEffect(EntityEffect.HURT);
            player.damage(this.wandAbuseDamage);
        }
    }

    protected boolean isSword(ItemStack item) {
        return item.getType() == Material.DIAMOND_SWORD || item.getType() == Material.WOOD_SWORD || item.getType() == Material.IRON_SWORD || item.getType() == Material.STONE_SWORD || item.getType() == Material.GOLD_SWORD;
    }

    protected com.elmakers.mine.bukkit.api.block.UndoList getEntityUndo(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity == null) {
            return null;
        }
        if (this.isMage(entity)) {
            com.elmakers.mine.bukkit.api.block.UndoList undoList;
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.getMage(entity);
            if (mage instanceof Mage && (undoList = mage.getLastUndoList()) != null) {
                long now = System.currentTimeMillis();
                if (undoList.getModifiedTime() > now - (long)this.undoTimeWindow) {
                    blockList = undoList;
                }
            }
        } else {
            blockList = UndoList.getUndoList(entity);
        }
        return blockList;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        Hanging entity = event.getEntity();
        if (entity.hasMetadata("broken")) {
            return;
        }
        Location location = entity.getLocation();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(location = location.getBlock().getRelative(entity.getAttachedFace()).getLocation());
        if (undoList != null) {
            event.setCancelled(true);
            undoList.modify((Entity)entity);
            entity.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Entity breakingEntity = event.getRemover();
        if (breakingEntity == null) {
            return;
        }
        Hanging entity = event.getEntity();
        Location location = entity.getLocation();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(location = location.getBlock().getRelative(entity.getAttachedFace()).getLocation());
        if (undoList != null) {
            entity.setMetadata("broken", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            undoList.modify((Entity)entity);
            event.setCancelled(true);
            undoList.modify((Entity)entity);
            entity.remove();
        }
    }

    @EventHandler
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        Entity explodingEntity = event.getEntity();
        ActionHandler.runActions(explodingEntity, explodingEntity.getLocation(), null);
        ActionHandler.runEffects(explodingEntity);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        com.elmakers.mine.bukkit.api.block.UndoList blockList = this.getEntityUndo(explodingEntity);
        boolean cancel = event.isCancelled();
        boolean bl = cancel = cancel || explodingEntity.hasMetadata("cancel_explosion");
        if (cancel) {
            event.setCancelled(true);
        } else if (this.maxTNTPerChunk > 0 && explodingEntity.getType() == EntityType.PRIMED_TNT) {
            Entity[] entities;
            Chunk chunk = explodingEntity.getLocation().getChunk();
            if (chunk == null || !chunk.isLoaded()) {
                return;
            }
            int tntCount = 0;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity == null || entity.getType() != EntityType.PRIMED_TNT) continue;
                ++tntCount;
            }
            if (tntCount > this.maxTNTPerChunk) {
                event.setCancelled(true);
            } else if (blockList != null) {
                blockList.explode(explodingEntity, event.blockList());
            }
        } else if (blockList != null) {
            blockList.explode(explodingEntity, event.blockList());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityFinalizeExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        com.elmakers.mine.bukkit.api.block.UndoList blockList = this.getEntityUndo(explodingEntity);
        if (blockList == null) {
            return;
        }
        if (event.isCancelled()) {
            blockList.cancelExplosion(explodingEntity);
        } else {
            blockList.finalizeExplosion(explodingEntity, event.blockList());
        }
    }

    protected void onPlayerActivateIcon(com.elmakers.mine.bukkit.api.magic.Mage mage, Wand activeWand, ItemStack icon) {
        if (icon != null && icon.getType() != Material.AIR) {
            MageSpell spell = mage.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                activeWand.setActiveSpell(spell.getKey());
            } else if (Wand.isBrush(icon)) {
                activeWand.activateBrush(icon);
            }
        } else {
            activeWand.setActiveSpell("");
        }
        mage.getPlayer().updateInventory();
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        ItemStack previous = inventory.getItem(event.getPreviousSlot());
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null && Wand.isWand(previous)) {
            if (activeWand.isInventoryOpen()) {
                if (!Wand.isWand(next)) {
                    this.onPlayerActivateIcon(mage, activeWand, next);
                }
                event.setCancelled(true);
                return;
            }
            activeWand.deactivate();
        }
        if (next != null && Wand.isWand(next)) {
            Wand newWand = new Wand(this, next);
            newWand.activate(mage, next, event.getNewSlot());
        }
        if ((activeWand = mage.getActiveWand()) == null && next != null && next.getType() == Material.MAP) {
            mage.setLastHeldMapId(next.getDurability());
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.getActiveGUI() != null) {
            event.setCancelled(true);
            return;
        }
        final Wand activeWand = mage.getActiveWand();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        boolean cancelEvent = false;
        if (Wand.isWand(droppedItem) && activeWand != null && activeWand.isUndroppable()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (activeWand.getHotbars().size() > 1) {
                        activeWand.cycleHotbar(1);
                    } else {
                        activeWand.closeInventory();
                    }
                }
            });
            cancelEvent = true;
        } else if (activeWand != null) {
            ItemStack inHand = event.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(droppedItem) && (inHand == null || inHand.getType() == Material.AIR)) {
                activeWand.deactivate();
                if (Wand.hasActiveWand(player)) {
                    player.setItemInHand(new ItemStack(Material.AIR, 1));
                }
            } else if (activeWand.isInventoryOpen()) {
                if (!this.spellDroppingEnabled) {
                    cancelEvent = true;
                } else {
                    this.removeItemFromWand(activeWand, droppedItem);
                }
            }
        }
        if (cancelEvent) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasMetadata("nodrops")) {
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
        if (!this.isMage((Entity)entity)) {
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage((Entity)entity);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.onPlayerDeath(event);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String rule = entity.getWorld().getGameRuleValue("keepInventory");
        if (rule.equals("true")) {
            return;
        }
        List drops = event.getDrops();
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                ItemStack[] armor;
                drops.clear();
                ItemStack[] stored = mage.getStoredInventory().getContents();
                wand.deactivate();
                for (ItemStack stack : stored) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
                for (ItemStack stack : armor = player.getInventory().getArmorContents()) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
            } else {
                wand.deactivate();
            }
        }
        ArrayList oldDrops = new ArrayList(drops);
        ArrayList keepWands = new ArrayList();
        drops.clear();
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack itemStack = contents[index];
            boolean keepItem = false;
            if (Wand.isWand(itemStack) && !(keepItem = this.keepWandsOnDeath)) {
                Wand testWand = new Wand(this, itemStack);
                keepItem = testWand.keepOnDeath();
            }
            if (keepItem) {
                mage.addToRespawnInventory(index, itemStack);
                continue;
            }
            drops.add(itemStack);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(event.getPlayer());
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.restoreRespawnInventories();
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        Item entity = event.getEntity();
        ActionHandler.runEffects((Entity)entity);
        ActionHandler.runActions((Entity)entity, entity.getLocation(), null);
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this, entity.getItemStack());
            if (wand.isIndestructible()) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else if (this.dynmapShowWands) {
                this.removeLostWand(wand.getLostId());
            }
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this, event.getEntity().getItemStack());
            if (wand.isIndestructible()) {
                CompatibilityUtils.setInvulnerable((Entity)event.getEntity());
                this.addLostWand(wand, event.getEntity().getLocation());
                Location dropLocation = event.getLocation();
                this.getLogger().info("Wand " + wand.getName() + ", id " + wand.getLostId() + " spawned at " + dropLocation.getBlockX() + " " + dropLocation.getBlockY() + " " + dropLocation.getBlockZ());
            }
        } else {
            this.registerEntityForUndo((Entity)event.getEntity());
            if (this.ageDroppedItems > 0) {
                int ticks = this.ageDroppedItems * 20 / 1000;
                Item item = event.getEntity();
                CompatibilityUtils.ageItem(item, ticks);
            }
        }
    }

    protected void registerEntityForUndo(Entity entity) {
        long now = System.currentTimeMillis();
        ArrayList<String> keys = new ArrayList<String>(this.pendingUndo);
        for (String key : keys) {
            if (this.mages.containsKey(key)) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.mages.get(key);
                if (!(apiMage instanceof Mage)) continue;
                Mage mage = (Mage)apiMage;
                com.elmakers.mine.bukkit.api.block.UndoList lastUndo = mage.getLastUndoList();
                if (lastUndo == null || lastUndo.getModifiedTime() < now - (long)this.undoTimeWindow) {
                    this.pendingUndo.remove(key);
                    continue;
                }
                if (!lastUndo.contains(entity.getLocation(), this.undoBlockBorderSize)) continue;
                lastUndo.add(entity);
                break;
            }
            this.pendingUndo.remove(key);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            Item item;
            ItemStack itemStack;
            Entity entity = event.getEntity();
            if (this.isMage(entity)) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(event.getEntity());
                if (!(apiMage instanceof Mage)) {
                    return;
                }
                Mage mage = (Mage)apiMage;
                mage.onPlayerDamage(event);
            }
            if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
                Wand wand = new Wand(this, item.getItemStack());
                if (wand.isIndestructible()) {
                    event.setCancelled(true);
                } else if (event.getDamage() >= (double)itemStack.getDurability() && this.removeLostWand(wand.getLostId())) {
                    this.plugin.getLogger().info("Wand " + wand.getName() + ", id " + wand.getLostId() + " destroyed");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.getActiveWand();
        if (wand != null && event.getRightClicked() instanceof ItemFrame) {
            if (wand.isUndroppable()) {
                event.setCancelled(true);
                return;
            }
            wand.deactivate();
        }
        if (this.isNPC(event.getRightClicked())) {
            if (wand != null) {
                wand.closeInventory();
            }
            mage.checkLastClick(0L);
        } else {
            ItemStack itemInHand = player.getItemInHand();
            if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getItemInHand();
        if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
            event.setCancelled(true);
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        Wand wand = mage.getActiveWand();
        boolean hasWand = Wand.hasActiveWand(player);
        if ((itemInHand == null || itemInHand.getType() == Material.AIR) && wand != null) {
            this.getLogger().warning("Mage had an active wand, but player is not holding anything");
            wand.deactivate();
            return;
        }
        if (wand == null && hasWand) {
            wand = Wand.getActiveWand(this, player);
            wand.activate(mage);
            this.getLogger().warning("Player was holding an inactive wand on interact- activating.");
        }
        if (wand == null) {
            return;
        }
        if (!this.hasWandPermission(player)) {
            if (this.hasPermission(player, "Magic.wand.destruct", false)) {
                wand.deactivate();
                PlayerInventory inventory = player.getInventory();
                ItemStack[] items = inventory.getContents();
                for (int i = 0; i < items.length; ++i) {
                    ItemStack item = items[i];
                    if (!Wand.isWand(item) && !Wand.isSpell(item) && !Wand.isBrush(item) && !Wand.isUpgrade(item)) continue;
                    items[i] = null;
                }
                inventory.setContents(items);
                mage.sendMessage(this.messages.get("wand.self_destruct"));
            }
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK && !wand.isUpgrade()) {
            wand.cast();
            event.setCancelled(true);
            return;
        }
        boolean bl = toggleInventory = event.getAction() == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl2 = toggleInventory = !this.interactibleMaterials.contains(material);
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                wand.closeInventory();
            }
        }
        if (toggleInventory) {
            if (!mage.cancel()) {
                WandMode wandMode = wand.getMode();
                if (wandMode == WandMode.CYCLE) {
                    if (player.isSneaking()) {
                        Spell activeSpell = wand.getActiveSpell();
                        boolean cycleMaterials = false;
                        if (activeSpell != null) {
                            boolean bl3 = cycleMaterials = activeSpell.hasBrushOverride() && wand.getBrushes().size() > 0;
                        }
                        if (cycleMaterials) {
                            wand.cycleMaterials();
                        } else {
                            wand.cycleSpells();
                        }
                    } else {
                        wand.cycleSpells();
                    }
                } else if (wandMode == WandMode.CAST) {
                    wand.cast();
                } else {
                    wand.toggleInventory();
                }
                event.setCancelled(true);
            } else {
                mage.playSound(Sound.NOTE_BASS, 1.0f, 0.7f);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.getMage(event.getPlayer());
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.hasStoredInventory()) {
            mage.addToStoredInventory(itemStack);
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItem(inventory.getHeldItemSlot(), itemStack);
            if (Wand.isWand(itemStack)) {
                Wand wand = new Wand(this, itemStack);
                wand.activate(this.getMage((CommandSender)player));
            }
        } else {
            HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
            if (returned.size() > 0) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
            }
        }
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (event.getAmount() <= 0) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.onPlayerExpChange(event);
        }
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    protected void handlePlayerQuitEvent(PlayerEvent event) {
        Player player = event.getPlayer();
        if (this.isMage((Entity)player)) {
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.getMage(player);
            if (mage instanceof Mage) {
                ((Mage)mage).onPlayerQuit(event);
            }
            this.playerQuit(mage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        com.elmakers.mine.bukkit.api.wand.Wand wand;
        this.maps.resend(mage.getName());
        UndoQueue undoQueue = mage.getUndoQueue();
        if (undoQueue != null) {
            int undid = undoQueue.undoScheduled();
            if (undid != 0) {
                this.getLogger().info("Player " + mage.getName() + " logged out, auto-undid " + undid + " spells");
            }
            if (!undoQueue.isEmpty()) {
                if (this.commitOnQuit) {
                    this.getLogger().info("Player logged out, committing constructions: " + mage.getName());
                    undoQueue.commit();
                } else {
                    this.getLogger().info("Player " + mage.getName() + " logged out with " + undoQueue.getSize() + " spells in their undo queue");
                }
            }
        }
        if (!mage.isLoading() && (mage.isPlayer() || this.saveNonPlayerMages)) {
            File playerData = new File(this.playerDataFolder, mage.getId() + ".dat");
            this.getLogger().info("Player logged out, saving data to " + playerData.getName());
            final DataStore playerConfig = new DataStore(this.getLogger(), playerData);
            mage.save((ConfigurationSection)playerConfig);
            if (this.initialized) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MagicController.this.saveLock;
                        synchronized (object) {
                            try {
                                playerConfig.save();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
            } else {
                Object object = this.saveLock;
                synchronized (object) {
                    try {
                        playerConfig.save();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if ((wand = mage.getActiveWand()) != null) {
            wand.deactivate();
        }
        mage.deactivateAllSpells(true, true);
        this.mages.remove(mage.getId());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.getActiveWand();
        if (!(wand == null || event.getView().getType() == InventoryType.CRAFTING || wand.getMode() != WandMode.INVENTORY && wand.isInventoryOpen())) {
            wand.deactivate();
        }
    }

    protected ItemStack removeItemFromWand(Wand wand, ItemStack droppedItem) {
        if (wand == null || droppedItem == null || Wand.isWand(droppedItem)) {
            return null;
        }
        if (Wand.isSpell(droppedItem)) {
            String spellKey = Wand.getSpell(droppedItem);
            wand.removeSpell(spellKey);
            SpellTemplate spell = this.getSpellTemplate(spellKey);
            if (spell != null) {
                Wand.updateSpellItem(this.messages, droppedItem, spell, null, null, true);
            }
        } else if (Wand.isBrush(droppedItem)) {
            String brushKey = Wand.getBrush(droppedItem);
            wand.removeBrush(brushKey);
            Wand.updateBrushItem(droppedItem, brushKey, null);
        }
        return droppedItem;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Integer activeSlot;
        boolean isHotbar;
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        GUIAction gui = mage.getActiveGUI();
        if (gui != null) {
            gui.clicked(event);
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && NMSUtils.isTemporary(clickedItem)) {
            String message = NMSUtils.getTemporaryMessage(clickedItem);
            if (message != null && message.length() > 1) {
                mage.sendMessage(message);
            }
            ItemStack replacement = NMSUtils.getReplacement(clickedItem);
            event.setCurrentItem(replacement);
            event.setCancelled(true);
            return;
        }
        ItemStack heldItem = event.getCursor();
        if (heldItem != null && event.getSlotType() == InventoryType.SlotType.ARMOR && (Wand.isSpell(heldItem) || Wand.isWand(heldItem))) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isHotbar = event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD;
        if (event.getAction() == InventoryAction.HOTBAR_SWAP && event.getSlotType() == InventoryType.SlotType.ARMOR) {
            int slot = event.getHotbarButton();
            ItemStack item = mage.getPlayer().getInventory().getItem(slot);
            if (item != null && (Wand.isSpell(item) || Wand.isWand(item))) {
                event.setCancelled(true);
                return;
            }
        }
        Wand activeWand = mage.getActiveWand();
        InventoryType inventoryType = event.getInventory().getType();
        boolean clickedWand = Wand.isWand(clickedItem);
        if (activeWand != null && activeWand.isInventoryOpen()) {
            Material itemType;
            if (Wand.isSpell(clickedItem) && clickedItem.getAmount() != 1) {
                clickedItem.setAmount(1);
            }
            if (clickedWand) {
                event.setCancelled(true);
                activeWand.cycleHotbar(1);
                return;
            }
            if (isHotbar && Wand.isWand(player.getInventory().getItem(event.getHotbarButton()))) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedItem != null && this.wearableMaterials.contains(itemType = clickedItem.getType())) {
                event.setCancelled(true);
                return;
            }
            if (Wand.isWand(event.getCursor())) {
                activeWand.closeInventory();
                event.setCursor(null);
                event.setCancelled(true);
                return;
            }
        } else if (activeWand != null && ((activeSlot = activeWand.getPlayerInventorySlot()) != null && event.getSlot() == activeSlot.intValue() || event.getAction() == InventoryAction.HOTBAR_SWAP && event.getHotbarButton() == activeSlot.intValue())) {
            activeWand.deactivate();
            activeWand = null;
        }
        if (event.getAction() == InventoryAction.DROP_ONE_SLOT) {
            Wand wand;
            if (clickedWand && (wand = new Wand(this, clickedItem)).isUndroppable()) {
                event.setCancelled(true);
                if (activeWand.getHotbars().size() > 1) {
                    activeWand.cycleHotbar(1);
                } else {
                    activeWand.closeInventory();
                }
                return;
            }
            if (activeWand != null && activeWand.isInventoryOpen()) {
                if (!this.spellDroppingEnabled) {
                    event.setCancelled(true);
                    return;
                }
                ItemStack droppedItem = clickedItem;
                ItemStack newDrop = this.removeItemFromWand(activeWand, droppedItem);
                if (newDrop != null) {
                    Location location = player.getLocation();
                    Item item = location.getWorld().dropItem(location, newDrop);
                    item.setVelocity(location.getDirection().normalize());
                } else {
                    event.setCancelled(true);
                }
            }
            return;
        }
        if (activeWand != null) {
            WandMode wandMode = activeWand.getMode();
            if ((wandMode == WandMode.INVENTORY && inventoryType == InventoryType.CRAFTING || wandMode == WandMode.CHEST && inventoryType == InventoryType.CHEST) && activeWand != null && activeWand.isInventoryOpen()) {
                if (event.getAction() == InventoryAction.NOTHING) {
                    int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
                    activeWand.cycleInventory(direction);
                    event.setCancelled(true);
                    return;
                }
                if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                    event.setCancelled(true);
                    return;
                }
                if (event.getAction() == InventoryAction.PICKUP_HALF || wandMode == WandMode.CHEST) {
                    this.onPlayerActivateIcon(mage, activeWand, clickedItem);
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        Wand previousWand;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        GUIAction gui = mage.getActiveGUI();
        if (gui != null) {
            mage.deactivateGUI();
        }
        if ((previousWand = mage.getActiveWand()) != null && previousWand.isInventoryOpen()) {
            if (previousWand.getMode() == WandMode.INVENTORY) {
                previousWand.saveInventory();
                previousWand.updateHotbar();
            } else if (previousWand.getMode() == WandMode.CHEST) {
                previousWand.closeInventory();
            }
        } else {
            if (previousWand != null && player.getInventory().getHeldItemSlot() != previousWand.getPlayerInventorySlot().intValue()) {
                previousWand.deactivate();
                previousWand = null;
            }
            ItemStack currentItem = player.getItemInHand();
            boolean changedWands = false;
            boolean itemIsWand = Wand.isWand(currentItem);
            if (previousWand != null && !itemIsWand) {
                changedWands = true;
            }
            if (previousWand == null && itemIsWand) {
                changedWands = true;
            }
            if (previousWand != null && itemIsWand && !previousWand.getItem().equals((Object)currentItem)) {
                changedWands = true;
            }
            if (changedWands) {
                if (previousWand != null) {
                    previousWand.deactivate();
                }
                if (itemIsWand) {
                    Wand newWand = new Wand(this, currentItem);
                    newWand.activate(mage);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.CREATIVE && this.enableCreativeModeEjecting) {
            boolean ejected = false;
            Player player = event.getPlayer();
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
            if (!(apiMage instanceof Mage)) {
                return;
            }
            Mage mage = (Mage)apiMage;
            Wand activeWand = mage.getActiveWand();
            if (activeWand != null) {
                activeWand.deactivate();
            }
            PlayerInventory inventory = player.getInventory();
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!Wand.isWand(item)) continue;
                ejected = true;
                inventory.setItem(i, null);
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            if (ejected) {
                mage.sendMessage("Ejecting wands, creative mode will destroy them!");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Wand activeWand;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Item item = event.getItem();
        ItemStack pickup = item.getItemStack();
        if (NMSUtils.isTemporary(pickup) || item.hasMetadata("temporary")) {
            item.remove();
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(pickup);
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE && isWand && this.enableCreativeModeEjecting) {
            event.setCancelled(true);
            return;
        }
        if (isWand) {
            Wand wand = new Wand(this, pickup);
            if (!wand.canUse(player)) {
                mage.sendMessage(this.messages.get("wand.bound").replace("$name", wand.getOwner()));
                event.setCancelled(true);
                Item droppedItem = event.getItem();
                Vector velocity = droppedItem.getVelocity();
                velocity.setY(velocity.getY() * 2.0 + 1.0);
                droppedItem.setVelocity(velocity);
                return;
            }
            if (this.removeLostWand(wand.getLostId())) {
                this.plugin.getLogger().info("Player " + mage.getName() + " picked up wand " + wand.getName() + ", id " + wand.getLostId());
            }
            wand.clearLostId();
        }
        if ((activeWand = mage.getActiveWand()) != null && activeWand.isModifiable() && (Wand.isSpell(pickup) || Wand.isBrush(pickup) || Wand.isUpgrade(pickup)) && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (isWand && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(mage);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemStack;
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.hasStoredInventory() || mage.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
        if (Wand.isWand(itemStack = event.getItemInHand()) || Wand.isBrush(itemStack) || Wand.isSpell(itemStack) || Wand.isUpgrade(itemStack)) {
            event.setCancelled(true);
        }
    }

    protected boolean addLostWandMarker(LostWand lostWand) {
        Location location = lostWand.getLocation();
        if (!lostWand.isIndestructible()) {
            return true;
        }
        return this.addMarker("wand-" + lostWand.getId(), "Wands", lostWand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lostWand.getDescription());
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        this.triggerBlockToggle(e.getChunk());
    }

    public void toggleCastCommandOverrides(com.elmakers.mine.bukkit.api.magic.Mage apiMage, boolean override) {
        if (apiMage instanceof Mage) {
            Mage mage = (Mage)apiMage;
            mage.setCostReduction(override ? this.castCommandCostReduction : 0.0f);
            mage.setCooldownReduction(override ? this.castCommandCooldownReduction : 0.0f);
            mage.setPowerMultiplier(override ? this.castCommandPowerMultiplier : 1.0f);
        }
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.wand.LostWand> getLostWands() {
        return new ArrayList<com.elmakers.mine.bukkit.api.wand.LostWand>(this.lostWands.values());
    }

    public Collection<Automaton> getAutomata() {
        ArrayList<Automaton> all = new ArrayList<Automaton>();
        for (Map<Long, Automaton> chunkList : this.automata.values()) {
            all.addAll(chunkList.values());
        }
        return all;
    }

    public boolean cast(com.elmakers.mine.bukkit.api.magic.Mage mage, String spellName, String[] parameters, CommandSender sender, Entity entity) {
        SpellTemplate template;
        Player usePermissions;
        Player player = sender == entity && entity instanceof Player ? (Player)entity : (usePermissions = sender instanceof Player ? (Player)sender : null);
        if (entity == null && sender instanceof Player) {
            entity = (Player)sender;
        }
        Location targetLocation = null;
        if (mage == null) {
            CommandSender mageController;
            Object object = mageController = entity != null && entity instanceof Player ? (Player)entity : sender;
            if (sender != null) {
                if (sender instanceof BlockCommandSender) {
                    targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
                } else if (entity != null && sender != entity) {
                    targetLocation = entity.getLocation();
                }
            }
            mage = mageController == null ? this.getMage(entity) : this.getMage(mageController);
        }
        if (mage != null && targetLocation != null) {
            Location mageLocation = mage.getLocation();
            targetLocation.setPitch(mageLocation.getPitch());
            targetLocation.setYaw(mageLocation.getYaw());
        }
        if ((template = this.getSpellTemplate(spellName)) == null || !template.hasCastPermission((CommandSender)usePermissions)) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        this.toggleCastCommandOverrides(mage, true);
        try {
            spell.cast(parameters, targetLocation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toggleCastCommandOverrides(mage, false);
        if (sender != entity && sender != null) {
            String castMessage = "Cast " + spellName;
            if (entity != null) {
                castMessage = castMessage + " on " + this.getEntityDisplayName(entity);
            }
            sender.sendMessage(castMessage);
        }
        return true;
    }

    public void onCast(com.elmakers.mine.bukkit.api.magic.Mage mage, Spell spell, SpellResult result) {
        if (this.dynmapShowSpells && this.dynmap != null && result.isSuccess()) {
            if (this.dynmapOnlyPlayerSpells && (mage == null || !mage.isPlayer())) {
                return;
            }
            this.dynmap.showCastMarker(mage, spell, result);
        }
        if (result.isSuccess() && this.getShowCastHoloText()) {
            mage.showHoloText(mage.getEyeLocation(), spell.getName(), 10000);
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Messages getMessages() {
        return this.messages;
    }

    @Override
    public MapController getMaps() {
        return this.maps;
    }

    public String getWelcomeWand() {
        return this.welcomeWand;
    }

    protected void triggerBlockToggle(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, Automaton> chunkData = this.automata.get(chunkKey);
        if (chunkData != null) {
            final ArrayList<Automaton> restored = new ArrayList<Automaton>();
            ArrayList<Long> blockKeys = new ArrayList<Long>(chunkData.keySet());
            long timeThreshold = System.currentTimeMillis() - (long)this.toggleCooldown;
            for (Long blockKey : blockKeys) {
                Automaton toggleBlock = chunkData.get(blockKey);
                if (toggleBlock.getCreatedTime() >= timeThreshold) continue;
                Block current = toggleBlock.getBlock();
                if (current.getType() == toggleBlock.getMaterial()) {
                    this.getLogger().info("Resuming block at " + toggleBlock.getPosition() + ": " + toggleBlock.getName() + " with " + toggleBlock.getMaterial());
                    this.redstoneReplacement.modify(current, true);
                    restored.add(toggleBlock);
                }
                chunkData.remove(blockKey);
            }
            if (restored.size() > 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Automaton restoreBlock : restored) {
                            restoreBlock.restore(true);
                        }
                    }
                }, 5L);
            }
            if (chunkData.size() == 0) {
                this.automata.remove(chunkKey);
            }
        }
    }

    public void sendToMages(String message, Location location, int range) {
        int rangeSquared = range * range;
        if (message != null && message.length() > 0) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
                if (!mage.isPlayer() || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(location.getWorld()) || !(mage.getLocation().toVector().distanceSquared(location.toVector()) < (double)rangeSquared)) continue;
                mage.sendMessage(message);
            }
        }
    }

    public boolean getIndestructibleWands() {
        return this.indestructibleWands;
    }

    @Override
    public void forgetMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.forgetMages.put(mage.getId(), System.currentTimeMillis());
    }

    @Override
    public Automaton getAutomaton(Block block) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            return toReload.get(BlockData.getBlockId(block));
        }
        return null;
    }

    public ItemStack createItem(String key) {
        ConfigurationSection template = Wand.getWandTemplate(key);
        if (template == null || !template.contains("icon")) {
            return null;
        }
        MaterialAndData icon = ConfigurationUtils.toMaterialAndData(template.getString("icon"));
        ItemStack item = icon.getItemStack(1);
        ItemMeta meta = item.getItemMeta();
        if (template.contains("name")) {
            meta.setDisplayName(template.getString("name"));
        } else {
            String name = this.messages.get("wands." + key + ".name");
            if (name != null && !name.isEmpty()) {
                meta.setDisplayName(name);
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (template.contains("description")) {
            lore.add(template.getString("description"));
        } else {
            String description = this.messages.get("wands." + key + ".description");
            if (description != null && !description.isEmpty()) {
                lore.add(description);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public boolean isAutomata(Block block) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            return toReload.containsKey(BlockData.getBlockId(block));
        }
        return false;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return entity != null && (entity.hasMetadata("NPC") || entity.hasMetadata("shopkeeper"));
    }

    @Override
    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    @Override
    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public void update(String worldName, BoundingBox area) {
        if (this.dynmap != null && this.dynmapUpdate && area != null && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, area.getMin().getBlockX(), area.getMin().getBlockY(), area.getMin().getBlockZ(), area.getMax().getBlockX(), area.getMax().getBlockY(), area.getMax().getBlockZ());
        }
    }

    @Override
    public void update(BlockList blockList) {
        if (blockList != null) {
            if (blockList.size() > VOLUME_UPDATE_THRESHOLD) {
                this.update(blockList.getWorldName(), blockList.getArea());
            } else {
                for (com.elmakers.mine.bukkit.api.block.BlockData blockData : blockList) {
                    this.updateBlock(blockData.getWorldName(), blockData.getPosition().getBlockX(), blockData.getPosition().getBlockY(), blockData.getPosition().getBlockZ());
                }
            }
        }
    }

    @Override
    public boolean canCreateWorlds() {
        return this.createWorldsEnabled;
    }

    @Override
    public Set<Material> getMaterialSet(String name) {
        if (name.contains(",")) {
            return ConfigurationUtils.parseMaterials(name);
        }
        if (!this.materialSets.containsKey(name)) {
            return ConfigurationUtils.parseMaterials(name);
        }
        return this.materialSets.get(name);
    }

    @Override
    public int getMaxY() {
        return 255;
    }

    @Override
    public void sendToMages(String message, Location location) {
        this.sendToMages(message, location, this.toggleMessageRange);
    }

    @Override
    public void registerAutomata(Block block, String name, String message) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload == null) {
            toReload = new HashMap<Long, Automaton>();
            this.automata.put(chunkId, toReload);
        }
        Automaton data = new Automaton(block, name, message);
        toReload.put(data.getId(), data);
    }

    @Override
    public boolean unregisterAutomata(Block block) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            toReload.remove(BlockData.getBlockId(block));
        }
        return toReload != null;
    }

    @Override
    public int getMaxUndoPersistSize() {
        return this.undoMaxPersistSize;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> mageInterfaces = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.mages.values());
        return mageInterfaces;
    }

    @Override
    public Set<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    @Override
    public Set<Material> getDestructibleMaterials() {
        return this.destructibleMaterials;
    }

    @Override
    public Set<Material> getRestrictedMaterials() {
        return this.restrictedMaterials;
    }

    @Override
    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    @Override
    public boolean isMage(Entity entity) {
        if (entity == null) {
            return false;
        }
        return this.mages.containsKey(entity.getUniqueId().toString());
    }

    @Override
    public Collection<String> getMaterialSets() {
        return this.materialSets.keySet();
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        List worlds = Bukkit.getWorlds();
        for (World world : worlds) {
            List players = world.getPlayers();
            for (Player player : players) {
                if (this.isNPC((Entity)player)) continue;
                playerNames.add(player.getName());
            }
        }
        return playerNames;
    }

    @Override
    public void disablePhysics(int interval) {
        if (this.physicsHandler == null && interval > 0) {
            this.physicsHandler = new PhysicsHandler(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.physicsHandler, (Plugin)this.plugin);
        }
        if (this.physicsHandler != null) {
            this.physicsHandler.setInterval(interval);
        }
    }

    @Override
    public boolean commitAll() {
        boolean undid = false;
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            undid = mage.commit() || undid;
        }
        return undid;
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (this.bypassPvpPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_pvp")) {
            return true;
        }
        if (location == null && player != null) {
            location = player.getLocation();
        }
        return this.worldGuardManager.isPVPAllowed(player, location) && this.pvpManager.isPVPAllowed(player) && this.multiverseManager.isPVPAllowed(location.getWorld()) && this.preciousStonesManager.isPVPAllowed(player, location) && this.townyManager.isPVPAllowed(location);
    }

    @Override
    public Location getWarp(String warpName) {
        Location location = null;
        if (this.warpController != null) {
            try {
                location = this.warpController.getWarp(warpName);
            }
            catch (Exception ex) {
                location = null;
            }
        }
        return location;
    }

    @Override
    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList undoAny(Block target) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            com.elmakers.mine.bukkit.api.block.UndoList undid = mage.undo(target);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList undoRecent(Block target, int timeout) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            UndoQueue queue = mage.getUndoQueue();
            com.elmakers.mine.bukkit.api.block.UndoList undid = queue.undoRecent(target, timeout);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    public CitizensController getCitizens() {
        return this.citizens;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(String wandKey) {
        return Wand.createWand(this, wandKey);
    }

    @Override
    public boolean elementalsEnabled() {
        return this.elementals != null;
    }

    @Override
    public boolean createElemental(Location location, String templateName, CommandSender creator) {
        return this.elementals.createElemental(location, templateName, creator);
    }

    @Override
    public boolean isElemental(Entity entity) {
        if (this.elementals == null || entity.getType() != EntityType.FALLING_BLOCK) {
            return false;
        }
        return this.elementals.isElemental(entity);
    }

    @Override
    public boolean damageElemental(Entity entity, double damage, int fireTicks, CommandSender attacker) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.damageElemental(entity, damage, fireTicks, attacker);
    }

    @Override
    public boolean setElementalScale(Entity entity, double scale) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.setElementalScale(entity, scale);
    }

    @Override
    public double getElementalScale(Entity entity) {
        if (this.elementals == null) {
            return 0.0;
        }
        return this.elementals.getElementalScale(entity);
    }

    @Override
    public com.elmakers.mine.bukkit.api.spell.SpellCategory getCategory(String key) {
        SpellCategory category = this.categories.get(key);
        if (category == null) {
            category = new SpellCategory(key, this);
            this.categories.put(key, category);
        }
        return category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.SpellCategory> getCategories() {
        ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory> allCategories = new ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory>();
        allCategories.addAll(this.categories.values());
        return allCategories;
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        ArrayList<SpellTemplate> allSpells = new ArrayList<SpellTemplate>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    @Override
    public SpellTemplate getSpellTemplate(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        SpellTemplate spell = this.spells.get(name);
        if (spell == null) {
            spell = this.spellAliases.get(name);
        }
        return spell;
    }

    @Override
    public String getEntityName(Entity target) {
        return this.getEntityName(target, false);
    }

    @Override
    public String getEntityDisplayName(Entity target) {
        return this.getEntityName(target, true);
    }

    protected String getEntityName(Entity target, boolean display) {
        if (target == null) {
            return "Unknown";
        }
        if (target instanceof Player) {
            return display ? ((Player)target).getDisplayName() : ((Player)target).getName();
        }
        if (this.isElemental(target)) {
            return "Elemental";
        }
        if (display) {
            if (target instanceof LivingEntity) {
                LivingEntity li = (LivingEntity)target;
                String customName = li.getCustomName();
                if (customName != null && customName.length() > 0) {
                    return customName;
                }
            } else if (target instanceof Item) {
                ItemMeta meta;
                Item item = (Item)target;
                ItemStack itemStack = item.getItemStack();
                if (itemStack.hasItemMeta() && (meta = itemStack.getItemMeta()).hasDisplayName()) {
                    return meta.getDisplayName();
                }
                MaterialAndData material = new MaterialAndData(itemStack);
                return material.getName();
            }
        }
        return target.getType().name().toLowerCase().replace('_', ' ');
    }

    public boolean getShowCastHoloText() {
        return this.showCastHoloText;
    }

    public boolean getShowActivateHoloText() {
        return this.showActivateHoloText;
    }

    public int getCastHoloTextRange() {
        return this.castHoloTextRange;
    }

    public int getActiveHoloTextRange() {
        return this.activateHoloTextRange;
    }

    public boolean isInventoryBackupEnabled() {
        return this.backupInventory;
    }

    public ItemStack getSpellBook(com.elmakers.mine.bukkit.api.spell.SpellCategory category, int count) {
        HashMap<String, ArrayList<SpellTemplate>> categories = new HashMap<String, ArrayList<SpellTemplate>>();
        Collection<SpellTemplate> spellVariants = this.spells.values();
        String categoryKey = category == null ? null : category.getKey();
        for (SpellTemplate spell : spellVariants) {
            com.elmakers.mine.bukkit.api.spell.SpellCategory spellCategory;
            if (spell.isHidden() || spell.getSpellKey().isVariant() || (spellCategory = spell.getCategory()) == null) continue;
            String spellCategoryKey = spellCategory.getKey();
            if (categoryKey != null && !spellCategoryKey.equalsIgnoreCase(categoryKey)) continue;
            ArrayList<SpellTemplate> categorySpells = (ArrayList<SpellTemplate>)categories.get(spellCategoryKey);
            if (categorySpells == null) {
                categorySpells = new ArrayList<SpellTemplate>();
                categories.put(spellCategoryKey, categorySpells);
            }
            categorySpells.add(spell);
        }
        ArrayList categoryKeys = new ArrayList(categories.keySet());
        Collections.sort(categoryKeys);
        CostReducer reducer = null;
        ItemStack bookItem = new ItemStack(Material.WRITTEN_BOOK, count);
        BookMeta book = (BookMeta)bookItem.getItemMeta();
        book.setAuthor(this.messages.get("books.default.author"));
        String title = null;
        title = category != null ? this.messages.get("books.default.title").replace("$category", category.getName()) : this.messages.get("books.all.title");
        book.setTitle(title);
        ArrayList<String> pages = new ArrayList<String>();
        Set<String> paths = WandUpgradePath.getPathKeys();
        for (String key : categoryKeys) {
            category = this.getCategory(key);
            title = this.messages.get("books.default.title").replace("$category", category.getName());
            String description = "" + ChatColor.BOLD + ChatColor.BLUE + title + "\n\n";
            description = description + "" + ChatColor.RESET + ChatColor.DARK_BLUE + category.getDescription();
            pages.add(description);
            List categorySpells = (List)categories.get(key);
            Collections.sort(categorySpells);
            for (SpellTemplate spell : categorySpells) {
                String spellExtendedDescription;
                String usage;
                long duration;
                WandUpgradePath checkPath;
                Collection<CastingCost> activeCosts;
                Collection<CastingCost> costs;
                String spellCooldownDescription;
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("" + ChatColor.GOLD + ChatColor.BOLD + spell.getName());
                lines.add("" + ChatColor.RESET);
                String spellDescription = spell.getDescription();
                if (spellDescription != null && spellDescription.length() > 0) {
                    lines.add("" + ChatColor.BLACK + spellDescription);
                    lines.add("");
                }
                if ((spellCooldownDescription = spell.getCooldownDescription()) != null && spellCooldownDescription.length() > 0) {
                    spellCooldownDescription = this.messages.get("cooldown.description").replace("$time", spellCooldownDescription);
                    lines.add("" + ChatColor.DARK_PURPLE + spellCooldownDescription);
                }
                if ((costs = spell.getCosts()) != null) {
                    for (CastingCost cost : costs) {
                        if (!cost.hasCosts(reducer)) continue;
                        lines.add(ChatColor.DARK_PURPLE + this.messages.get("wand.costs_description").replace("$description", cost.getFullDescription(this.messages, reducer)));
                    }
                }
                if ((activeCosts = spell.getActiveCosts()) != null) {
                    for (CastingCost cost : activeCosts) {
                        if (!cost.hasCosts(reducer)) continue;
                        lines.add(ChatColor.DARK_PURPLE + this.messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(this.messages, reducer)));
                    }
                }
                for (String pathKey : paths) {
                    checkPath = WandUpgradePath.getPath(pathKey);
                    if (checkPath.isHidden() || !checkPath.hasSpell(spell.getKey())) continue;
                    lines.add(ChatColor.DARK_BLUE + this.messages.get("spell.available_path").replace("$path", checkPath.getName()));
                    break;
                }
                for (String pathKey : paths) {
                    checkPath = WandUpgradePath.getPath(pathKey);
                    if (!checkPath.requiresSpell(spell.getKey())) continue;
                    lines.add(ChatColor.DARK_RED + this.messages.get("spell.required_path").replace("$path", checkPath.getName()));
                    break;
                }
                if ((duration = spell.getDuration()) > 0L) {
                    long seconds = duration / 1000L;
                    if (seconds > 3600L) {
                        long hours = seconds / 3600L;
                        lines.add(ChatColor.DARK_GREEN + this.messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString()));
                    } else if (seconds > 60L) {
                        long minutes = seconds / 60L;
                        lines.add(ChatColor.DARK_GREEN + this.messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                    } else {
                        lines.add(ChatColor.DARK_GREEN + this.messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                    }
                } else if (spell.isUndoable()) {
                    lines.add(ChatColor.GRAY + this.messages.get("spell.undoable"));
                }
                if (spell.usesBrush()) {
                    lines.add(ChatColor.DARK_GRAY + this.messages.get("spell.brush"));
                }
                SpellKey baseKey = spell.getSpellKey();
                SpellKey upgradeKey = new SpellKey(baseKey.getBaseKey(), baseKey.getLevel() + 1);
                SpellTemplate upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
                int spellLevels = 0;
                while (upgradeSpell != null) {
                    ++spellLevels;
                    upgradeKey = new SpellKey(upgradeKey.getBaseKey(), upgradeKey.getLevel() + 1);
                    upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
                }
                if (spellLevels > 0) {
                    lines.add(ChatColor.DARK_AQUA + this.messages.get("spell.levels_available").replace("$levels", Integer.toString(++spellLevels)));
                }
                if ((usage = spell.getUsage()) != null && usage.length() > 0) {
                    lines.add("" + ChatColor.GRAY + ChatColor.ITALIC + usage + ChatColor.RESET);
                    lines.add("");
                }
                if ((spellExtendedDescription = spell.getExtendedDescription()) != null && spellExtendedDescription.length() > 0) {
                    lines.add("" + ChatColor.BLACK + spellExtendedDescription);
                    lines.add("");
                }
                pages.add(StringUtils.join(lines, (String)"\n"));
            }
        }
        book.setPages(pages);
        bookItem.setItemMeta((ItemMeta)book);
        return bookItem;
    }

    @Override
    public MaterialAndData getRedstoneReplacement() {
        return this.redstoneReplacement;
    }

    @Override
    public boolean isUrlIconsEnabled() {
        return this.urlIconsEnabled && NMSUtils.hasURLSkullSupport();
    }
}

