/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.batch;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Automaton;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.BrushBatch;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.material.Button;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PoweredRail;
import org.bukkit.material.RedstoneWire;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class ConstructBatch
extends BrushBatch {
    private final Location center;
    private Vector orient = null;
    private final int radius;
    private final ConstructionType type;
    private final int thickness;
    private final boolean spawnFallingBlocks;
    private float fallingBlockSpeed = 0.0f;
    private Vector fallingDirection = null;
    private final Map<Long, BlockData> attachedBlockMap = new HashMap<Long, BlockData>();
    private final List<BlockData> attachedBlockList = new ArrayList<BlockData>();
    private final List<BlockData> delayedBlocks = new ArrayList<BlockData>();
    private final Set<Material> attachables;
    private final Set<Material> attachablesWall;
    private final Set<Material> attachablesDouble;
    private final Set<Material> delayed;
    private Set<String> replace;
    private Map<String, String> commandMap;
    private Map<String, String> signMap;
    private boolean finishedNonAttached = false;
    private boolean finishedAttached = false;
    private int attachedBlockIndex = 0;
    private int delayedBlockIndex = 0;
    private Integer maxOrientDimension = null;
    private Integer minOrientDimension = null;
    private boolean power = false;
    private boolean commit = false;
    private int breakable = 0;
    private double backfireChance = 0.0;
    private Vector bounds = null;
    private boolean applyPhysics = false;
    private int x = 0;
    private int y = 0;
    private int z = 0;
    private int r = 0;
    private boolean limitYAxis = false;

    public ConstructBatch(BrushSpell spell, Location center, ConstructionType type, int radius, int thickness, boolean spawnFallingBlocks, Vector orientVector) {
        super(spell);
        this.center = center;
        this.radius = radius;
        this.type = type;
        this.thickness = thickness;
        this.spawnFallingBlocks = spawnFallingBlocks;
        this.attachables = this.mage.getController().getMaterialSet("attachable");
        this.attachablesWall = this.mage.getController().getMaterialSet("attachable_wall");
        this.attachablesDouble = this.mage.getController().getMaterialSet("attachable_double");
        this.delayed = this.mage.getController().getMaterialSet("delayed");
        this.orient = orientVector == null ? new Vector(0, 1, 0) : orientVector;
    }

    public void setBounds(Vector bounds) {
        this.bounds = bounds;
    }

    public void setPower(boolean power) {
        this.power = power;
        this.undoList.setApplyPhysics(true);
    }

    public void setBackfireChance(double backfireChance) {
        this.backfireChance = backfireChance;
    }

    public void setBreakable(int breakable) {
        this.breakable = breakable;
    }

    public void setFallingBlockSpeed(float speed) {
        this.fallingBlockSpeed = speed;
    }

    public void setFallingDirection(Vector direction) {
        this.fallingDirection = direction;
    }

    public void setOrientDimensionMax(int maxDim) {
        this.maxOrientDimension = maxDim;
    }

    public void setOrientDimensionMin(int minDim) {
        this.minOrientDimension = minDim;
    }

    protected boolean canAttachTo(Material attachMaterial, Material material, boolean vertical) {
        if (vertical && attachMaterial == material) {
            return true;
        }
        if (material.isTransparent()) {
            return false;
        }
        return !this.attachables.contains(material) && !this.attachablesWall.contains(material) && !this.attachablesDouble.contains(material);
    }

    @Override
    public int size() {
        return this.radius * this.radius * this.radius * 8;
    }

    @Override
    public int remaining() {
        if (this.r >= this.radius) {
            return 0;
        }
        return (this.radius - this.r) * (this.radius - this.r) * (this.radius - this.r) * 8;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks;
        block24: {
            block26: {
                block25: {
                    processedBlocks = 0;
                    if (!this.finishedAttached) break block25;
                    if (this.delayedBlockIndex >= this.delayedBlocks.size()) {
                        this.finish();
                    } else {
                        while (this.delayedBlockIndex < this.delayedBlocks.size() && processedBlocks < maxBlocks) {
                            BlockData delayed = this.delayedBlocks.get(this.delayedBlockIndex);
                            Block block = delayed.getBlock();
                            if (!block.getChunk().isLoaded()) {
                                block.getChunk().load();
                                return processedBlocks;
                            }
                            this.modifyWith(block, delayed);
                            ++this.delayedBlockIndex;
                        }
                    }
                    break block24;
                }
                if (!this.finishedNonAttached) break block26;
                while (this.attachedBlockIndex < this.attachedBlockList.size() && processedBlocks < maxBlocks) {
                    boolean canAttachToWall;
                    BlockData attach = this.attachedBlockList.get(this.attachedBlockIndex);
                    Block block = attach.getBlock();
                    if (!block.getChunk().isLoaded()) {
                        block.getChunk().load();
                        return processedBlocks;
                    }
                    Block underneath = block.getRelative(BlockFace.DOWN);
                    Material material = attach.getMaterial();
                    boolean ok = this.canAttachTo(material, underneath.getType(), true);
                    if (!ok && this.attachablesDouble.contains(material)) {
                        BlockData attachedUnder = this.attachedBlockMap.get(BlockData.getBlockId(underneath));
                        boolean bl = ok = attachedUnder != null && attachedUnder.getMaterial() == material;
                        if (!ok) {
                            Block above = block.getRelative(BlockFace.UP);
                            BlockData attachedAbove = this.attachedBlockMap.get(BlockData.getBlockId(above));
                            boolean bl2 = ok = attachedAbove != null && attachedAbove.getMaterial() == material;
                        }
                    }
                    if (!ok && (canAttachToWall = this.attachablesWall.contains(material))) {
                        BlockFace[] faces;
                        for (BlockFace face : faces = new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH}) {
                            if (!this.canAttachTo(material, block.getRelative(face).getType(), false)) continue;
                            ok = true;
                            break;
                        }
                    }
                    if (ok) {
                        this.modifyWith(block, attach);
                    }
                    ++this.attachedBlockIndex;
                }
                if (this.attachedBlockIndex < this.attachedBlockList.size()) break block24;
                this.finishedAttached = true;
                break block24;
            }
            int yBounds = this.radius;
            if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockY() > 0) {
                this.limitYAxis = true;
                yBounds = Math.max(this.minOrientDimension == null ? this.radius : this.minOrientDimension, this.maxOrientDimension == null ? this.radius : this.maxOrientDimension);
            }
            if (this.bounds != null) {
                yBounds = Math.min(yBounds, (int)this.bounds.getY());
            }
            yBounds = Math.min(yBounds, this.controller.getMaxY());
            while (processedBlocks <= maxBlocks && !this.finishedNonAttached) {
                if (!this.fillBlock(this.x, this.y, this.z)) {
                    return processedBlocks;
                }
                int xBounds = this.r;
                int zBounds = this.r;
                if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockX() > 0) {
                    xBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                }
                if (this.bounds != null) {
                    xBounds = Math.min(xBounds, (int)this.bounds.getX());
                }
                ++this.y;
                if (this.y > yBounds) {
                    this.y = 0;
                    if (this.x < xBounds) {
                        ++this.x;
                    } else {
                        --this.z;
                        if (this.z < 0) {
                            ++this.r;
                            zBounds = this.r;
                            if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockZ() > 0) {
                                zBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                            }
                            if (this.bounds != null) {
                                zBounds = Math.min(zBounds, (int)this.bounds.getZ());
                            }
                            this.z = zBounds;
                            this.x = 0;
                        }
                    }
                }
                if (this.r > this.radius || this.bounds != null && (double)this.r > this.bounds.getZ() && (double)this.r > this.bounds.getX()) {
                    this.finishedNonAttached = true;
                    break;
                }
                ++processedBlocks;
            }
        }
        return processedBlocks;
    }

    public boolean fillBlock(int x, int y, int z) {
        boolean fillBlock = false;
        switch (this.type) {
            case SPHERE: {
                int maxDistanceSquared = this.radius * this.radius;
                float mx = (float)x - 0.1f;
                float my = (float)y - 0.1f;
                float mz = (float)z - 0.1f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.thickness == 0) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared - this.thickness && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.thickness == 0) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x <= elevation && x >= elevation - this.thickness && z <= elevation || z <= elevation && z >= elevation - this.thickness && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.thickness == 0 ? true : x > this.radius - this.thickness || y > this.radius - this.thickness || z > this.radius - this.thickness;
            }
        }
        boolean success = true;
        if (fillBlock) {
            if (y != 0) {
                boolean bl = success = success && this.constructBlock(x, -y, z);
                if (x != 0) {
                    boolean bl2 = success = success && this.constructBlock(-x, -y, z);
                }
                if (z != 0) {
                    boolean bl3 = success = success && this.constructBlock(x, -y, -z);
                }
                if (x != 0 && z != 0) {
                    success = success && this.constructBlock(-x, -y, -z);
                }
            }
            boolean bl = success = success && this.constructBlock(x, y, z);
            if (x != 0) {
                boolean bl4 = success = success && this.constructBlock(-x, y, z);
            }
            if (z != 0) {
                boolean bl5 = success = success && this.constructBlock(x, y, -z);
            }
            if (z != 0 && x != 0) {
                success = success && this.constructBlock(-x, y, -z);
            }
        }
        return success;
    }

    public boolean constructBlock(int dx, int dy, int dz) {
        MaterialAndData check;
        if (this.limitYAxis && this.minOrientDimension != null && dy < -this.minOrientDimension.intValue()) {
            return true;
        }
        if (this.limitYAxis && this.maxOrientDimension != null && dy > this.maxOrientDimension) {
            return true;
        }
        if (this.bounds != null) {
            if ((double)dx > this.bounds.getX() || (double)dy > this.bounds.getY() || (double)dz > this.bounds.getZ()) {
                return true;
            }
            if ((double)dx < -this.bounds.getX() || (double)dy < -this.bounds.getY() || (double)dz < -this.bounds.getZ()) {
                return true;
            }
        }
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > this.controller.getMaxY()) {
            return true;
        }
        Block block = this.center.getWorld().getBlockAt(x, y, z);
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        if (!this.spell.isDestructible(block)) {
            return true;
        }
        if (this.replace != null && this.replace.size() > 0 && !this.replace.contains((check = new MaterialAndData(block)).getKey())) {
            return true;
        }
        if (!this.spell.hasBuildPermission(block)) {
            return true;
        }
        if (this.power) {
            Material material = block.getType();
            BlockState blockState = block.getState();
            MaterialData data = blockState.getData();
            boolean powerBlock = false;
            if (data instanceof Button) {
                Button powerData = (Button)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof Lever) {
                Lever powerData = (Lever)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof PistonBaseMaterial) {
                PistonBaseMaterial powerData = (PistonBaseMaterial)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof PoweredRail) {
                PoweredRail powerData = (PoweredRail)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof RedstoneWire) {
                RedstoneWire wireData = (RedstoneWire)data;
                this.registerForUndo(block);
                wireData.setData((byte)(15 - wireData.getData()));
                powerBlock = true;
            } else if (material == Material.REDSTONE_BLOCK) {
                Automaton automaton = this.controller.getAutomaton(block);
                if (automaton == null || automaton.getCreatedTime() < System.currentTimeMillis() - 30000L) {
                    this.registerForUndo(block);
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, material.getId());
                    this.controller.getRedstoneReplacement().modify(block, this.applyPhysics);
                }
            } else if (material == Material.REDSTONE_TORCH_OFF) {
                this.registerForUndo(block);
                block.setType(Material.REDSTONE_TORCH_ON);
            } else if (material == Material.REDSTONE_TORCH_ON) {
                this.registerForUndo(block);
                block.setType(Material.REDSTONE_TORCH_OFF);
            } else if (material == Material.TNT) {
                this.registerForUndo(block);
                block.setType(Material.AIR);
                this.registerForUndo(block.getLocation().getWorld().spawnEntity(block.getLocation(), EntityType.PRIMED_TNT));
            }
            if (powerBlock) {
                blockState.update();
            }
            return true;
        }
        MaterialBrush brush = this.spell.getBrush();
        brush.update(this.mage, block.getLocation());
        if (!brush.isReady()) {
            brush.prepare();
            return false;
        }
        if (this.attachables.contains(brush.getMaterial()) || this.attachablesWall.contains(brush.getMaterial()) || this.attachablesDouble.contains(brush.getMaterial())) {
            BlockData attachBlock = new BlockData(block);
            attachBlock.updateFrom(brush);
            this.attachedBlockMap.put(attachBlock.getId(), attachBlock);
            this.attachedBlockList.add(attachBlock);
            return true;
        }
        if (this.delayed.contains(brush.getMaterial())) {
            BlockData delayBlock = new BlockData(block);
            delayBlock.updateFrom(brush);
            this.delayedBlocks.add(delayBlock);
            return true;
        }
        this.modifyWith(block, brush);
        return true;
    }

    protected void modifyWith(Block block, com.elmakers.mine.bukkit.api.block.MaterialAndData brush) {
        Material previousMaterial = block.getType();
        byte previousData = block.getData();
        if (brush.isValid() && (brush.isDifferent(block) || this.commit)) {
            String[] lines;
            String commandKey;
            if (!this.commit) {
                this.registerForUndo(block);
            }
            if (this.commandMap != null && brush.getMaterial() == Material.COMMAND && (commandKey = brush.getCommandLine()) != null && commandKey.length() > 0 && this.commandMap.containsKey(commandKey)) {
                brush.setCommandLine(this.commandMap.get(commandKey));
            }
            if (!(this.signMap == null || brush.getMaterial() != Material.SIGN_POST && brush.getMaterial() != Material.WALL_SIGN || (lines = brush.getSignLines()) == null || lines.length <= 0 || this.signMap.isEmpty())) {
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (line == null || line.length() <= 0 || !this.signMap.containsKey(line)) continue;
                    lines[i] = this.signMap.get(line);
                }
                brush.setSignLines(lines);
            }
            brush.modify(block, this.applyPhysics);
            if (this.breakable > 0) {
                block.setMetadata("breakable", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)this.breakable));
            }
            if (this.backfireChance > 0.0) {
                block.setMetadata("backfire", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)this.backfireChance));
            }
            if (this.spawnFallingBlocks) {
                FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                falling.setDropItem(false);
                if (this.fallingBlockSpeed != 0.0f) {
                    Vector direction = this.fallingDirection != null ? this.fallingDirection : falling.getLocation().subtract(this.center).toVector();
                    direction = direction.normalize().multiply(this.fallingBlockSpeed);
                    falling.setVelocity(direction);
                }
                this.registerForUndo((Entity)falling);
            }
            if (this.commit) {
                com.elmakers.mine.bukkit.api.block.BlockData blockData = UndoList.register(block);
                blockData.commit();
            }
        }
    }

    public void addCommandMapping(String key, String command) {
        if (this.commandMap == null) {
            this.commandMap = new HashMap<String, String>();
        }
        this.commandMap.put(key, command);
    }

    public void addSignMapping(String key, String text) {
        if (this.signMap == null) {
            this.signMap = new HashMap<String, String>();
        }
        this.signMap.put(key, text);
    }

    public void setReplace(Collection<com.elmakers.mine.bukkit.api.block.MaterialAndData> replace) {
        this.replace = new HashSet<String>();
        for (com.elmakers.mine.bukkit.api.block.MaterialAndData material : replace) {
            this.replace.add(material.getKey());
        }
    }

    @Override
    protected boolean contains(Location location) {
        if (this.thickness != 0) {
            return false;
        }
        if (!location.getWorld().equals(this.center.getWorld())) {
            return false;
        }
        switch (this.type) {
            case SPHERE: {
                int radiusSquared = this.radius * this.radius;
                return location.distanceSquared(this.center) <= (double)radiusSquared;
            }
        }
        return location.getBlockX() >= this.center.getBlockX() - this.radius && location.getBlockX() <= this.center.getBlockX() + this.radius && location.getBlockY() >= this.center.getBlockY() - this.radius && location.getBlockY() <= this.center.getBlockY() + this.radius && location.getBlockZ() >= this.center.getBlockZ() - this.radius && location.getBlockZ() <= this.center.getBlockZ() + this.radius;
    }

    public void setApplyPhysics(boolean physics) {
        this.applyPhysics = physics;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }
}

