/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HatAction
extends BaseSpellAction {
    @Override
    public SpellResult perform(CastContext context) {
        Block targetBlock;
        boolean usesBrush;
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            entity = context.getEntity();
        }
        com.elmakers.mine.bukkit.api.block.MaterialAndData material = context.getBrush();
        boolean bl = usesBrush = context.getSpell().usesBrush() || context.getSpell().hasBrushOverride();
        if (!(material != null && usesBrush || (targetBlock = context.getTargetBlock()) == null)) {
            material = new MaterialAndData(targetBlock);
        }
        if (entity == null || !(entity instanceof Player) || material == null || material.getMaterial() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)entity;
        ItemStack hatItem = material.getItemStack(1);
        ItemMeta meta = hatItem.getItemMeta();
        meta.setDisplayName(context.getMessage("hat_name").replace("$material", material.getName()));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(context.getMessage("hat_lore"));
        meta.setLore(lore);
        hatItem.setItemMeta(meta);
        hatItem = InventoryUtils.makeReal(hatItem);
        NMSUtils.makeTemporary(hatItem, context.getMessage("removed").replace("$material", material.getName()));
        ItemStack itemStack = player.getInventory().getHelmet();
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            if (NMSUtils.isTemporary(itemStack)) {
                itemStack = NMSUtils.getReplacement(itemStack);
            }
            if (itemStack != null) {
                Bukkit.getLogger().info("Setting replacement: " + itemStack);
                NMSUtils.setReplacement(hatItem, itemStack);
            }
        }
        player.getInventory().setHelmet(hatItem);
        context.registerForUndo(new HatUndoAction(player));
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class HatUndoAction
    implements Runnable {
        private final Player player;

        public HatUndoAction(Player player) {
            this.player = player;
        }

        @Override
        public void run() {
            ItemStack helmetItem = this.player.getInventory().getHelmet();
            if (NMSUtils.isTemporary(helmetItem)) {
                ItemStack replacement = NMSUtils.getReplacement(helmetItem);
                this.player.getInventory().setHelmet(replacement);
            }
        }
    }
}

