/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class ConeOfEffectAction
extends CompoundAction {
    private int targetCount;
    private boolean useHitbox;
    private double range;
    private double fov;
    private double closeRange;
    private double closeFOV;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetCount = parameters.getInt("target_count", -1);
        this.useHitbox = parameters.getBoolean("hitbox", false);
        this.range = parameters.getInt("range", 32);
        this.fov = parameters.getDouble("fov", 0.3);
        this.closeRange = parameters.getDouble("close_range", 1.0);
        this.closeFOV = 0.5;
        if (parameters.contains("fov")) {
            this.closeFOV = this.fov;
        }
        this.closeFOV = parameters.getDouble("close_fov", this.closeFOV);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Spell spell = context.getSpell();
        if (!(spell instanceof TargetingSpell)) {
            return SpellResult.FAIL;
        }
        List<Target> entities = ((TargetingSpell)spell).getAllTargetEntities(context.getLocation(), context.getEntity(), this.range, this.fov, this.closeRange, this.closeFOV, this.useHitbox);
        if (this.targetCount < 0) {
            this.targetCount = entities.size();
        }
        SpellResult result = SpellResult.NO_TARGET;
        CastContext actionContext = this.createContext(context);
        for (int i = 0; i < this.targetCount && i < entities.size(); ++i) {
            Target target = entities.get(i);
            actionContext.setTargetEntity(target.getEntity());
            actionContext.setTargetLocation(target.getLocation());
            SpellResult entityResult = this.performActions(actionContext);
            result = result.min(entityResult);
        }
        return result;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("fov");
        parameters.add("target_count");
        parameters.add("hitbox");
        parameters.add("range");
        parameters.add("close_range");
        parameters.add("close_fov");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("hitbox")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("target_count") || parameterKey.equals("range") || parameterKey.equals("fov") || parameterKey.equals("close_range") || parameterKey.equals("close_fov")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

