/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CommandAction
extends BaseSpellAction {
    public static final String[] PARAMETERS = new String[]{"command", "console", "op", "radius"};
    private List<String> commands = new ArrayList<String>();
    private boolean asConsole;
    private boolean opPlayer;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.asConsole = parameters.getBoolean("console", false);
        this.opPlayer = parameters.getBoolean("op", false);
    }

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.commands.clear();
        if (parameters.contains("command")) {
            String command = parameters.getString("command");
            if (command != null && command.length() > 0) {
                this.commands.add(command);
            }
        } else {
            this.commands.addAll(parameters.getStringList("commands"));
        }
    }

    protected String parameterize(CastContext context, String command) {
        Entity targetEntity;
        Location targetLocation;
        Location location = context.getLocation();
        Mage mage = context.getMage();
        MageController controller = context.getController();
        command = command.replace("@_", " ").replace("@spell", context.getSpell().getName()).replace("@pd", mage.getDisplayName()).replace("@pn", mage.getName()).replace("@uuid", mage.getId());
        if (location != null) {
            command = command.replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
        }
        if ((targetLocation = context.getTargetLocation()) != null) {
            command = command.replace("@tworld", targetLocation.getWorld().getName()).replace("@tx", Double.toString(targetLocation.getX())).replace("@ty", Double.toString(targetLocation.getY())).replace("@tz", Double.toString(targetLocation.getZ()));
        }
        if ((targetEntity = context.getTargetEntity()) != null) {
            if (controller.isMage(targetEntity)) {
                Mage targetMage = controller.getMage(targetEntity);
                command = command.replace("@td", targetMage.getDisplayName()).replace("@tn", targetMage.getName()).replace("@tuuid", targetMage.getId());
            } else {
                command = command.replace("@td", controller.getEntityDisplayName(targetEntity)).replace("@tn", controller.getEntityName(targetEntity)).replace("@tuuid", targetEntity.getUniqueId().toString());
            }
        }
        return command;
    }

    @Override
    public SpellResult perform(CastContext context) {
        ConsoleCommandSender sender;
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Object object = sender = this.asConsole ? Bukkit.getConsoleSender() : mage.getCommandSender();
        if (sender == null) {
            return SpellResult.FAIL;
        }
        boolean isOp = sender.isOp();
        if (this.opPlayer && !isOp) {
            sender.setOp(true);
        }
        for (String command : this.commands) {
            try {
                String converted = this.parameterize(context, command);
                controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, converted);
            }
            catch (Exception ex) {
                controller.getLogger().log(Level.WARNING, "Error running command: " + command, ex);
            }
        }
        if (this.opPlayer && !isOp) {
            sender.setOp(false);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.addAll(Arrays.asList(PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("command")) {
            examples.add("spawn");
            examples.add("clear");
        } else if (parameterKey.equals("op") || parameterKey.equals("console")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }
}

