/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AllEntitiesAction
extends CompoundAction {
    private boolean targetSelf;
    private boolean targetAllWorlds;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetSelf = parameters.getBoolean("target_self", false);
        this.targetAllWorlds = parameters.getBoolean("target_all_worlds", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpellResult result;
        block8: {
            ArrayList<World> worlds;
            CastContext actionContext;
            Location sourceLocation;
            Entity sourceEntity;
            Spell spell;
            block7: {
                Player[] players;
                spell = context.getSpell();
                sourceEntity = context.getEntity();
                sourceLocation = context.getLocation();
                if (sourceLocation == null && !this.targetAllWorlds) {
                    return SpellResult.LOCATION_REQUIRED;
                }
                Class<Player> targetType = Player.class;
                if (spell instanceof TargetingSpell) {
                    targetType = ((TargetingSpell)spell).getTargetEntityType();
                }
                result = SpellResult.NO_TARGET;
                actionContext = this.createContext(context);
                if (targetType != Player.class) break block7;
                for (Player player : players = Bukkit.getOnlinePlayers()) {
                    if (!this.targetSelf && player == sourceEntity || !this.targetAllWorlds && (sourceLocation == null || !sourceLocation.getWorld().equals(player.getWorld())) || !spell.canTarget((Entity)player)) continue;
                    actionContext.setTargetEntity((Entity)player);
                    actionContext.setTargetLocation(player.getLocation());
                    SpellResult entityResult = this.performActions(actionContext);
                    result = result.min(entityResult);
                }
                break block8;
            }
            if (sourceLocation == null) break block8;
            if (this.targetAllWorlds) {
                worlds = Bukkit.getWorlds();
            } else {
                worlds = new ArrayList<World>();
                worlds.add(sourceLocation.getWorld());
            }
            for (World world : worlds) {
                List entities = world.getEntities();
                for (Entity entity : entities) {
                    if (!spell.canTarget(entity) || !this.targetSelf && entity == sourceEntity) continue;
                    actionContext.setTargetEntity(entity);
                    actionContext.setTargetLocation(entity.getLocation());
                    SpellResult entityResult = this.performActions(actionContext);
                    result = result.min(entityResult);
                }
            }
        }
        return result;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        parameters.add("target_self");
        parameters.add("target_all_worlds");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("target_self") || parameterKey.equals("target_all_worlds")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }
}

