/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class WandUpgradePath
implements com.elmakers.mine.bukkit.api.wand.WandUpgradePath {
    private static Map<String, WandUpgradePath> paths = new HashMap<String, WandUpgradePath>();
    private TreeMap<Integer, WandLevel> levelMap = null;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private List<String> upgradeCommands;
    private int[] levels = null;
    private final String key;
    private final WandUpgradePath parent;
    private final Set<String> spells = new HashSet<String>();
    private final Set<String> requiredSpells = new HashSet<String>();
    private String upgradeKey;
    private String upgradeItemKey;
    private String name;
    private String description;
    private boolean hidden = false;
    private boolean matchSpellMana = true;
    private int maxUses = 500;
    private int maxMaxXp = 1500;
    private int maxXpRegeneration = 150;
    private float maxHungerRegeneration = 2.0f;
    private float maxHealthRegeneration = 2.0f;
    private float maxDamageReduction = 0.4f;
    private float maxDamageReductionExplosions = 0.3f;
    private float maxDamageReductionFalling = 0.9f;
    private float maxDamageReductionFire = 0.5f;
    private float maxDamageReductionPhysical = 0.1f;
    private float maxDamageReductionProjectiles = 0.2f;
    private float maxCostReduction = 0.5f;
    private float maxCooldownReduction = 0.5f;
    private float maxHaste = 1.0f;
    private float maxPower = 1.0f;
    private int minLevel = 10;
    private int maxLevel = 50;
    private float bonusLevelMultiplier = 0.5f;

    public WandUpgradePath(MageController controller, String key, WandUpgradePath inherit, ConfigurationSection template) {
        this.parent = inherit;
        this.key = key;
        this.levels = inherit.levels;
        this.maxMaxXp = inherit.maxMaxXp;
        this.maxXpRegeneration = inherit.maxXpRegeneration;
        this.maxHungerRegeneration = inherit.maxHungerRegeneration;
        this.maxHealthRegeneration = inherit.maxHealthRegeneration;
        this.maxDamageReduction = inherit.maxDamageReduction;
        this.maxDamageReductionExplosions = inherit.maxDamageReductionExplosions;
        this.maxDamageReductionFalling = inherit.maxDamageReductionFalling;
        this.maxDamageReductionFire = inherit.maxDamageReductionFire;
        this.maxDamageReductionPhysical = inherit.maxDamageReductionPhysical;
        this.maxDamageReductionProjectiles = inherit.maxDamageReductionProjectiles;
        this.maxCostReduction = inherit.maxCostReduction;
        this.maxHaste = inherit.maxHaste;
        this.maxPower = inherit.maxPower;
        this.minLevel = inherit.minLevel;
        this.maxLevel = inherit.maxLevel;
        this.matchSpellMana = inherit.matchSpellMana;
        this.levelMap = new TreeMap<Integer, WandLevel>((SortedMap<Integer, WandLevel>)inherit.levelMap);
        this.effects.putAll(inherit.effects);
        this.load(controller, key, template);
        if ((this.upgradeCommands == null || this.upgradeCommands.size() == 0) && inherit.upgradeCommands != null) {
            this.upgradeCommands = new ArrayList<String>();
            this.upgradeCommands.addAll(inherit.upgradeCommands);
        }
    }

    public WandUpgradePath(MageController controller, String key, ConfigurationSection template) {
        this.key = key;
        this.parent = null;
        this.load(controller, key, template);
    }

    protected void load(MageController controller, String key, ConfigurationSection template) {
        ConfigurationSection spellSection = template.getConfigurationSection("spells");
        if (spellSection != null) {
            this.spells.addAll(spellSection.getKeys(false));
        }
        this.upgradeKey = template.getString("upgrade");
        this.upgradeItemKey = template.getString("upgrade_item");
        this.requiredSpells.addAll(template.getStringList("required_spells"));
        this.matchSpellMana = template.getBoolean("match_spell_mana", this.matchSpellMana);
        this.hidden = template.getBoolean("hidden", false);
        Messages messages = controller.getMessages();
        this.name = template.getString("name", this.name);
        this.name = messages.get("paths." + key + ".name", this.name);
        this.description = template.getString("description", this.description);
        this.description = messages.get("paths." + key + ".description", this.description);
        this.upgradeCommands = template.getStringList("upgrade_commands");
        if (template.contains("effects")) {
            this.effects.clear();
            ConfigurationSection effectsNode = template.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(controller.getPlugin(), effectsNode, effectKey));
            }
        }
        this.maxUses = template.getInt("max_uses", this.maxUses);
        this.maxMaxXp = template.getInt("max_mana", this.maxMaxXp);
        this.maxXpRegeneration = template.getInt("max_mana_regeneration", this.maxXpRegeneration);
        this.maxHealthRegeneration = (float)template.getDouble("max_health_regeneration", (double)this.maxHealthRegeneration);
        this.maxHungerRegeneration = (float)template.getDouble("max_hunger_regeneration", (double)this.maxHungerRegeneration);
        this.minLevel = template.getInt("min_enchant_level", this.minLevel);
        this.maxLevel = template.getInt("max_enchant_level", this.maxLevel);
        this.maxDamageReduction = (float)template.getDouble("max_damage_reduction", (double)this.maxDamageReduction);
        this.maxDamageReduction = (float)template.getDouble("max_damage_reduction_explosions", (double)this.maxDamageReductionExplosions);
        this.maxDamageReduction = (float)template.getDouble("max_damage_reduction_falling", (double)this.maxDamageReductionFalling);
        this.maxDamageReduction = (float)template.getDouble("max_damage_reduction_fire", (double)this.maxDamageReductionFire);
        this.maxDamageReduction = (float)template.getDouble("max_damage_reduction_physical", (double)this.maxDamageReductionPhysical);
        this.maxDamageReduction = (float)template.getDouble("max_damage_reduction_projectiles", (double)this.maxDamageReductionProjectiles);
        this.maxCostReduction = (float)template.getDouble("max_cost_reduction", (double)this.maxCostReduction);
        this.maxCooldownReduction = (float)template.getDouble("max_cooldown_reduction", (double)this.maxCooldownReduction);
        this.maxHaste = (float)template.getDouble("max_haste", (double)this.maxHaste);
        if (this.levelMap == null) {
            this.levelMap = new TreeMap();
        }
        if (template.contains("levels")) {
            String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
            this.levels = new int[levelStrings.length];
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = Integer.parseInt(levelStrings[i]);
            }
        }
        if (this.levels == null) {
            return;
        }
        for (int level = 1; level <= this.levels[this.levels.length - 1]; ++level) {
            int levelIndex;
            int nextLevelIndex = 0;
            float distance = 1.0f;
            for (levelIndex = 0; levelIndex < this.levels.length; ++levelIndex) {
                if (level == this.levels[levelIndex] || levelIndex == this.levels.length - 1) {
                    nextLevelIndex = levelIndex;
                    distance = 0.0f;
                    break;
                }
                if (level >= this.levels[levelIndex + 1]) continue;
                nextLevelIndex = levelIndex + 1;
                int previousLevel = this.levels[levelIndex];
                int nextLevel = this.levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
                break;
            }
            WandLevel wandLevel = this.levelMap.get(level);
            WandLevel newLevel = new WandLevel(this, template, levelIndex, nextLevelIndex, distance);
            if (wandLevel == null) {
                wandLevel = newLevel;
            } else {
                newLevel.add(wandLevel);
                wandLevel = newLevel;
            }
            this.levelMap.put(level, wandLevel);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public WandLevel getLevel(int level) {
        if (this.levelMap == null) {
            return null;
        }
        if (!this.levelMap.containsKey(level)) {
            if (level > this.levelMap.lastKey()) {
                return this.levelMap.lastEntry().getValue();
            }
            return this.levelMap.firstEntry().getValue();
        }
        return this.levelMap.get(level);
    }

    protected static WandUpgradePath getPath(MageController controller, String key, ConfigurationSection configuration) {
        WandUpgradePath path = paths.get(key);
        if (path == null) {
            ConfigurationSection parameters = configuration.getConfigurationSection(key);
            if (!parameters.getBoolean("enabled", true)) {
                return null;
            }
            String inheritKey = parameters.getString("inherit");
            if (inheritKey != null && !inheritKey.isEmpty()) {
                WandUpgradePath inherit = WandUpgradePath.getPath(controller, inheritKey, configuration);
                if (inherit == null) {
                    Bukkit.getLogger().warning("Failed to load inherited enchanting path '" + inheritKey + "' for path: " + key);
                    return null;
                }
                path = new WandUpgradePath(controller, key, inherit, parameters);
            } else {
                path = new WandUpgradePath(controller, key, parameters);
            }
            paths.put(key, path);
        }
        return path;
    }

    public static void loadPaths(MageController controller, ConfigurationSection configuration) {
        paths.clear();
        Set pathKeys = configuration.getKeys(false);
        for (String key : pathKeys) {
            WandUpgradePath.getPath(controller, key, configuration);
        }
    }

    public static Set<String> getPathKeys() {
        return paths.keySet();
    }

    public static WandUpgradePath getPath(String key) {
        return paths.get(key);
    }

    public int getMaxLevel() {
        if (this.levels == null) {
            return 0;
        }
        return Math.min(this.levels[this.levels.length - 1], this.maxLevel);
    }

    public Set<Integer> getLevels() {
        if (this.levelMap == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        for (Integer level : this.levelMap.keySet()) {
            if (level < this.minLevel || level > this.maxLevel) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getMaxMaxXp() {
        return this.maxMaxXp;
    }

    public int getMaxXpRegeneration() {
        return this.maxXpRegeneration;
    }

    public float getMaxHungerRegeneration() {
        return this.maxHungerRegeneration;
    }

    public float getMaxHealthRegeneration() {
        return this.maxHealthRegeneration;
    }

    public float getMaxDamageReduction() {
        return this.maxDamageReduction;
    }

    public float getMaxDamageReductionExplosions() {
        return this.maxDamageReductionExplosions;
    }

    public float getMaxDamageReductionFalling() {
        return this.maxDamageReductionFalling;
    }

    public float getMaxDamageReductionFire() {
        return this.maxDamageReductionFire;
    }

    public float getMaxDamageReductionPhysical() {
        return this.maxDamageReductionPhysical;
    }

    public float getMaxDamageReductionProjectiles() {
        return this.maxDamageReductionProjectiles;
    }

    public float getMaxCostReduction() {
        return this.maxCostReduction;
    }

    public float getMaxCooldownReduction() {
        return this.maxCooldownReduction;
    }

    public float getMaxHaste() {
        return this.maxHaste;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    @Override
    public Collection<String> getSpells() {
        return new ArrayList<String>(this.spells);
    }

    @Override
    public Collection<String> getRequiredSpells() {
        return new ArrayList<String>(this.requiredSpells);
    }

    @Override
    public boolean requiresSpell(String spellKey) {
        return this.requiredSpells.contains(spellKey);
    }

    @Override
    public boolean hasSpell(String spellKey) {
        return this.spells.contains(spellKey);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void playEffects(Mage mage, String effectType) {
        Collection<EffectPlayer> players = this.effects.get(effectType);
        if (players == null || mage == null) {
            return;
        }
        Entity sourceEntity = mage.getEntity();
        Location mageLocation = mage.getEyeLocation();
        for (EffectPlayer player : players) {
            player.setColor(mage.getEffectColor());
            player.start(mageLocation, sourceEntity, null, null);
        }
    }

    public void enchanted(Mage mage) {
        this.playEffects(mage, "enchant");
    }

    private void applyUpgradeItem(Wand wand, Mage mage) {
        com.elmakers.mine.bukkit.api.wand.Wand upgradeWand;
        if (this.upgradeItemKey != null && !this.upgradeItemKey.isEmpty() && (upgradeWand = mage.getController().createWand(this.upgradeItemKey)) != null) {
            wand.add(upgradeWand);
        }
    }

    private void applyUpgradeItems(Wand wand, Mage mage) {
        this.applyUpgradeItem(wand, mage);
        if (this.parent != null) {
            this.parent.applyUpgradeItems(wand, mage);
        }
    }

    public void catchup(Wand wand, Mage mage) {
        if (this.parent != null) {
            this.parent.applyUpgradeItems(wand, mage);
        }
    }

    public void upgraded(com.elmakers.mine.bukkit.api.wand.Wand wand, Mage mage) {
        com.elmakers.mine.bukkit.api.wand.Wand upgradeWand;
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        Location location = null;
        if (mage != null) {
            this.playEffects(mage, "upgrade");
            location = mage.getLocation();
        }
        if (this.upgradeCommands != null) {
            for (String command : this.upgradeCommands) {
                if (command.contains("@uuid") || command.contains("@pn") || command.contains("@pd")) {
                    if (mage == null) {
                        Bukkit.getLogger().warning("Tried to upgrade with commands but no mage");
                        continue;
                    }
                    command = command.replace("@uuid", mage.getId()).replace("@pn", mage.getName()).replace("@pd", mage.getDisplayName());
                }
                if (location != null) {
                    command = command.replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                }
                WandUpgradePath upgrade = WandUpgradePath.getPath(this.upgradeKey);
                command = command.replace("$path", upgrade.getName());
                wand.getController().getPlugin().getServer().dispatchCommand((CommandSender)sender, command);
            }
        }
        if (this.upgradeItemKey != null && !this.upgradeItemKey.isEmpty() && (upgradeWand = wand.getController().createWand(this.upgradeItemKey)) != null) {
            wand.add(upgradeWand, mage);
        }
    }

    @Override
    public boolean hasUpgrade() {
        return this.upgradeKey != null && !this.upgradeKey.isEmpty();
    }

    @Override
    public WandUpgradePath getUpgrade() {
        return WandUpgradePath.getPath(this.upgradeKey);
    }

    public boolean getMatchSpellMana() {
        return this.matchSpellMana;
    }

    public boolean checkEnchant(Wand wand) {
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        int spellCount = maxLevel.getSpellCount();
        int materialCount = maxLevel.getMaterialCount();
        LinkedList<WeightedPair<String>> remainingSpells = maxLevel.getRemainingSpells(wand);
        LinkedList<WeightedPair<String>> remainingMaterials = maxLevel.getRemainingMaterials(wand);
        return spellCount > 0 && remainingSpells.size() > 0 || materialCount > 0 && remainingMaterials.size() > 0;
    }

    @Override
    public boolean checkUpgradeRequirements(com.elmakers.mine.bukkit.api.wand.Wand wand, Mage mage) {
        if (this.requiredSpells == null && this.requiredSpells.isEmpty()) {
            return true;
        }
        for (String requiredKey : this.requiredSpells) {
            if (wand.hasSpell(requiredKey)) continue;
            SpellTemplate spell = wand.getController().getSpellTemplate(requiredKey);
            if (spell == null) {
                wand.getController().getLogger().warning("Invalid spell required for upgrade: " + requiredKey);
                continue;
            }
            if (mage != null) {
                String message = wand.getController().getMessages().get("spell.required_spell").replace("$spell", spell.getName());
                WandUpgradePath upgradePath = this.getUpgrade();
                if (upgradePath != null) {
                    message = message.replace("$path", upgradePath.getName());
                }
                mage.sendMessage(message);
            }
            return false;
        }
        return true;
    }

    public float getBonusLevelMultiplier() {
        return this.bonusLevelMultiplier;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean hasPath(String pathName) {
        if (this.key.equalsIgnoreCase(pathName)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasPath(pathName);
        }
        return false;
    }

    @Override
    public void upgrade(com.elmakers.mine.bukkit.api.wand.Wand wand, Mage mage) {
        WandUpgradePath newPath = this.getUpgrade();
        if (newPath == null) {
            if (mage != null) {
                mage.sendMessage("Configuration issue, please check logs");
            }
            wand.getController().getLogger().warning("Invalid upgrade path: " + this.getUpgrade());
            return;
        }
        if (mage != null) {
            MageController controller = mage.getController();
            mage.sendMessage(controller.getMessages().get("wand.level_up").replace("$wand", wand.getName()).replace("$path", newPath.getName()));
        }
        this.upgraded(wand, mage);
        wand.setPath(newPath.getKey());
    }
}

