/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public abstract class CompoundAction
extends BaseSpellAction {
    private boolean usesBrush = false;
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    protected ActionHandler actions = null;

    @Override
    public void initialize(Spell spell, ConfigurationSection template) {
        super.initialize(spell, template);
        this.usesBrush = false;
        this.undoable = false;
        if (template != null) {
            if (template.contains("actions")) {
                this.actions = new ActionHandler(this.getSpell());
                this.actions.load(template, "actions");
                this.usesBrush = this.usesBrush || this.actions.usesBrush();
                this.undoable = this.undoable || this.actions.isUndoable();
                this.requiresBuildPermission = this.requiresBuildPermission || this.actions.requiresBuildPermission();
            }
            this.undoable = template.getBoolean("undoable", this.undoable);
        }
    }

    protected SpellResult perform(ConfigurationSection parameters, Location targetLocation, Collection<Entity> targetEntities) {
        if (this.actions == null) {
            return SpellResult.FAIL;
        }
        for (Entity entity : targetEntities) {
            this.addTargetEntity(entity);
        }
        return this.actions.perform(parameters, targetLocation, targetEntities);
    }

    protected SpellResult perform(ConfigurationSection parameters, Location targetLocation) {
        if (this.actions == null) {
            return SpellResult.FAIL;
        }
        return this.actions.perform(parameters, targetLocation);
    }

    protected SpellResult perform(ConfigurationSection parameters, Entity targetEntity) {
        if (this.actions == null || targetEntity == null) {
            return SpellResult.FAIL;
        }
        return this.actions.perform(parameters, targetEntity.getLocation(), targetEntity);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public boolean usesBrush() {
        return this.usesBrush;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        if (this.actions != null) {
            this.actions.getParameterNames(parameters);
        }
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (this.actions != null) {
            this.actions.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public String transformMessage(String message) {
        if (this.actions == null) {
            return message;
        }
        return this.actions.transformMessage(message);
    }
}

