/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.StringParser;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class TextLocationEffect
extends LocationEffect {
    public ParticleEffect particle = ParticleEffect.FIREWORKS_SPARK;
    public String text = "Text";
    public boolean invert = false;
    public int stepX = 1;
    public int stepY = 1;
    public float size = 0.2f;
    public boolean realtime = false;
    public Font font;
    protected BufferedImage image = null;

    public TextLocationEffect(EffectManager effectManager, Location location) {
        this(effectManager, location, new Font("Tahoma", 0, 16));
    }

    public TextLocationEffect(EffectManager effectManager, Location location, Font font) {
        super(effectManager, location);
        this.font = font;
        this.type = EffectType.REPEATING;
        this.period = 40;
        this.iterations = 20;
    }

    @Override
    public void onRun() {
        int clr = 0;
        try {
            if (this.image == null || this.realtime) {
                this.image = StringParser.stringToBufferedImage(this.font, this.text);
            }
            for (int y = 0; y < this.image.getHeight(); y += this.stepY) {
                for (int x = 0; x < this.image.getWidth(); x += this.stepX) {
                    clr = this.image.getRGB(x, y);
                    if (!this.invert && Color.black.getRGB() != clr || this.invert && Color.black.getRGB() == clr) continue;
                    Vector v = new Vector((float)this.image.getWidth() / 2.0f - (float)x, (float)this.image.getHeight() / 2.0f - (float)y, 0.0f).multiply(this.size);
                    VectorUtils.rotateAroundAxisY(v, -this.location.getYaw() * ((float)Math.PI / 180));
                    this.particle.display(this.location.add(v), this.visibleRange);
                    this.location.subtract(v);
                }
            }
        }
        catch (Exception ex) {
            this.cancel(true);
        }
    }
}

