/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.effect.Hologram;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HoloUtils
extends NMSUtils {
    private static int WITHER_SKULL_TYPE = 66;
    private static int HORSE_AGE_OFFSET = -1700000;
    private static int Y_OFFSET = 55;
    protected static boolean enabled = true;
    protected static Class<?> class_EntityHorse;
    protected static Class<?> class_EntityWitherSkull;
    protected static Class<?> class_PacketPlayOutAttachEntity;
    protected static Class<?> class_PacketPlayOutEntityDestroy;
    protected static Class<?> class_PacketPlayOutSpawnEntity;
    protected static Class<?> class_PacketPlayOutSpawnEntityLiving;

    protected static Object createSkull(Location location) {
        Object skull = null;
        try {
            Object world = HoloUtils.getHandle(location.getWorld());
            Constructor<?> skullConstructor = class_EntityWitherSkull.getConstructor(class_World);
            skull = skullConstructor.newInstance(world);
            Method setLocationMethod = skull.getClass().getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setLocationMethod.invoke(skull, location.getX(), location.getY() + (double)Y_OFFSET, location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            skull = null;
        }
        return skull;
    }

    protected static Object createHorse(Location location, String text) {
        Object horse = null;
        try {
            Object world = HoloUtils.getHandle(location.getWorld());
            Constructor<?> horseConstructor = class_EntityHorse.getConstructor(class_World);
            horse = horseConstructor.newInstance(world);
            Method setAgeMethod = horse.getClass().getMethod("setAge", Integer.TYPE);
            setAgeMethod.invoke(horse, HORSE_AGE_OFFSET);
            Method setCustomNameVisibleMethod = horse.getClass().getMethod("setCustomNameVisible", Boolean.TYPE);
            setCustomNameVisibleMethod.invoke(horse, true);
            Method setLocationMethod = horse.getClass().getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setLocationMethod.invoke(horse, location.getX(), location.getY() + (double)Y_OFFSET, location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
            Method setCustomNameMethod = horse.getClass().getMethod("setCustomName", String.class);
            setCustomNameMethod.invoke(horse, text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            horse = null;
        }
        return horse;
    }

    protected static boolean teleport(Location location, Object skull, Object horse) {
        try {
            Method setLocationMethod = horse.getClass().getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setLocationMethod.invoke(horse, location.getX(), location.getY() + (double)Y_OFFSET, location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
            setLocationMethod = skull.getClass().getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setLocationMethod.invoke(skull, location.getX(), location.getY() + (double)Y_OFFSET, location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected static boolean rename(String text, Object horse) {
        try {
            Method setCustomNameMethod = horse.getClass().getMethod("setCustomName", String.class);
            setCustomNameMethod.invoke(horse, text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected static boolean sendToPlayer(Player player, Object skull, Object horse) {
        try {
            Constructor<?> packetSpawnLivingEntityConstructor = class_PacketPlayOutSpawnEntityLiving.getConstructor(class_EntityLiving);
            Object horsePacket = packetSpawnLivingEntityConstructor.newInstance(horse);
            Constructor<?> packetSpawnEntityConstructor = class_PacketPlayOutSpawnEntity.getConstructor(class_Entity, Integer.TYPE);
            Object skullPacket = packetSpawnEntityConstructor.newInstance(skull, WITHER_SKULL_TYPE);
            Constructor<?> packetAttachEntityConstructor = class_PacketPlayOutAttachEntity.getConstructor(Integer.TYPE, class_Entity, class_Entity);
            Object attachPacket = packetAttachEntityConstructor.newInstance(0, horse, skull);
            HoloUtils.sendPacket(player, horsePacket);
            HoloUtils.sendPacket(player, skullPacket);
            HoloUtils.sendPacket(player, attachPacket);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected static boolean removeFromPlayer(Player player, Object skull, Object horse) {
        try {
            Method getHorseIdMethod = horse.getClass().getMethod("getId", new Class[0]);
            Method getSkullIdMethod = skull.getClass().getMethod("getId", new Class[0]);
            int horseId = (Integer)getHorseIdMethod.invoke(horse, new Object[0]);
            int skullId = (Integer)getSkullIdMethod.invoke(skull, new Object[0]);
            Constructor<?> packetDestroyEntityConstructor = class_PacketPlayOutEntityDestroy.getConstructor(int[].class);
            Object destroyPacket = packetDestroyEntityConstructor.newInstance(new Object[]{new int[]{horseId, skullId}});
            HoloUtils.sendPacket(player, destroyPacket);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static Hologram createHoloText(Location location, String text) {
        if (!enabled) {
            return null;
        }
        return new Hologram(location, text);
    }

    static {
        try {
            class_EntityHorse = HoloUtils.fixBukkitClass("net.minecraft.server.EntityHorse");
            class_EntityWitherSkull = HoloUtils.fixBukkitClass("net.minecraft.server.EntityWitherSkull");
            class_PacketPlayOutAttachEntity = HoloUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutAttachEntity");
            class_PacketPlayOutEntityDestroy = HoloUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutEntityDestroy");
            class_PacketPlayOutSpawnEntity = HoloUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutSpawnEntity");
            class_PacketPlayOutSpawnEntityLiving = HoloUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutSpawnEntityLiving");
        }
        catch (Throwable ex) {
            enabled = false;
            ex.printStackTrace();
        }
    }
}

